/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Provider;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.ProviderInfo;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ViewDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ColumnInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;

class CreateViewConstantAction
extends DDLConstantAction {
    private final String tableName;
    private final String schemaName;
    private final String viewText;
    private final int tableType;
    private final int checkOption;
    private final ColumnInfo[] columnInfo;
    private final ProviderInfo[] providerInfo;
    private final UUID compSchemaId;

    CreateViewConstantAction(String schemaName, String tableName, int tableType, String viewText, int checkOption, ColumnInfo[] columnInfo, ProviderInfo[] providerInfo, UUID compSchemaId) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.tableType = tableType;
        this.viewText = viewText;
        this.checkOption = checkOption;
        this.columnInfo = columnInfo;
        this.providerInfo = providerInfo;
        this.compSchemaId = compSchemaId;
        SanityManager.ASSERT((schemaName != null ? 1 : 0) != 0, (String)"Schema name is null");
    }

    public String toString() {
        return this.constructToString("CREATE VIEW ", this.tableName);
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        SchemaDescriptor sd = this.getSchemaDescriptorForCreate(dd, activation, this.schemaName);
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        TableDescriptor td = ddg.newTableDescriptor(this.tableName, sd, this.tableType, 'R', false);
        dd.addDescriptor(td, sd, 1, false, tc);
        UUID toid = td.getUUID();
        TupleDescriptor[] cdlArray = new ColumnDescriptor[this.columnInfo.length];
        int index = 1;
        for (int ix = 0; ix < this.columnInfo.length; ++ix) {
            ColumnDescriptor columnDescriptor = new ColumnDescriptor(this.columnInfo[ix].name, index++, this.columnInfo[ix].dataType, this.columnInfo[ix].defaultValue, this.columnInfo[ix].defaultInfo, td, null, this.columnInfo[ix].autoincStart, this.columnInfo[ix].autoincInc, this.columnInfo[ix].isGeneratedByDefault);
            cdlArray[ix] = columnDescriptor;
        }
        dd.addDescriptorArray(cdlArray, td, 2, false, tc);
        ColumnDescriptorList cdl = td.getColumnDescriptorList();
        for (int i = 0; i < cdlArray.length; ++i) {
            cdl.add(cdlArray[i]);
        }
        ViewDescriptor vd = ddg.newViewDescriptor(toid, this.tableName, this.viewText, this.checkOption, this.compSchemaId == null ? lcc.getDefaultSchema().getUUID() : this.compSchemaId);
        for (int ix = 0; ix < this.providerInfo.length; ++ix) {
            Provider provider = (Provider)this.providerInfo[ix].getDependableFinder().getDependable(dd, this.providerInfo[ix].getObjectId());
            dm.addDependency(vd, provider, lcc.getContextManager());
        }
        this.storeViewTriggerDependenciesOnPrivileges(activation, vd);
        dd.addDescriptor(vd, sd, 8, true, tc);
    }

    @Override
    public final String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public final String getTableName() {
        return this.tableName;
    }
}

