/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassInspector;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AggregateDefinition;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CountAggregateDefinition;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.HasNodeVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.MaxMinAggregateDefinition;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SumAvgAggregateDefinition;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UntypedNullConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public class AggregateNode
extends UnaryOperatorNode {
    private boolean distinct;
    private boolean isCountStar;
    private boolean isAvg;
    private AggregateDefinition uad;
    private StringBuilder aggregatorClassName;
    private String aggregateDefinitionClassName;
    private Class aggregateDefinitionClass;
    private ClassInspector classInspector;
    private String aggregateName;
    private ResultColumn generatedRC;
    private ColumnReference generatedRef;

    @Override
    public void init(Object operand, Object uadClass, Object distinct, Object isCountStar, Object isAvg, Object aggregateName) throws StandardException {
        super.init(operand);
        this.aggregateName = (String)aggregateName;
        this.isCountStar = (Boolean)isCountStar;
        this.isAvg = (Boolean)isAvg;
        if (uadClass instanceof String) {
            this.aggregateDefinitionClassName = (String)uadClass;
            this.distinct = (Boolean)distinct;
        } else {
            this.aggregateDefinitionClass = (Class)uadClass;
            this.aggregateDefinitionClassName = this.aggregateDefinitionClass.getName();
            if (!this.aggregateDefinitionClass.equals(MaxMinAggregateDefinition.class)) {
                this.distinct = (Boolean)distinct;
            }
        }
    }

    public ValueNode replaceAggregatesWithColumnReferences(ResultColumnList rcl, int tableNumber) throws StandardException {
        if (this.generatedRef == null) {
            CompilerContext cc = this.getCompilerContext();
            String generatedColName = "SQLCol" + cc.getNextColumnNumber();
            this.generatedRC = (ResultColumn)this.getNodeFactory().getNode(80, generatedColName, this, this.getContextManager());
            this.generatedRC.markGenerated();
            this.generatedRef = (ColumnReference)this.getNodeFactory().getNode(62, this.generatedRC.getName(), null, this.getContextManager());
            this.generatedRef.setSource(this.generatedRC);
            this.generatedRef.setNestingLevel(0);
            this.generatedRef.setSourceLevel(0);
            if (tableNumber != -1) {
                this.generatedRef.setTableNumber(tableNumber);
            }
            rcl.addResultColumn(this.generatedRC);
            this.generatedRef.markGeneratedToReplaceAggregate();
        } else {
            rcl.addResultColumn(this.generatedRC);
        }
        return this.generatedRef;
    }

    AggregateDefinition getAggregateDefinition() {
        return this.uad;
    }

    public ResultColumn getGeneratedRC() {
        SanityManager.ASSERT((this.generatedRC != null ? 1 : 0) != 0, (String)"generatedRC is null.  replaceAggregatesWithColumnReferences() has not been called on this AggergateNode.  Make sure the node is under a ResultColumn as expected.");
        return this.generatedRC;
    }

    public ColumnReference getGeneratedRef() {
        SanityManager.ASSERT((this.generatedRef != null ? 1 : 0) != 0, (String)"generatedRef is null.  replaceAggregateWithColumnReference() has not been called on this AggergateNode.  Make sure the node is under a ResultColumn as expected.");
        return this.generatedRef;
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        DataTypeDescriptor dts = null;
        ClassFactory cf = this.getClassFactory();
        this.classInspector = cf.getClassInspector();
        this.instantiateAggDef();
        boolean isObjectAlreadyAdded = false;
        for (Object o : aggregateVector) {
            if (o != this) continue;
            isObjectAlreadyAdded = true;
            break;
        }
        if (!isObjectAlreadyAdded) {
            aggregateVector.addElement(this);
        }
        if (this.operand != null) {
            this.bindOperand(fromList, subqueryList, aggregateVector);
            HasNodeVisitor visitor = new HasNodeVisitor(this.getClass(), ResultSetNode.class);
            this.operand.accept(visitor);
            if (visitor.hasNode()) {
                throw StandardException.newException("42Y33", this.aggregateName);
            }
            dts = this.operand.getTypeServices();
            if (this.uad instanceof CountAggregateDefinition && !dts.isNullable()) {
                this.setOperator(this.aggregateName);
                this.setMethodName(this.aggregateName);
            }
            if (this.distinct && !this.operand.getTypeId().orderable(cf)) {
                throw StandardException.newException("X0X67.S", dts.getTypeId().getSQLTypeName());
            }
            if (this.operand instanceof UntypedNullConstantNode) {
                throw StandardException.newException("42Y83", this.aggregateName);
            }
        }
        this.aggregatorClassName = new StringBuilder();
        DataTypeDescriptor resultType = this.uad.getAggregator(dts, this.aggregatorClassName, this.isAvg);
        if (resultType == null) {
            throw StandardException.newException("42Y22", (Object)(this.isAvg ? "AVG" : this.aggregateName), (Object)this.operand.getTypeId().getSQLTypeName());
        }
        this.checkAggregatorClassName(this.aggregatorClassName.toString());
        this.setType(resultType);
        return this;
    }

    private void checkAggregatorClassName(String className) throws StandardException {
        this.verifyClassExist(className);
        if (!this.classInspector.assignableTo(className, "com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecAggregator")) {
            throw StandardException.newException("42Y32", (Object)className, (Object)this.aggregateName, (Object)this.operand.getTypeId().getSQLTypeName());
        }
    }

    private void instantiateAggDef() throws StandardException {
        Class theClass = this.aggregateDefinitionClass;
        if (theClass == null) {
            String aggClassName = this.aggregateDefinitionClassName;
            this.verifyClassExist(aggClassName);
            try {
                theClass = this.classInspector.getClass(aggClassName);
            }
            catch (Throwable t) {
                throw StandardException.unexpectedUserException(t);
            }
        }
        Object instance = null;
        try {
            instance = theClass.newInstance();
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
        if (!(instance instanceof AggregateDefinition)) {
            throw StandardException.newException("42Y00", this.aggregateDefinitionClassName);
        }
        if (instance instanceof MaxMinAggregateDefinition) {
            MaxMinAggregateDefinition temp = instance;
            if (this.aggregateName.equals("MAX")) {
                temp.setMaxOrMin(true);
            } else {
                temp.setMaxOrMin(false);
            }
        }
        if (instance instanceof SumAvgAggregateDefinition) {
            SumAvgAggregateDefinition temp1 = instance;
            if (this.aggregateName.equals("SUM")) {
                temp1.setSumOrAvg(true);
            } else {
                temp1.setSumOrAvg(false);
            }
            if (this.distinct) {
                temp1.markDistinct();
            }
        }
        if (instance instanceof CountAggregateDefinition && this.distinct) {
            ((CountAggregateDefinition)instance).markDistinct();
        }
        this.uad = instance;
        this.setOperator(this.aggregateName);
        this.setMethodName(this.aggregateDefinitionClassName);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public String getAggregatorClassName() {
        return this.aggregatorClassName.toString();
    }

    public String getAggregateName() {
        return this.aggregateName;
    }

    public ResultColumn getNewAggregatorResultColumn(DataDictionary dd) throws StandardException {
        String className = this.aggregatorClassName.toString();
        DataTypeDescriptor compType = DataTypeDescriptor.getSQLDataTypeDescriptor(className);
        ConstantNode nullNode = this.getNullNode(compType);
        nullNode.bindExpression(null, null, null);
        return (ResultColumn)this.getNodeFactory().getNode(80, this.aggregateName, nullNode, this.getContextManager());
    }

    public ResultColumn getNewExpressionResultColumn(DataDictionary dd) throws StandardException {
        ValueNode node = this.operand == null ? this.getNewNullResultExpression() : this.operand;
        return (ResultColumn)this.getNodeFactory().getNode(80, "##aggregate expression", node, this.getContextManager());
    }

    public ValueNode getNewNullResultExpression() throws StandardException {
        return this.getNullNode(this.getTypeServices());
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.THROWASSERT((String)"generateExpression() should never be called on an AggregateNode.  replaceAggregatesWithColumnReferences should have been called prior to generateExpression");
    }

    @Override
    public String toString() {
        return "Aggregate: " + this.aggregateName + "\ndistinct: " + this.distinct + "\n" + super.toString();
    }

    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean constantExpression(PredicateList where) {
        return false;
    }

    public boolean isCountStarAggregate() {
        return this.isCountStar;
    }

    @Override
    public ValueNode genExpressionOperands(ResultColumnList outerResultColumns, ResultColumn parentRC, boolean remapToNew) throws StandardException {
        if (parentRC != null) {
            outerResultColumns.addResultColumn(parentRC);
            return this;
        }
        ResultColumn resultColumn = null;
        resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, this.toString(), this, this.getContextManager());
        outerResultColumns.addResultColumn(resultColumn);
        return this;
    }
}

