/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.drda;

import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineConnection;
import java.sql.SQLException;

class PiggyBackedSessionData {
    private int iso_;
    private boolean isoMod_;
    private String schema_;
    private boolean schemaMod_;
    private final EngineConnection conn_;
    private boolean svrVerSent;

    public static PiggyBackedSessionData getInstance(PiggyBackedSessionData existing, EngineConnection conn, boolean createOnDemand) throws SQLException {
        if (conn == null || !conn.isActive() || existing != null && existing.conn_ != conn) {
            return null;
        }
        if (existing == null && createOnDemand) {
            return new PiggyBackedSessionData(conn);
        }
        return existing;
    }

    private PiggyBackedSessionData(EngineConnection conn) throws SQLException {
        this.conn_ = conn;
        this.iso_ = -1;
    }

    public void refresh() throws SQLException {
        String schema;
        this.setUnmodified();
        int iso = this.conn_.getTransactionIsolation();
        if (iso != this.iso_) {
            this.isoMod_ = true;
            this.iso_ = iso;
        }
        if (!(schema = this.conn_.getCurrentSchemaName()).equals(this.schema_)) {
            this.schemaMod_ = true;
            this.schema_ = schema;
        }
    }

    public void setUnmodified() {
        this.isoMod_ = false;
        this.schemaMod_ = false;
    }

    public boolean isIsoModified() {
        return this.isoMod_;
    }

    public boolean isSchemaModified() {
        return this.schemaMod_;
    }

    public boolean isModified() {
        return this.isoMod_ || this.schemaMod_;
    }

    public int getIso() {
        return this.iso_;
    }

    public String getSchema() {
        return this.schema_;
    }

    public String toString() {
        return "iso:" + this.iso_ + (this.isoMod_ ? "(M)" : "") + " schema:" + this.schema_ + (this.schemaMod_ ? "(M)" : "");
    }

    public TXId getTXId() {
        TXStateInterface tx;
        GemFireTransaction gft;
        if (this.conn_ != null && (gft = (GemFireTransaction)this.conn_.getLanguageConnectionContext().getTransactionCompile()) != null && (tx = gft.getActiveTXState()) != null) {
            return tx.getTransactionId();
        }
        return null;
    }

    public boolean serverVersionSent() {
        return this.svrVerSent;
    }

    public void setServerVersionSent(boolean flag) {
        this.svrVerSent = flag;
    }
}

