/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.PermissionsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatementPermission;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TablePermsDescriptor;

public class StatementTablePermission
extends StatementPermission {
    UUID tableUUID;
    int privType;

    public StatementTablePermission(UUID tableUUID, int privType) {
        this.tableUUID = tableUUID;
        this.privType = privType;
    }

    public int getPrivType() {
        return this.privType;
    }

    public UUID getTableUUID() {
        return this.tableUUID;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass().equals(obj.getClass())) {
            StatementTablePermission other = (StatementTablePermission)obj;
            return this.privType == other.privType && this.tableUUID.equals(other.tableUUID);
        }
        return false;
    }

    public int hashCode() {
        return this.privType + this.tableUUID.hashCode();
    }

    @Override
    public void check(LanguageConnectionContext lcc, String authorizationId, boolean forGrant) throws StandardException {
        DataDictionary dd = lcc.getDataDictionary();
        if (!this.hasPermissionOnTable(dd, authorizationId, forGrant)) {
            TableDescriptor td = this.getTableDescriptor(dd);
            throw StandardException.newException(forGrant ? "42501" : "42500", authorizationId, (Object)this.getPrivName(), (Object)td.getSchemaName(), (Object)td.getName());
        }
    }

    protected boolean isSelectOnHiveMetastore(TableDescriptor td) throws StandardException {
        return Misc.isSnappyHiveMetaTable(td.getSchemaName()) && this.privType == 0;
    }

    protected TableDescriptor getTableDescriptor(DataDictionary dd) throws StandardException {
        TableDescriptor td = dd.getTableDescriptor(this.tableUUID);
        if (td == null) {
            throw StandardException.newException("4250E", "table");
        }
        return td;
    }

    protected boolean hasPermissionOnTable(DataDictionary dd, String authorizationId, boolean forGrant) throws StandardException {
        return this.oneAuthHasPermissionOnTable(dd, "PUBLIC", forGrant) || this.oneAuthHasPermissionOnTable(dd, authorizationId, forGrant);
    }

    protected boolean oneAuthHasPermissionOnTable(DataDictionary dd, String authorizationId, boolean forGrant) throws StandardException {
        TablePermsDescriptor perms = dd.getTablePermissions(this.tableUUID, authorizationId);
        if (GemFireXDUtils.TraceAuthentication) {
            TableDescriptor td = this.getTableDescriptor(dd);
            SanityManager.DEBUG_PRINT((String)"TraceAuthentication", (String)("AuthorizationId=" + authorizationId + " TablePermsDescriptor=" + perms + " TableDescriptor=" + td));
        }
        if (perms == null) {
            return false;
        }
        String priv = null;
        switch (this.privType) {
            case 0: {
                priv = perms.getSelectPriv();
                break;
            }
            case 1: {
                priv = perms.getUpdatePriv();
                break;
            }
            case 2: {
                priv = perms.getReferencesPriv();
                break;
            }
            case 3: {
                priv = perms.getInsertPriv();
                break;
            }
            case 4: {
                priv = perms.getDeletePriv();
                break;
            }
            case 5: {
                priv = perms.getTriggerPriv();
                break;
            }
            case 7: {
                priv = perms.getAlterPriv();
            }
        }
        return "Y".equals(priv) || !forGrant && "y".equals(priv);
    }

    @Override
    public PermissionsDescriptor getPermissionDescriptor(String authid, DataDictionary dd) throws StandardException {
        if (this.oneAuthHasPermissionOnTable(dd, authid, false)) {
            return dd.getTablePermissions(this.tableUUID, authid);
        }
        return null;
    }

    public String getPrivName() {
        switch (this.privType) {
            case 0: {
                return "SELECT";
            }
            case 1: {
                return "UPDATE";
            }
            case 2: {
                return "REFERENCES";
            }
            case 3: {
                return "INSERT";
            }
            case 4: {
                return "DELETE";
            }
            case 5: {
                return "TRIGGER";
            }
            case 7: {
                return "ALTER";
            }
        }
        return "?";
    }

    public String toString() {
        return "StatementTablePermission@" + Integer.toHexString(System.identityHashCode(this)) + " permitted columns " + this.privType;
    }
}

