/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.error;

import com.gemstone.gemfire.GemFireCheckedException;
import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.ReplyException;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.DerbySQLException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class StandardException
extends Exception {
    public static final int REPORT_DEFAULT = 0;
    public static final int REPORT_NEVER = 1;
    public static final int REPORT_ALWAYS = 2;
    private static final long serialVersionUID = -5141884744265493120L;
    private Object[] arguments;
    private DistributedMember origin;
    private int severity;
    private String textMessage;
    private String sqlState;
    private transient int report;
    static final ThreadLocal<SQLWarning> noRowFound = new ThreadLocal();

    public static Object[] changeArgumentsForTransport(Object[] args) {
        if (args != null) {
            Object[] arguments = new Object[args.length];
            for (int index = 0; index < args.length; ++index) {
                arguments[index] = args[index] != null ? args[index].toString() : null;
            }
            return arguments;
        }
        return null;
    }

    public final void changeArgumentsForTransport() {
        this.arguments = StandardException.changeArgumentsForTransport(this.arguments);
    }

    public static InternalDistributedMember getMyId() {
        return GemFireStore.getMyId();
    }

    public static DistributedMember getSenderFromException(Throwable t) {
        InternalDistributedMember member = null;
        while (t != null && member == null) {
            if (t instanceof ReplyException) {
                member = ((ReplyException)t).getSender();
            } else if (t instanceof GemFireXDRuntimeException) {
                member = ((GemFireXDRuntimeException)t).getOrigin();
            } else if (t instanceof StandardException) {
                member = ((StandardException)t).getOrigin();
            } else if (t instanceof DerbySQLException) {
                member = ((DerbySQLException)((Object)t)).getOrigin();
            } else if (t instanceof GemFireException) {
                member = ((GemFireException)t).getOrigin();
            } else if (t instanceof GemFireCheckedException) {
                member = ((GemFireCheckedException)t).getOrigin();
            }
            t = t.getCause();
        }
        return member;
    }

    public static DistributedMember getSenderFromExceptionOrSelf(Throwable t) {
        DistributedMember member = StandardException.getSenderFromException(t);
        if (member != null) {
            return member;
        }
        return StandardException.getMyId();
    }

    public static DistributedMember fixUpRemoteException(Throwable remoteEx, DistributedMember member) {
        if (member == null) {
            member = StandardException.getSenderFromException(remoteEx);
        }
        if (member != null) {
            ReplyException.fixUpRemoteEx((Throwable)remoteEx, (DistributedMember)member);
        }
        return member;
    }

    public static Throwable getJavaException(Throwable t, String sqlState) {
        String javaExState = StandardException.getSQLStateFromIdentifier("XJ001.U");
        if (javaExState.equals(sqlState)) {
            while (t instanceof SQLException || t instanceof StandardException) {
                t = t.getCause();
            }
            return t;
        }
        return null;
    }

    public static StandardException newJavaException(Throwable t, String msg) {
        if (t instanceof StandardException) {
            return (StandardException)t;
        }
        if (t instanceof SQLException) {
            SQLException sqle = (SQLException)t;
            return Misc.wrapSQLException(sqle, sqle);
        }
        if (msg == null) {
            msg = t.getMessage();
        }
        if (msg == null) {
            msg = "";
        }
        return StandardException.newException("XJ001.U", t, (Object)t.getClass().getName(), (Object)msg);
    }

    public final DistributedMember getOrigin() {
        return this.origin;
    }

    public final boolean isRemote() {
        return this.origin != GemFireStore.getMyId();
    }

    public static StandardException newException(String messageID, Throwable t, Object[] args) {
        return new StandardException(messageID, t, args);
    }

    protected StandardException(String messageID) {
        this(messageID, null, null);
    }

    protected StandardException(String messageID, Object[] args) {
        this(messageID, null, args);
    }

    protected StandardException(String messageID, Throwable t, Object[] args) {
        super(messageID);
        this.severity = StandardException.getSeverityFromIdentifier(messageID);
        this.sqlState = StandardException.getSQLStateFromIdentifier(messageID);
        this.arguments = args;
        if (t != null) {
            this.initCause(t);
        }
        if (this.origin == null) {
            this.origin = StandardException.getSenderFromExceptionOrSelf(t);
        }
        SanityManager.ASSERT((messageID != null ? 1 : 0) != 0, (String)"StandardException with no messageID");
    }

    private StandardException(String sqlState, String text) {
        this(sqlState);
        this.textMessage = text;
    }

    public final void setArguments(Object[] arguments) {
        this.arguments = arguments;
        if (this.textMessage != null) {
            this.textMessage = null;
        }
    }

    public final Object[] getArguments() {
        return this.arguments;
    }

    public final int report() {
        return this.report;
    }

    public final void setReport(int report) {
        this.report = report;
    }

    public final void setSeverity(int severity) {
        this.severity = severity;
    }

    public final int getSeverity() {
        return this.severity;
    }

    public final int getErrorCode() {
        return this.severity;
    }

    public final String getSQLState() {
        return this.sqlState;
    }

    public static String getSQLStateFromIdentifier(String messageID) {
        if (messageID.length() == 5) {
            return messageID;
        }
        return messageID.substring(0, 5);
    }

    public static int getSeverityFromIdentifier(String messageID) {
        int lseverity = 0;
        if (messageID.length() == 5) {
            block0 : switch (messageID.charAt(0)) {
                case '0': {
                    switch (messageID.charAt(1)) {
                        case '1': {
                            lseverity = 10000;
                            break;
                        }
                        case '7': 
                        case 'A': {
                            lseverity = 20000;
                            break;
                        }
                        case '8': {
                            lseverity = 40000;
                        }
                    }
                    break;
                }
                case '2': 
                case '3': {
                    lseverity = 20000;
                    break;
                }
                case '4': {
                    switch (messageID.charAt(1)) {
                        case '0': {
                            lseverity = 30000;
                            break block0;
                        }
                        case '2': {
                            lseverity = 20000;
                        }
                    }
                }
            }
        }
        if (messageID.length() >= 7) {
            switch (messageID.charAt(6)) {
                case 'M': {
                    lseverity = 50000;
                    break;
                }
                case 'D': {
                    lseverity = 45000;
                    break;
                }
                case 'C': {
                    lseverity = 40000;
                    break;
                }
                case 'T': {
                    lseverity = 30000;
                    break;
                }
                case 'S': {
                    lseverity = 20000;
                    break;
                }
                case 'U': {
                    lseverity = 0;
                }
            }
        }
        return lseverity;
    }

    public static StandardException normalClose() {
        StandardException se = StandardException.newException("XXXXX.C.6");
        se.report = 1;
        return se;
    }

    public static StandardException newException(String messageID) {
        return new StandardException(messageID);
    }

    public static StandardException newException(String messageID, Throwable t) {
        return new StandardException(messageID, t, null);
    }

    public static StandardException newException(String messageID, Object a1) {
        Object[] oa = new Object[]{a1};
        return new StandardException(messageID, oa);
    }

    public static StandardException newException(String messageID, Object[] a1) {
        return new StandardException(messageID, a1);
    }

    public static StandardException newException(String messageID, Throwable t, Object a1) {
        Object[] oa = new Object[]{a1};
        return new StandardException(messageID, t, oa);
    }

    public static StandardException newException(String messageID, Object a1, Object a2) {
        Object[] oa = new Object[]{a1, a2};
        return new StandardException(messageID, oa);
    }

    public static StandardException newException(String messageID, Object a1, Throwable t) throws BadMessageArgumentException {
        throw new BadMessageArgumentException();
    }

    public static StandardException newException(String messageID, Throwable t, Object a1, Object a2) {
        Object[] oa = new Object[]{a1, a2};
        return new StandardException(messageID, t, oa);
    }

    public static StandardException newException(String messageID, Object a1, Object a2, Object a3) {
        Object[] oa = new Object[]{a1, a2, a3};
        return new StandardException(messageID, oa);
    }

    public static StandardException newException(String messageID, Object a1, Object a2, Throwable t) throws BadMessageArgumentException {
        throw new BadMessageArgumentException();
    }

    public static StandardException newException(String messageID, Throwable t, Object a1, Object a2, Object a3) {
        Object[] oa = new Object[]{a1, a2, a3};
        return new StandardException(messageID, t, oa);
    }

    public static StandardException newException(String messageID, Object a1, Object a2, Object a3, Object a4) {
        Object[] oa = new Object[]{a1, a2, a3, a4};
        return new StandardException(messageID, oa);
    }

    public static StandardException newException(String messageID, Throwable t, Object a1, Object a2, Object a3, Object a4) {
        Object[] oa = new Object[]{a1, a2, a3, a4};
        return new StandardException(messageID, t, oa);
    }

    public static StandardException newException(String messageID, Object a1, Object a2, Object a3, Object a4, Object a5) {
        Object[] oa = new Object[]{a1, a2, a3, a4, a5};
        return new StandardException(messageID, oa);
    }

    public static StandardException newException(String messageID, Throwable t, Object a1, Object a2, Object a3, Object a4, Object a5) {
        Object[] oa = new Object[]{a1, a2, a3, a4, a5};
        return new StandardException(messageID, t, oa);
    }

    public static StandardException newException(String messageID, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6) {
        Object[] oa = new Object[]{a1, a2, a3, a4, a5, a6};
        return new StandardException(messageID, oa);
    }

    public static StandardException newException(String messageID, Throwable t, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6) {
        Object[] oa = new Object[]{a1, a2, a3, a4, a5, a6};
        return new StandardException(messageID, t, oa);
    }

    public static StandardException newException(String messageID, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7) {
        Object[] oa = new Object[]{a1, a2, a3, a4, a5, a6, a7};
        return new StandardException(messageID, oa);
    }

    public static StandardException newException(String messageID, Throwable t, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7) {
        Object[] oa = new Object[]{a1, a2, a3, a4, a5, a6, a7};
        return new StandardException(messageID, t, oa);
    }

    public static StandardException newException(String messageID, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8) {
        Object[] oa = new Object[]{a1, a2, a3, a4, a5, a6, a7, a8};
        return new StandardException(messageID, oa);
    }

    public static StandardException newException(String messageID, Throwable t, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8) {
        Object[] oa = new Object[]{a1, a2, a3, a4, a5, a6, a7, a8};
        return new StandardException(messageID, t, oa);
    }

    public static StandardException newPreLocalizedException(String MessageID, Throwable t, String localizedMessage) {
        StandardException se;
        if (MessageID != null) {
            se = new StandardException(MessageID, localizedMessage);
        } else {
            if (t == null) {
                t = new RuntimeException(localizedMessage);
            }
            se = StandardException.newException("XJ001.U", (Object)t.getClass().getName(), (Object)(localizedMessage != null ? localizedMessage : t.getMessage()));
        }
        if (t != null) {
            se.initCause(t);
        }
        return se;
    }

    public static SQLException getArgumentFerry(SQLException se) {
        if (se instanceof DerbySQLException) {
            return se;
        }
        Throwable cause = se.getCause();
        if (cause == null || !(cause instanceof DerbySQLException)) {
            return se;
        }
        return (SQLException)cause;
    }

    public static StandardException unexpectedUserException(Throwable t) {
        String detailMessage;
        Throwable wrapped;
        SQLException sqlex;
        String state;
        SQLException sqle;
        DerbySQLException ferry = null;
        if (t instanceof SQLException && (sqle = StandardException.getArgumentFerry((SQLException)t)) instanceof DerbySQLException) {
            ferry = (DerbySQLException)((Object)sqle);
        }
        if (t instanceof SQLException && ferry == null && (state = (sqlex = (SQLException)t).getSQLState()) != null && state.length() == 5 && state.startsWith("38") && !state.equals("38000")) {
            StandardException se = new StandardException(state, sqlex.getMessage());
            if (sqlex.getNextException() != null) {
                se.initCause(sqlex.getNextException());
            }
            return se;
        }
        if (ferry != null && ferry.isSimpleWrapper() && (wrapped = ((SQLException)((Object)ferry)).getCause()) instanceof StandardException) {
            return (StandardException)wrapped;
        }
        if (t instanceof StandardException) {
            return (StandardException)t;
        }
        boolean derbyException = false;
        if (ferry != null) {
            detailMessage = ferry.toString();
            derbyException = true;
        } else {
            detailMessage = t.getMessage();
        }
        detailMessage = detailMessage == null ? "" : detailMessage.trim();
        if (detailMessage.length() == 0) {
            detailMessage = t.getClass().getName();
        } else if (!derbyException) {
            detailMessage = t.getClass().getName() + ": " + detailMessage;
        }
        StandardException se = StandardException.newException("38000", t, (Object)detailMessage);
        return se;
    }

    public static StandardException plainWrapException(Throwable t) {
        SQLException sqle;
        String sqlState;
        if (t instanceof StandardException) {
            return (StandardException)t;
        }
        if (t instanceof SQLException && (sqlState = (sqle = (SQLException)t).getSQLState()) != null) {
            StandardException se = new StandardException(sqlState, "(" + sqle.getErrorCode() + ") " + sqle.getMessage());
            if ((sqle = sqle.getNextException()) != null) {
                se.initCause(StandardException.plainWrapException(sqle));
            }
            return se;
        }
        String detailMessage = t.getMessage();
        detailMessage = detailMessage == null ? "" : detailMessage.trim();
        StandardException se = StandardException.newException("XJ001.U", t, (Object)detailMessage, (Object)t.getClass().getName());
        return se;
    }

    public static StandardException closeException() {
        StandardException se = StandardException.newException("close.C.1");
        se.setReport(1);
        return se;
    }

    @Override
    public String getMessage() {
        if (this.textMessage == null) {
            this.textMessage = MessageService.getCompleteMessage(this.getMessageId(), this.getArguments());
        }
        return this.textMessage;
    }

    public final String getMessageId() {
        return super.getMessage();
    }

    public String getErrorProperty(String type) {
        return StandardException.getErrorProperty(this.getMessageId(), type);
    }

    @Override
    public String toString() {
        String msg = this.getMessage();
        return "ERROR " + this.getSQLState() + ": " + msg;
    }

    private static String getErrorProperty(String messageId, String type) {
        return MessageService.getProperty(messageId, type);
    }

    public static StandardException interrupt(InterruptedException ie) {
        StandardException se = StandardException.newException("08000", ie);
        return se;
    }

    public static SQLWarning newWarning(String messageId) {
        return StandardException.newWarningCommon(messageId, null);
    }

    public static SQLWarning newWarning(String messageId, Object a1) {
        Object[] oa = new Object[]{a1};
        return StandardException.newWarningCommon(messageId, oa);
    }

    public static SQLWarning newWarning(String messageId, Object a1, Object a2) {
        Object[] oa = new Object[]{a1, a2};
        return StandardException.newWarningCommon(messageId, oa);
    }

    public static SQLWarning newWarning(String messageId, Object[] args, Throwable cause) {
        SQLWarning warning = StandardException.newWarningCommon(messageId, args);
        if (cause != null) {
            warning.initCause(cause);
        }
        return warning;
    }

    public static SQLWarning newNoRowFoundWarning() {
        SQLWarning sqlw = noRowFound.get();
        if (sqlw == null) {
            sqlw = StandardException.newWarning("02000");
            noRowFound.set(sqlw);
        } else {
            sqlw.setNextWarning(null);
        }
        return sqlw;
    }

    private static SQLWarning newWarningCommon(String messageId, Object[] oa) {
        String message = MessageService.getCompleteMessage(messageId, oa);
        String state = StandardException.getSQLStateFromIdentifier(messageId);
        SQLWarning sqlw = new SQLWarning(message, state, 10000);
        if (!"02000".equals(state)) {
            if (SanityManager.isFineEnabled) {
                SanityManager.DEBUG_PRINT((String)"warning:SQLWarning", (String)message, (Throwable)sqlw);
            } else {
                SanityManager.DEBUG_PRINT((String)"warning:SQLWarning", (String)sqlw.toString());
            }
        }
        return sqlw;
    }

    public static class BadMessageArgumentException
    extends Throwable {
    }
}

