/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ui;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.DiskEntry;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.DiskRegionStats;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.size.SingleObjectSizer;
import com.gemstone.gemfire.internal.snappy.StoreCallbacks;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.RegionMXBean;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.ui.SnappyIndexStats;
import com.pivotal.gemfirexd.internal.engine.ui.SnappyRegionStats;
import com.pivotal.gemfirexd.internal.engine.ui.SnappyRegionStatsCollectorResult;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.snappy.CallbackFactoryProvider;
import com.pivotal.gemfirexd.tools.sizer.GemFireXDInstrumentation;
import com.pivotal.gemfirexd.tools.sizer.ObjectSizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnappyRegionStatsCollectorFunction
implements Function,
Declarable {
    private static final long serialVersionUID = 1966980144121152499L;
    public static String ID = "SnappyRegionStatsCollectorFunction";
    public static final ObjectSizer sizer = ObjectSizer.getInstance(true);

    public void init(Properties props) {
    }

    public boolean hasResult() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FunctionContext context) {
        CallbackFactoryProvider.getClusterCallbacks().publishColumnTableStats();
        SnappyRegionStatsCollectorResult result = new SnappyRegionStatsCollectorResult();
        HashMap<String, SnappyRegionStats> cachBatchStats = new HashMap<String, SnappyRegionStats>();
        ArrayList<SnappyRegionStats> otherStats = new ArrayList<SnappyRegionStats>();
        try {
            List<GemFireContainer> containers = Misc.getMemStore().getAllContainers();
            SystemManagementService managementService = (SystemManagementService)ManagementService.getManagementService((Cache)Misc.getGemFireCache());
            for (GemFireContainer container : containers) {
                RegionMXBean bean;
                if (!container.isApplicationTable()) continue;
                LocalRegion r = container.getRegion();
                if (managementService == null || r == null || (bean = managementService.getLocalRegionMBean(r.getFullPath())) == null || r.getFullPath().startsWith("/SNAPPY_HIVE_METASTORE/")) continue;
                SnappyRegionStats dataCollector = this.collectDataFromBean(r, bean);
                if (dataCollector.isColumnTable()) {
                    cachBatchStats.put(dataCollector.getTableName(), dataCollector);
                    continue;
                }
                otherStats.add(dataCollector);
            }
            if (Misc.reservoirRegionCreated) {
                for (SnappyRegionStats tableStats : otherStats) {
                    RegionMXBean reservoirBean;
                    String schemaName;
                    String tableName = SharedUtils.SQLToUpperCase((String)tableStats.getTableName());
                    StoreCallbacks callback = com.gemstone.gemfire.internal.snappy.CallbackFactoryProvider.getStoreCallbacks();
                    String columnBatchTableName = callback.columnBatchTableName(tableName);
                    if (!cachBatchStats.containsKey(columnBatchTableName)) continue;
                    int dotIndex = tableName.indexOf(46);
                    if (dotIndex > 0) {
                        schemaName = tableName.substring(0, dotIndex);
                    } else {
                        schemaName = "APP";
                        tableName = schemaName + '.' + tableName;
                    }
                    String reservoirRegionName = Misc.getReservoirRegionNameForSampleTable(schemaName, tableName);
                    PartitionedRegion pr = Misc.getReservoirRegionForSampleTable(reservoirRegionName);
                    if (managementService == null || pr == null || (reservoirBean = managementService.getLocalRegionMBean(pr.getFullPath())) == null) continue;
                    SnappyRegionStats rStats = this.collectDataFromBeanImpl((LocalRegion)pr, reservoirBean, true);
                    SnappyRegionStats cStats = (SnappyRegionStats)cachBatchStats.get(columnBatchTableName);
                    cachBatchStats.put(columnBatchTableName, cStats.getCombinedStats(rStats));
                }
            }
            for (SnappyRegionStats tableStats : otherStats) {
                StoreCallbacks callback = com.gemstone.gemfire.internal.snappy.CallbackFactoryProvider.getStoreCallbacks();
                String columnBatchTableName = callback.columnBatchTableName(tableStats.getTableName());
                if (cachBatchStats.containsKey(columnBatchTableName)) {
                    result.addRegionStat(tableStats.getCombinedStats((SnappyRegionStats)cachBatchStats.get(columnBatchTableName)));
                    continue;
                }
                result.addRegionStat(tableStats);
            }
        }
        catch (CacheClosedException cacheClosedException) {
        }
        finally {
            context.getResultSender().lastResult((Object)result);
        }
    }

    private SnappyRegionStats collectDataFromBean(LocalRegion lr, RegionMXBean bean) {
        return this.collectDataFromBeanImpl(lr, bean, false);
    }

    private long getEntryOverhead(RegionEntry entry, GemFireXDInstrumentation sizer) {
        long entryOverhead = sizer.sizeof(entry);
        if (entry instanceof DiskEntry) {
            entryOverhead += sizer.sizeof(((DiskEntry)entry).getDiskId());
        }
        return entryOverhead;
    }

    private SnappyRegionStats collectDataFromBeanImpl(LocalRegion lr, RegionMXBean bean, boolean isReservoir) {
        String tableName = Misc.getFullTableNameFromRegionPath(bean.getFullPath());
        SnappyRegionStats tableStats = new SnappyRegionStats(tableName);
        boolean isColumnTable = bean.isColumnTable();
        tableStats.setColumnTable(isColumnTable);
        tableStats.setReplicatedTable(this.isReplicatedTable(lr.getDataPolicy()));
        if (tableStats.isReplicatedTable()) {
            tableStats.setBucketCount(1);
        } else {
            tableStats.setBucketCount(lr.getPartitionAttributes().getTotalNumBuckets());
        }
        if (isReservoir) {
            long numLocalEntries = bean.getRowsInReservoir();
            tableStats.setRowCount(numLocalEntries);
        } else {
            tableStats.setRowCount(isColumnTable ? bean.getRowsInColumnBatches() : bean.getEntryCount());
        }
        GemFireXDInstrumentation sizer = GemFireXDInstrumentation.getInstance();
        if (this.isReplicatedTable(lr.getDataPolicy()).booleanValue()) {
            long entryCount = 0L;
            Iterator ri = lr.entries.regionEntries().iterator();
            long size = lr.estimateMemoryOverhead((SingleObjectSizer)sizer);
            long entryOverhead = -1L;
            while (ri.hasNext()) {
                RegionEntry re = (RegionEntry)ri.next();
                if (entryOverhead < 0L) {
                    entryOverhead = this.getEntryOverhead(re, sizer);
                }
                size += entryOverhead;
                Object key = re.getRawKey();
                Object value = re._getValue();
                if (key != null) {
                    size += (long)CachedDeserializableFactory.calcMemSize((Object)key);
                }
                if (value != null) {
                    size += (long)CachedDeserializableFactory.calcMemSize((Object)value);
                }
                ++entryCount;
            }
            tableStats.setSizeInMemory(size);
            DiskRegion dr = lr.getDiskRegion();
            if (dr != null) {
                DiskRegionStats stats = dr.getStats();
                long diskBytes = stats.getBytesWritten();
                if (lr.getDataPolicy().withPersistence()) {
                    long numOverflow = stats.getNumOverflowOnDisk();
                    if (numOverflow > 0L) {
                        double avgDiskEntrySize = Math.max(1.0, (double)diskBytes / (double)entryCount);
                        size += (long)(avgDiskEntrySize * (double)numOverflow);
                    }
                } else {
                    size += diskBytes;
                }
            }
            tableStats.setTotalSize(size);
            tableStats.setSizeSpillToDisk(size - tableStats.getSizeInMemory());
        } else {
            PartitionedRegion pr = (PartitionedRegion)lr;
            PartitionedRegionDataStore datastore = pr.getDataStore();
            long sizeInMemory = 0L;
            long sizeOfRegion = 0L;
            long entryOverhead = 0L;
            long entryCount = 0L;
            if (datastore != null) {
                Set bucketRegions = datastore.getAllLocalBucketRegions();
                for (BucketRegion br : bucketRegions) {
                    Iterator iter;
                    long constantOverhead = br.estimateMemoryOverhead((SingleObjectSizer)sizer);
                    if (entryOverhead == 0L && (iter = br.entries.regionEntries().iterator()).hasNext()) {
                        RegionEntry re = (RegionEntry)iter.next();
                        entryOverhead = this.getEntryOverhead(re, sizer);
                    }
                    sizeInMemory += constantOverhead + br.getSizeInMemory();
                    sizeOfRegion += constantOverhead + br.getTotalBytes();
                    entryCount += (long)br.entryCount();
                }
            }
            if (entryOverhead > 0L) {
                entryOverhead *= entryCount;
            }
            tableStats.setSizeInMemory(sizeInMemory + entryOverhead);
            tableStats.setTotalSize(sizeOfRegion + entryOverhead);
            tableStats.setSizeSpillToDisk(tableStats.getTotalSize() - tableStats.getSizeInMemory());
        }
        return tableStats;
    }

    public ArrayList<SnappyIndexStats> getIndexStatForContainer(GemFireContainer c) {
        LinkedHashMap<String, Object[]> retEstimates = new LinkedHashMap<String, Object[]>();
        String baseTableContainerName = c.getQualifiedTableName();
        ArrayList<SnappyIndexStats> indexStats = new ArrayList<SnappyIndexStats>();
        LocalRegion reg = c.getRegion();
        GfxdIndexManager idxMgr = (GfxdIndexManager)reg.getIndexUpdater();
        List<GemFireContainer> indexes = idxMgr != null ? idxMgr.getAllIndexes() : Collections.emptyList();
        try {
            sizer.estimateIndexEntryValueSizes(baseTableContainerName, indexes, retEstimates, null);
            for (Map.Entry<String, Object[]> e : retEstimates.entrySet()) {
                long[] value = (long[])e.getValue()[0];
                long sum = 0L;
                sum += value[0];
                sum += value[1];
                sum += value[2];
                long rowCount = value[5];
                indexStats.add(new SnappyIndexStats(e.getKey(), rowCount, sum += value[3]));
            }
        }
        catch (StandardException | IllegalAccessException | InterruptedException e) {
            Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
            logger.warn("Unexpected exception in getIndexStatForContainer: " + e.toString(), (Throwable)e);
        }
        return indexStats;
    }

    public Boolean isReplicatedTable(DataPolicy dataPolicy) {
        return dataPolicy.withReplication();
    }

    public String getId() {
        return ID;
    }

    public boolean optimizeForWrite() {
        return false;
    }

    public boolean isHA() {
        return true;
    }

    static {
        sizer.setForInternalUse(true);
    }
}

