/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store.offheap;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.cache.ListOfDeltas;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.delta.Delta;
import com.gemstone.gemfire.internal.offheap.MemoryAllocator;
import com.gemstone.gemfire.internal.offheap.OffHeapHelper;
import com.gemstone.gemfire.internal.offheap.OffHeapRegionEntryHelper;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.gemstone.gemfire.internal.offheap.StoredObject;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RegionEntryUtils;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapDelta;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapDeltas;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRow;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;

public class OffHeapRegionEntryUtils {
    private static final int MAX_BATCH_SIZE = 512;

    public static Object prepareValueForUpdate(OffHeapRegionEntry entry, RegionEntryContext r, Object val, boolean valueContainsMetaData) {
        Class<?> valClass = val.getClass();
        Object prevValue = OffHeapRegionEntryHelper._getValue((OffHeapRegionEntry)entry);
        LogWriter logger = Misc.getCacheLogWriterNoThrow();
        SimpleMemoryAllocatorImpl.setReferenceCountOwner((Object)entry);
        if (logger != null && logger.fineEnabled()) {
            logger.fine("OffHeapRegionEntryUtils:: prepareValueForUpdate");
        }
        try {
            if (valClass == byte[].class) {
                Object object = OffHeapRegionEntryUtils.prepareValueForCreate(r, (byte[])val, false);
                return object;
            }
            if (valClass == byte[][].class) {
                if (valueContainsMetaData) {
                    Object object = OffHeapRegionEntryUtils.prepareValueForUpdateWithPossibleLobColumnsModified(r, prevValue, (byte[][])val);
                    return object;
                }
                Object object = OffHeapRegionEntryUtils.prepareValueForCreate(r, val, false);
                return object;
            }
            if (Delta.class.isAssignableFrom(valClass)) {
                OffHeapByteSource offHeapByteSource = OffHeapRegionEntryUtils.prepareValueForDelta((Delta)val, (MemoryAllocator)SimpleMemoryAllocatorImpl.getAllocator());
                return offHeapByteSource;
            }
            throw new UnsupportedOperationException("what is it?" + val);
        }
        finally {
            SimpleMemoryAllocatorImpl.setReferenceCountOwner(null);
        }
    }

    public static Object prepareValueForCreate(RegionEntryContext r, byte[] data, boolean skipLastRowIfByteArrayArray) {
        long addr;
        SimpleMemoryAllocatorImpl ma = SimpleMemoryAllocatorImpl.getAllocator();
        if (data.length < 8 && (addr = OffHeapRegionEntryHelper.encodeDataAsAddress((byte[])data, (boolean)false, (boolean)false)) != 0L) {
            return new SimpleMemoryAllocatorImpl.DataAsAddress(addr);
        }
        OffHeapRow mc = (OffHeapRow)ma.allocate(data.length, OffHeapRow.TYPE);
        mc.writeBytes(0, data);
        return mc;
    }

    public static OffHeapRowWithLobs prepareValueForCreate(RegionEntryContext r, byte[][] data, boolean skipLastRowIfByteArrayArray) {
        SimpleMemoryAllocatorImpl ma = SimpleMemoryAllocatorImpl.getAllocator();
        int numLobs = skipLastRowIfByteArrayArray ? data.length - 2 : data.length - 1;
        int extraBytesLen = OffHeapRowWithLobs.calcExtraChunkBytes(numLobs);
        OffHeapRowWithLobs chunk = (OffHeapRowWithLobs)ma.allocate(extraBytesLen + data[0].length, OffHeapRowWithLobs.TYPE);
        chunk.setNumLobs(numLobs);
        for (int i = 1; i <= numLobs; ++i) {
            byte[] colBytes = data[i];
            long address = 0L;
            if (colBytes != null) {
                StoredObject storedObject = ma.allocateAndInitialize(colBytes, false, false, OffHeapRow.TYPE);
                address = storedObject instanceof SimpleMemoryAllocatorImpl.DataAsAddress ? ((SimpleMemoryAllocatorImpl.DataAsAddress)storedObject).getEncodedAddress() : ((OffHeapRow)storedObject).getMemoryAddress();
            }
            chunk.setLobAddress(i, address);
        }
        chunk.writeBytes(numLobs * OffHeapRowWithLobs.LOB_ADDRESS_WIDTH, data[0]);
        return chunk;
    }

    public static Object prepareValueForCreate(RegionEntryContext r, Object val, boolean skipLastRowIfByteArrayArray) {
        SimpleMemoryAllocatorImpl ma = SimpleMemoryAllocatorImpl.getAllocator();
        Class<?> valClass = val.getClass();
        if (valClass == byte[].class) {
            return OffHeapRegionEntryUtils.prepareValueForCreate(r, (byte[])val, skipLastRowIfByteArrayArray);
        }
        if (valClass == byte[][].class) {
            return OffHeapRegionEntryUtils.prepareValueForCreate(r, (byte[][])val, skipLastRowIfByteArrayArray);
        }
        if (Delta.class.isAssignableFrom(valClass)) {
            return OffHeapRegionEntryUtils.prepareValueForDelta((Delta)val, (MemoryAllocator)ma);
        }
        throw new IllegalStateException("Unknown type for offheap storage. Type is " + valClass);
    }

    private static OffHeapByteSource prepareValueForDelta(Delta delta, MemoryAllocator ma) {
        boolean isListOfDeltas;
        HeapDataOutputStream hdos = new HeapDataOutputStream();
        try {
            if (delta instanceof ListOfDeltas) {
                List deltas = ((ListOfDeltas)delta).getDeltas();
                isListOfDeltas = true;
                hdos.writeInt(deltas.size());
                for (Delta aDelta : deltas) {
                    GemFireContainer.SerializableDelta sd = (GemFireContainer.SerializableDelta)aDelta;
                    InternalDataSerializer.invokeToData((DataSerializableFixedID)sd, (DataOutput)hdos);
                }
            } else {
                isListOfDeltas = false;
                InternalDataSerializer.invokeToData((DataSerializableFixedID)((GemFireContainer.SerializableDelta)delta), (DataOutput)hdos);
            }
        }
        catch (IOException ioe) {
            throw new GemFireXDRuntimeException(ioe);
        }
        byte[] data = hdos.toByteArray();
        OffHeapByteSource chunk = (OffHeapByteSource)ma.allocate(data.length, isListOfDeltas ? OffHeapDeltas.TYPE : OffHeapDelta.TYPE);
        chunk.writeBytes(0, data);
        return chunk;
    }

    private static Object prepareValueForUpdateWithPossibleLobColumnsModified(RegionEntryContext r, Object prevValue, byte[][] val) {
        boolean isAnyLobModified;
        FormatableBitSet rowsModified = new FormatableBitSet(val[val.length - 1]);
        boolean is0thRowModified = rowsModified.isSet(0);
        boolean bl = isAnyLobModified = rowsModified.anySetBit(0) != -1;
        if (prevValue instanceof OffHeapByteSource) {
            OffHeapByteSource currentChunk = (OffHeapByteSource)((Object)prevValue);
            int numExistingLobCols = currentChunk.readNumLobsColumns(true);
            if (isAnyLobModified) {
                if (is0thRowModified) {
                    return OffHeapRegionEntryUtils.prepareValueFor0thRowAndLobsModified(r, currentChunk, val, rowsModified, numExistingLobCols);
                }
                return OffHeapRegionEntryUtils.prepareValueForOnlyLobsModified(r, currentChunk, val, rowsModified, numExistingLobCols);
            }
            return OffHeapRegionEntryUtils.prepareValueForUpdateWithUnmodifiedLobColumns(currentChunk, val[0], numExistingLobCols);
        }
        if (prevValue instanceof SimpleMemoryAllocatorImpl.DataAsAddress || prevValue == null || prevValue instanceof Token) {
            if (isAnyLobModified) {
                return OffHeapRegionEntryUtils.prepareValueForCreate(r, val, true);
            }
            return OffHeapRegionEntryUtils.prepareValueForCreate(r, val[0], false);
        }
        Assert.fail((Object)("prepareValueForUpdateWithUnmodifiedLobColumns: unknown previous value of type " + prevValue.getClass() + ": " + prevValue));
        return null;
    }

    private static Object prepareValueForOnlyLobsModified(RegionEntryContext r, OffHeapByteSource currentChunk, byte[][] val, FormatableBitSet rowsModified, int numExistingLobCols) {
        OffHeapRowWithLobs chunk;
        int numLobs = val.length - 2;
        SimpleMemoryAllocatorImpl ma = SimpleMemoryAllocatorImpl.getAllocator();
        boolean reuseFullOldRowData = numExistingLobCols > 0;
        LogWriter logger = Misc.getCacheLogWriterNoThrow();
        if (logger != null && logger.fineEnabled()) {
            logger.fine("OffHeapRegionEntryUtils:: prepareValueForOnlyLobsModified:flag reuseFullOldRowData=" + reuseFullOldRowData + " Num existing lobs = " + numExistingLobCols + " . Num Lobs in byte[][] = " + numLobs);
        }
        if (reuseFullOldRowData) {
            byte[] zerothRowBytes = currentChunk.getFullDataBytes();
            chunk = (OffHeapRowWithLobs)ma.allocate(zerothRowBytes.length, OffHeapRowWithLobs.TYPE);
            chunk.writeBytes(0, zerothRowBytes);
            chunk.initNumLobColumns();
        } else {
            int extraBytesLen = OffHeapRowWithLobs.calcExtraChunkBytes(numLobs);
            byte[] zerothRowBytes = currentChunk.getRowBytes();
            chunk = (OffHeapRowWithLobs)ma.allocate(extraBytesLen + zerothRowBytes.length, OffHeapRowWithLobs.TYPE);
            chunk.setNumLobs(numLobs);
            chunk.writeBytes(numLobs * OffHeapRowWithLobs.LOB_ADDRESS_WIDTH, zerothRowBytes);
        }
        for (int i = 1; i <= numLobs; ++i) {
            if (rowsModified.isSet(i)) {
                if (logger != null && logger.fineEnabled()) {
                    logger.fine("OffHeapRegionEntryUtils:: prepareValueForOnlyLobsModified:Lob number=" + i + " is modified");
                }
                long address = 0L;
                byte[] colBytes = val[i];
                if (colBytes != null) {
                    StoredObject storedObject = ma.allocateAndInitialize(colBytes, false, false, OffHeapRow.TYPE);
                    address = storedObject instanceof SimpleMemoryAllocatorImpl.DataAsAddress ? ((SimpleMemoryAllocatorImpl.DataAsAddress)storedObject).getEncodedAddress() : ((OffHeapRow)storedObject).getMemoryAddress();
                }
                chunk.setLobAddress(i, address);
                continue;
            }
            if (!reuseFullOldRowData) continue;
            long unmodifiedLobAddress = chunk.readAddressForLob(i);
            if (logger != null && logger.fineEnabled()) {
                logger.fine("OffHeapRegionEntryUtils:: prepareValueForOnlyLobsModified:Lob address to reuse=" + Long.toHexString(unmodifiedLobAddress) + " for lob number =" + i);
            }
            if (unmodifiedLobAddress == 0L || !OffHeapRegionEntryHelper.isOffHeap((long)unmodifiedLobAddress) || SimpleMemoryAllocatorImpl.Chunk.retain((long)unmodifiedLobAddress)) continue;
            throw new IllegalStateException("Unable to use address " + Long.toHexString(unmodifiedLobAddress));
        }
        return chunk;
    }

    private static Object prepareValueFor0thRowAndLobsModified(RegionEntryContext r, OffHeapByteSource currentChunk, byte[][] val, FormatableBitSet rowsModified, int numExistingLobs) {
        int numLobs = val.length - 2;
        LogWriter logger = Misc.getCacheLogWriterNoThrow();
        if (logger != null && logger.fineEnabled()) {
            logger.fine("OffHeapRegionEntryUtils:: prepareValueFor0thRowAndLobsModified: Existing Lobs=" + numExistingLobs);
        }
        SimpleMemoryAllocatorImpl ma = SimpleMemoryAllocatorImpl.getAllocator();
        int extraBytesLen = OffHeapRowWithLobs.calcExtraChunkBytes(numLobs);
        OffHeapRowWithLobs chunk = (OffHeapRowWithLobs)ma.allocate(extraBytesLen + val[0].length, OffHeapRowWithLobs.TYPE);
        chunk.setNumLobs(numLobs);
        for (int i = 1; i <= numLobs; ++i) {
            long address = 0L;
            if (rowsModified.isSet(i)) {
                byte[] colBytes;
                if (logger != null && logger.fineEnabled()) {
                    logger.fine("OffHeapRegionEntryUtils:: prepareValueFor0thRowAndLobsModified: Lob number =" + i + " is modified");
                }
                if ((colBytes = val[i]) != null) {
                    StoredObject storedObject = ma.allocateAndInitialize(colBytes, false, false, OffHeapRow.TYPE);
                    address = storedObject instanceof SimpleMemoryAllocatorImpl.DataAsAddress ? ((SimpleMemoryAllocatorImpl.DataAsAddress)storedObject).getEncodedAddress() : ((OffHeapRow)storedObject).getMemoryAddress();
                }
            } else {
                if (logger != null && logger.fineEnabled()) {
                    logger.fine("OffHeapRegionEntryUtils:: prepareValueFor0thRowAndLobsModified: Lob number =" + i + " is not modified");
                }
                if (numExistingLobs > 0) {
                    address = currentChunk.readAddressForLob(i);
                    if (logger != null && logger.fineEnabled()) {
                        logger.fine("OffHeapRegionEntryUtils:: prepareValueFor0thRowAndLobsModified: Existing Lob address =" + Long.toHexString(address));
                    }
                    if (address != 0L && OffHeapRegionEntryHelper.isOffHeap((long)address)) {
                        if (!SimpleMemoryAllocatorImpl.Chunk.retain((long)address)) {
                            throw new IllegalStateException("Unable to use lob with address = " + Long.toHexString(address));
                        }
                    } else if (logger != null && logger.fineEnabled()) {
                        logger.fine("OffHeapRegionEntryUtils:: prepareValueFor0thRowAndLobsModified: Existing Lob address =" + Long.toHexString(address) + " is not offheap");
                    }
                }
            }
            chunk.setLobAddress(i, address);
        }
        chunk.writeBytes(numLobs * OffHeapRowWithLobs.LOB_ADDRESS_WIDTH, val[0]);
        return chunk;
    }

    private static OffHeapByteSource prepareValueForUpdateWithUnmodifiedLobColumns(OffHeapByteSource currentChunk, byte[] newVal, int numLobs) {
        SimpleMemoryAllocatorImpl ma = SimpleMemoryAllocatorImpl.getAllocator();
        if (numLobs == 0) {
            OffHeapByteSource chunk = (OffHeapByteSource)ma.allocate(newVal.length, OffHeapRow.TYPE);
            chunk.writeBytes(0, newVal);
            return chunk;
        }
        int extraBytes = OffHeapRowWithLobs.calcExtraChunkBytes(numLobs);
        OffHeapRowWithLobs chunk = (OffHeapRowWithLobs)ma.allocate(extraBytes + newVal.length, OffHeapRowWithLobs.TYPE);
        chunk.setNumLobs(numLobs);
        LogWriter logger = Misc.getCacheLogWriterNoThrow();
        for (int i = 1; i <= numLobs; ++i) {
            long address = currentChunk.readAddressForLob(i);
            if (logger != null && logger.fineEnabled()) {
                logger.fine("OffHeapRegionEntryUtils:: prepareValueForUpdateWithUnmodifiedLobColumns:Existing lob address = " + Long.toHexString(address) + " for lob number=" + i);
            }
            chunk.setLobAddress(i, address);
            if (address != 0L && OffHeapRegionEntryHelper.isOffHeap((long)address)) {
                if (SimpleMemoryAllocatorImpl.Chunk.retain((long)address)) continue;
                throw new IllegalStateException("Unable to use the lob address=" + Long.toHexString(address));
            }
            if (logger == null || !logger.fineEnabled()) continue;
            logger.fine("OffHeapRegionEntryUtils:: prepareValueForUpdateWithUnmodifiedLobColumns: lob address = " + Long.toHexString(address) + " is not stored offheap");
        }
        chunk.writeBytes(numLobs * OffHeapRowWithLobs.LOB_ADDRESS_WIDTH, newVal);
        return chunk;
    }

    public static Object getHeapRowForInVMValue(OffHeapRegionEntry re) {
        SimpleMemoryAllocatorImpl.skipRefCountTracking();
        Object val = RegionEntryUtils.convertOffHeapEntrytoByteSourceRetain((RegionEntry)re, null, null, false, true);
        SimpleMemoryAllocatorImpl.unskipRefCountTracking();
        try {
            if (val instanceof OffHeapByteSource) {
                Object object = ((OffHeapByteSource)((Object)val)).getValueAsDeserializedHeapObject();
                return object;
            }
            Object object = val;
            return object;
        }
        finally {
            OffHeapHelper.releaseWithNoTracking((Object)val);
        }
    }

    public static boolean isValidValueForGfxdOffHeapStorage(Object value) {
        if (value != null) {
            Class<?> valClass = value.getClass();
            return valClass == byte[].class || valClass == byte[][].class || Delta.class.isAssignableFrom(valClass);
        }
        return false;
    }

    public static int fillBatch(byte[] batch, OffHeapByteSource source, int batchNum, int totalLen, int totalBatchNum, int baseOffset) {
        int numBytesToRead = batchNum + 1 == totalBatchNum ? totalLen - batchNum * batch.length : batch.length;
        source.readBytes(baseOffset + batchNum * batch.length, batch, 0, numBytesToRead);
        return numBytesToRead;
    }

    public static int fillBatchInReverse(byte[] batch, OffHeapByteSource source, int batchNum, int totalLen, int totalBatchNum, int endOffSet) {
        int numBytesToRead = batchNum + 1 == totalBatchNum ? totalLen - batchNum * batch.length : batch.length;
        source.readBytes(endOffSet + 1 - (batchNum * batch.length + numBytesToRead), batch, 0, numBytesToRead);
        return numBytesToRead;
    }

    public static int calculateBatchSize(int totalLength) {
        return totalLength < 512 ? totalLength : 512;
    }

    public static int calculateNumberOfBatches(int totalLengthToRead, int batchSize) {
        if (batchSize == 0) {
            return 0;
        }
        return totalLengthToRead / batchSize + (totalLengthToRead % batchSize > 0 ? 1 : 0);
    }
}

