/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.store;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.cache.AbstractRegionEntry;
import com.gemstone.gemfire.internal.cache.KeyWithRegionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.Token;
import com.gemstone.gemfire.internal.cache.lru.Sizeable;
import com.gemstone.gemfire.internal.shared.Version;
import com.gemstone.gemfire.internal.size.ReflectionSingleObjectSizer;
import com.pivotal.gemfirexd.internal.engine.GfxdSerializable;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraInfo;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RegionEntryUtils;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class CompactCompositeRegionKey
extends CompactCompositeKey
implements Externalizable,
GfxdSerializable,
RegionKey,
KeyWithRegionContext,
Sizeable {
    private static final long serialVersionUID = -5397414534166595916L;
    private static final CompactCompositeRegionKey TOKEN_KEY = new CompactCompositeRegionKey();
    private transient int hash;

    public CompactCompositeRegionKey() {
    }

    public CompactCompositeRegionKey(OffHeapRegionEntry value, ExtraTableInfo tabInfo) {
        super(value, (ExtraInfo)tabInfo);
    }

    public CompactCompositeRegionKey(OffHeapByteSource value, ExtraTableInfo tabInfo) {
        super((Object)value, (ExtraInfo)tabInfo);
    }

    public CompactCompositeRegionKey(byte[] value, ExtraTableInfo tabInfo) {
        super(value, (ExtraInfo)tabInfo);
    }

    public CompactCompositeRegionKey(ExtraTableInfo tabInfo, byte[] keyBytes) {
        super(tabInfo, keyBytes);
    }

    public CompactCompositeRegionKey(DataValueDescriptor[] value, ExtraTableInfo tabInfo) throws StandardException {
        super(value, (ExtraInfo)tabInfo);
    }

    public CompactCompositeRegionKey(DataValueDescriptor value, ExtraTableInfo tabInfo) throws StandardException {
        super(value, (ExtraInfo)tabInfo);
    }

    public final void setExtraTableInfo(GemFireContainer container) {
        if (this.tableInfo == null && container.isByteArrayStore()) {
            this.setTableInfo(container);
        }
    }

    public final void setRegionContext(LocalRegion region) {
        GemFireContainer container;
        if (this.tableInfo == null && (container = (GemFireContainer)region.getUserAttribute()).isByteArrayStore()) {
            this.setTableInfo(container);
        }
    }

    private final void setTableInfo(GemFireContainer container) {
        Object vbytes = this.getValueByteSource();
        if (vbytes == null) {
            this.tableInfo = container.getExtraTableInfo();
        } else {
            try {
                this.tableInfo = container.getExtraTableInfo(vbytes);
            }
            finally {
                this.releaseValueByteSource(vbytes);
            }
        }
    }

    public final ExtraTableInfo getTableInfo() {
        return (ExtraTableInfo)this.tableInfo;
    }

    public final KeyWithRegionContext beforeSerializationWithValue(boolean valueIsToken) {
        if (!valueIsToken) {
            return TOKEN_KEY;
        }
        return this;
    }

    public final void afterDeserializationWithValue(Object val) {
        Class<?> cls = val.getClass();
        if (cls == byte[][].class) {
            this.setValueBytes(((byte[][])val)[0]);
        } else if (cls == byte[].class || !Token.class.isAssignableFrom(cls)) {
            this.setValueBytes(val);
        }
        this.tableInfo = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getSizeInBytes() {
        int tries = 1;
        do {
            Object valBytes = this.getValueByteSource();
            try {
                int size = RegionEntryUtils.entryKeySizeInBytes(this.getKeyBytes(), valBytes, this.tableInfo);
                if (size >= 0) {
                    int n = size;
                    return n;
                }
            }
            finally {
                this.releaseValueByteSource(valBytes);
            }
            if (tries % 1000 != 0) continue;
            Thread.yield();
        } while (tries++ <= 10000000);
        throw RegionEntryUtils.checkCacheForNullKeyValue("CompactCompositeRegionKey#getSizeInBytes");
    }

    public final int getDSFID() {
        return -20;
    }

    public byte getGfxdID() {
        return 98;
    }

    public final void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.setKeyBytes(DataSerializer.readByteArray((DataInput)in));
        this.setValueBytes(null);
    }

    @Override
    protected Object getTokenKey() {
        return TOKEN_KEY;
    }

    public final void toData(DataOutput out) throws IOException {
        this.writeKeyBytes(out);
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h != 0) {
            return h;
        }
        this.hash = super.hashCode();
        return this.hash;
    }

    @Override
    public long estimateMemoryUsage() {
        return this.getSizeInBytes() + ReflectionSingleObjectSizer.OBJECT_SIZE + 4 + ReflectionSingleObjectSizer.REFERENCE_SIZE;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fromData(in);
    }

    @Override
    public Object getValueByteSource() {
        Class<?> rclass;
        Object retVal = super.getValueByteSource();
        if (retVal != null && (rclass = retVal.getClass()) != byte[].class) {
            if (OffHeapByteSource.isOffHeapBytesClass(rclass)) {
                if (!((OffHeapByteSource)((Object)retVal)).retain()) {
                    retVal = null;
                }
            } else if (OffHeapRegionEntry.class.isAssignableFrom(rclass)) {
                retVal = RegionEntryUtils.convertOffHeapEntrytoByteSourceRetain((RegionEntry)((OffHeapRegionEntry)retVal), null, null, false, true);
            }
        }
        return retVal;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeKeyBytes(out);
    }

    @Override
    public final byte[] getKeyBytes() {
        Object temp;
        Object val;
        byte[] keyBytes = (byte[])super.get();
        if (keyBytes == null && (val = super.getValueByteSource()) instanceof AbstractRegionEntry && (temp = ((AbstractRegionEntry)val).getRawKey()) instanceof byte[]) {
            keyBytes = (byte[])temp;
        }
        return keyBytes;
    }

    public Version[] getSerializationVersions() {
        return null;
    }
}

