/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.execute;

import com.gemstone.gemfire.internal.cache.CachedDeserializableFactory;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdQueryResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.execution.SampleInsertExecutionObject;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraTableInfo;
import com.pivotal.gemfirexd.internal.engine.sql.conn.GfxdHeapThresholdListener;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AutogenKeysResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.IdentityValueManager;
import com.pivotal.gemfirexd.internal.engine.sql.execute.SnappyActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.SnappyUpdateDeletePutResultSet;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.RowEncoder;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.InsertConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;

public final class GemFireInsertResultSet
extends AbstractGemFireResultSet {
    private final NoPutResultSet sourceResultSet;
    private final GeneratedMethod checkGM;
    private final GemFireContainer gfContainer;
    private final RowEncoder.PreProcessRow processor;
    private final boolean hasSerialAEQorWAN;
    private boolean isPreparedBatch;
    private boolean isPutDML;
    private boolean batchLockTaken;
    private ArrayList<Object> batchRows;
    private long batchSize;
    private final GfxdHeapThresholdListener thresholdListener;
    private int rowCount;
    private int numOpens;
    private int[] autoGeneratedColumns;
    private AutogenKeysResultSet autoGeneratedKeysResultSet;
    private boolean hasDependentSampleTable;
    private ArrayList<DataValueDescriptor[]> batchRowsForByteStore;

    public boolean isPreparedBatch() {
        return this.isPreparedBatch;
    }

    public GemFireInsertResultSet(NoPutResultSet source, GeneratedMethod checkGM, Activation activation) throws StandardException {
        super(activation);
        this.sourceResultSet = source;
        this.checkGM = checkGM;
        InsertConstantAction constants = (InsertConstantAction)activation.getConstantAction();
        long heapConglom = constants.getConglomerateId();
        MemConglomerate conglom = this.tran.findExistingConglomerate(heapConglom);
        this.gfContainer = conglom.getGemFireContainer();
        RowEncoder encoder = this.gfContainer.getRowEncoder();
        this.processor = encoder != null ? encoder.getPreProcessorForRows(this.gfContainer) : null;
        this.hasSerialAEQorWAN = this.gfContainer.getRegion().isSerialWanEnabled();
        this.thresholdListener = Misc.getMemStore().thresholdListener();
        this.isPutDML = activation.isPutDML();
        boolean isColumnTable = this.gfContainer.isRowBuffer();
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        if (isColumnTable && !Misc.routeQuery(lcc) && !lcc.isSnappyInternalConnection()) {
            throw StandardException.newException("XJ218.S");
        }
    }

    @Override
    public void open() throws StandardException {
        boolean usingPutAll;
        long l;
        if (!this.isClosed) {
            return;
        }
        boolean bl = this.hasDependentSampleTable = !this.lcc.isSnappyInternalConnection() && Misc.getMemStore().isSnappyStore() && this.gfContainer.hasDependentSampleTables();
        if (this.statisticsTimingOn) {
            this.openTime = -1L;
            l = XPLAINUtil.recordTiming(-1L);
        } else {
            l = 0L;
        }
        long beginTime = l;
        long restOfOpenTime = 0L;
        LocalRegion reg = this.gfContainer.getRegion();
        GfxdIndexManager sqim = (GfxdIndexManager)(reg != null ? reg.getIndexUpdater() : null);
        LanguageConnectionContext lcc = this.activation.getLanguageConnectionContext();
        TXStateInterface tx = this.gfContainer.getActiveTXState(this.tran);
        if (sqim != null && !this.isPutDML) {
            sqim.fireStatementTriggers(0, lcc, this.tran, tx);
        }
        super.open();
        if (beginTime != 0L) {
            this.nextTime = XPLAINUtil.nanoTime();
            this.openTime = this.nextTime - beginTime;
        }
        if (usingPutAll = this.isPreparedBatch) {
            ExecRow row;
            if (this.batchRows == null) {
                this.batchRows = new ArrayList();
                this.batchSize = 0L;
                if (this.hasDependentSampleTable && this.gfContainer.isByteArrayStore()) {
                    this.batchRowsForByteStore = new ArrayList();
                }
            }
            while ((row = this.sourceResultSet.getNextRowCore()) != null) {
                this.evaluateCheckConstraints();
                this.handleAutoGeneratedColumns(row);
                this.handleBatchInserts(row);
            }
        } else if (this.sourceResultSet.getEstimatedRowCount() > 1.0) {
            this.handleMultipleInserts();
            usingPutAll = true;
        } else {
            ExecRow row;
            while ((row = this.sourceResultSet.getNextRowCore()) != null) {
                this.evaluateCheckConstraints();
                this.handleAutoGeneratedColumns(row);
                DataValueDescriptor[] rowArray = row.getRowArray();
                if (this.processor != null) {
                    rowArray = this.processor.preProcess(rowArray);
                }
                this.gfContainer.insertRow(rowArray, this.tran, tx, lcc, this.isPutDML);
                ++this.rowCount;
            }
        }
        if (beginTime != 0L) {
            restOfOpenTime = XPLAINUtil.nanoTime();
            this.nextTime = restOfOpenTime - this.nextTime;
        }
        if (!usingPutAll && tx != null && this.hasSerialAEQorWAN) {
            ParameterValueSet pvs = this.activation.getParameterValueSet();
            this.activation.distributeBulkOpToDBSynchronizer(this.gfContainer.getRegion(), pvs != null && pvs.getParameterCount() > 0, this.tran, lcc.isSkipListeners(), null);
        }
        if (sqim != null && !this.isPutDML) {
            sqim.fireStatementTriggers(3, lcc, this.tran, tx);
        }
        if (beginTime != 0L) {
            this.openTime += XPLAINUtil.recordTiming(restOfOpenTime);
        }
    }

    private void handleBatchInserts(ExecRow row) throws StandardException {
        if (this.batchSize > GemFireXDUtils.DML_MAX_CHUNK_SIZE || this.thresholdListener != null && (this.thresholdListener.isEviction() || this.thresholdListener.isCritical())) {
            this.flushBatch();
        }
        this.batchSize += this.addRow(this.batchRows, row);
        ++this.rowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMultipleInserts() throws StandardException {
        ArrayList<Object> rows = new ArrayList<Object>();
        LanguageConnectionContext lcc = this.activation.getLanguageConnectionContext();
        TXStateInterface tx = this.gfContainer.getActiveTXState(this.tran);
        try {
            ExecRow row;
            while ((row = this.sourceResultSet.getNextRowCore()) != null) {
                this.evaluateCheckConstraints();
                this.handleAutoGeneratedColumns(row);
                if ((this.batchSize > GemFireXDUtils.DML_MAX_CHUNK_SIZE || this.thresholdListener != null && (this.thresholdListener.isEviction() || this.thresholdListener.isCritical())) && rows.size() > 0) {
                    this.gfContainer.insertMultipleRows(rows, tx, lcc, false, this.isPutDML);
                    if (this.hasSerialAEQorWAN) {
                        this.activation.distributeBulkOpToDBSynchronizer(this.gfContainer.getRegion(), true, this.tran, lcc.isSkipListeners(), rows);
                    }
                    rows.clear();
                    this.batchSize = 0L;
                }
                this.batchSize += this.addRow(rows, row);
                this.sourceResultSet.releasePreviousByteSource();
                ++this.rowCount;
            }
        }
        finally {
            if (rows.size() > 0) {
                this.gfContainer.insertMultipleRows(rows, tx, lcc, false, this.isPutDML);
                if (this.hasSerialAEQorWAN) {
                    this.activation.distributeBulkOpToDBSynchronizer(this.gfContainer.getRegion(), true, this.tran, lcc.isSkipListeners(), rows);
                }
            }
            this.batchSize = 0L;
        }
    }

    private long addRow(ArrayList<Object> rows, ExecRow row) throws StandardException {
        if (this.gfContainer.isByteArrayStore()) {
            Object rawRow;
            if (this.hasDependentSampleTable) {
                this.batchRowsForByteStore.add(row.getRowArrayClone());
            }
            if ((rawRow = row.getRawRowValue(false)) instanceof DataValueDescriptor[]) {
                DataValueDescriptor[] dvds = (DataValueDescriptor[])rawRow;
                rawRow = this.gfContainer.getCurrentRowFormatter().generateRowData(dvds);
            }
            rows.add(rawRow);
            return AbstractCompactExecRow.getRawRowSize(rawRow);
        }
        DataValueDescriptor[] rowArray = row.getClone().getRowArray();
        if (this.processor != null) {
            rowArray = this.processor.preProcess(rowArray);
        }
        rows.add(rowArray);
        return row.estimateRowSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void flushBatch() throws StandardException {
        ArrayList<Object> rows = this.batchRows;
        if (rows != null && rows.size() > 0) {
            TXStateInterface tx = this.gfContainer.getActiveTXState(this.tran);
            try {
                Activation act = this.activation;
                this.gfContainer.insertMultipleRows(rows, tx, act.getLanguageConnectionContext(), false, this.isPutDML);
                if (act.isQueryCancelled()) {
                    act.checkCancellationFlag();
                }
                if (this.hasSerialAEQorWAN) {
                    act.distributeBulkOpToDBSynchronizer(this.gfContainer.getRegion(), true, this.tran, this.lcc.isSkipListeners(), rows);
                }
                if (this.hasDependentSampleTable) {
                    ArrayList<Object> batchRows = null;
                    batchRows = this.gfContainer.isByteArrayStore() ? this.batchRowsForByteStore : this.batchRows;
                    boolean enableStreaming = this.lcc.streamingEnabled();
                    SnappyUpdateDeletePutResultSet rs = new SnappyUpdateDeletePutResultSet(this.activation, false);
                    GfxdQueryResultCollector rc = new GfxdQueryResultCollector();
                    rs.setupRC(rc);
                    SampleInsertExecutionObject execObj = new SampleInsertExecutionObject(this.gfContainer.getQualifiedTableName(), batchRows);
                    SnappyActivation.executeOnLeadNode(rs, rc, false, this.activation, this.lcc, execObj);
                }
            }
            finally {
                rows.clear();
                if (this.hasDependentSampleTable && this.gfContainer.isByteArrayStore()) {
                    this.batchRowsForByteStore.clear();
                }
                this.batchSize = 0L;
            }
        }
    }

    @Override
    public final void closeBatch() throws StandardException {
        assert (this.isPreparedBatch);
        this.releaseLocks();
        if (this.tran != null) {
            this.tran.release();
        }
    }

    @Override
    protected void openCore() throws StandardException {
        this.rowCount = 0;
        this.batchSize = 0L;
        if (this.numOpens++ == 0) {
            this.sourceResultSet.openCore();
        } else {
            this.sourceResultSet.reopenCore();
        }
        this.isPreparedBatch = this.activation.isPreparedBatch();
        if (!this.isPreparedBatch || !this.batchLockTaken) {
            this.takeLocks();
        }
        if (this.autoGeneratedKeysResultSet == null && this.activation.getAutoGeneratedKeysResultsetMode()) {
            ExtraTableInfo tableInfo = this.gfContainer.getExtraTableInfo();
            int[] cols = this.activation.getAutoGeneratedKeysColumnIndexes();
            String[] colNames = this.activation.getAutoGeneratedKeysColumnNames();
            if (cols != null) {
                for (int pos : cols) {
                    if (tableInfo.getAutoGeneratedColumn(pos) != null) continue;
                    throw StandardException.newException("X0X0E.S", (Object)pos, (Object)this.gfContainer.getQualifiedTableName());
                }
            } else if (colNames != null) {
                cols = new int[colNames.length];
                for (int index = 0; index < colNames.length; ++index) {
                    ColumnDescriptor cd = tableInfo.getAutoGeneratedColumn(colNames[index]);
                    if (cd == null) {
                        throw StandardException.newException("X0X0F.S", (Object)colNames[index], (Object)this.gfContainer.getQualifiedTableName());
                    }
                    cols[index] = cd.getPosition();
                }
            } else {
                cols = tableInfo.getAutoGeneratedColumns();
            }
            if (cols != null && cols.length > 0) {
                Arrays.sort(cols);
                this.activation.setAutoGeneratedKeysResultsetInfo(cols, null);
                this.autoGeneratedColumns = cols;
                Properties props = new Properties();
                this.gfContainer.getContainerProperties(props);
                this.autoGeneratedKeysResultSet = new AutogenKeysResultSet(this.activation, cols, tableInfo);
            }
        }
    }

    private void evaluateCheckConstraints() throws StandardException {
        if (this.checkGM != null) {
            this.checkGM.invoke(this.activation);
        }
    }

    @Override
    public void finishResultSet(boolean cleanupOnError) throws StandardException {
        try {
            if (this.sourceResultSet != null) {
                this.sourceResultSet.close(cleanupOnError);
            }
            if (!this.isPreparedBatch) {
                this.releaseLocks();
            }
            this.numOpens = 0;
        }
        finally {
            if (this.tran != null) {
                this.tran.release();
            }
        }
    }

    private void takeLocks() throws StandardException {
        this.gfContainer.open(this.tran, 8);
        GemFireInsertResultSet.openOrCloseFKContainers(this.gfContainer, this.tran, false, true);
        if (this.isPreparedBatch) {
            this.batchLockTaken = true;
        }
    }

    private void releaseLocks() throws StandardException {
        GemFireInsertResultSet.openOrCloseFKContainers(this.gfContainer, this.tran, true, true);
        this.gfContainer.closeForEndTransaction(this.tran, true);
        if (this.isPreparedBatch) {
            this.batchLockTaken = false;
        }
    }

    @Override
    public int modifiedRowCount() {
        return this.rowCount;
    }

    @Override
    public boolean returnsRows() {
        return false;
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.setNumberOfChildren(0);
        visitor.visit(this);
    }

    public DataValueDescriptor getNextUUIDValue(int columnPosition) throws StandardException {
        ExtraTableInfo tabInfo = this.gfContainer.getExtraTableInfo();
        ColumnDescriptor cd = tabInfo.getRowFormatter().getColumnDescriptor(columnPosition - 1);
        DataTypeDescriptor dtd = cd.getType();
        DataValueDescriptor dvd = dtd.getNull();
        LanguageConnectionContext lcc = this.activation.getLanguageConnectionContext();
        try {
            LocalRegion region = this.gfContainer.getRegion();
            long incStart = cd.getAutoincStart();
            if (dtd.getTypeId().getTypeFormatId() == 11) {
                GemFireXDQueryObserver observer;
                long uuid = region.newUUID(true);
                if (uuid < incStart) {
                    uuid = region.resetUUID(incStart);
                }
                if ((observer = GemFireXDQueryObserverHolder.getInstance()) != null) {
                    int[] pkColumns = tabInfo.getPrimaryKeyColumns();
                    boolean forRegionKey = pkColumns != null && pkColumns.length > 0 && pkColumns[0] == columnPosition;
                    uuid = observer.overrideUniqueID(uuid, forRegionKey);
                }
                dvd.setValue(uuid);
                lcc.setIdentityValue(uuid);
                return dvd;
            }
            int shortUUID = region.newShortUUID();
            if ((long)shortUUID < incStart) {
                if (incStart < 0L || incStart > Integer.MAX_VALUE) {
                    SanityManager.THROWASSERT((String)("unexpected value for autoincrement start " + incStart + " column " + cd));
                }
                shortUUID = region.resetShortUUID((int)(incStart & 0xFFFFFFFFL));
            }
            dvd.setValue(shortUUID);
            lcc.setIdentityValue(shortUUID);
            return dvd;
        }
        catch (IllegalStateException ise) {
            throw StandardException.newException("42Z24", ise, (Object)this.gfContainer.getQualifiedTableName(), (Object)cd.getColumnName());
        }
    }

    public DataValueDescriptor getMaxIdentityValue(int columnPosition) throws StandardException {
        IdentityValueManager.GetIdentityValueMessage msg;
        long result;
        ColumnDescriptor cd = this.gfContainer.getCurrentRowFormatter().getColumnDescriptor(columnPosition - 1);
        DataTypeDescriptor dtd = cd.getType();
        DataValueDescriptor dvd = dtd.getNull();
        GemFireStore store = Misc.getMemStore();
        LocalRegion identityRgn = store.getIdentityRegion();
        assert (identityRgn != null);
        String key = this.gfContainer.getUUID();
        long increment = cd.getAutoincInc();
        do {
            Object res;
            msg = new IdentityValueManager.GetIdentityValueMessage(identityRgn, key, cd.getAutoincStart(), increment, this.getLanguageConnectionContext());
            try {
                res = msg.executeFunction();
            }
            catch (SQLException sqle) {
                throw Misc.wrapSQLException(sqle, sqle);
            }
            assert (res != null) : "Expected one result for targeted function execution of GetIdentityValueMessage";
            result = (Long)res;
        } while (!IdentityValueManager.getInstance().setGeneratedValue(key, result, increment, msg.getTarget()));
        if (dtd.getTypeId().getTypeFormatId() == 11) {
            dvd.setValue(result);
            this.lcc.setIdentityValue(result);
            return dvd;
        }
        if (result >= Integer.MIN_VALUE && result <= Integer.MAX_VALUE) {
            dvd.setValue((int)result);
            this.lcc.setIdentityValue((int)result);
            return dvd;
        }
        throw StandardException.newException("42Z24", (Object)this.gfContainer.getQualifiedTableName(), (Object)cd.getColumnName());
    }

    @Override
    public ResultSet getAutoGeneratedKeysResultset() {
        if (this.autoGeneratedKeysResultSet != null) {
            SanityManager.ASSERT((this.activation.getLanguageConnectionContext().getIdentityVal() != 0L ? 1 : 0) != 0);
        }
        return this.autoGeneratedKeysResultSet;
    }

    @Override
    public boolean hasAutoGeneratedKeysResultSet() {
        return this.autoGeneratedKeysResultSet != null;
    }

    private void handleAutoGeneratedColumns(ExecRow row) throws StandardException {
        if (this.autoGeneratedKeysResultSet != null) {
            this.autoGeneratedKeysResultSet.insertRow(row, this.autoGeneratedColumns);
        }
    }

    @Override
    public long estimateMemoryUsage() throws StandardException {
        long memory = 0L;
        if (this.autoGeneratedKeysResultSet != null) {
            memory += (long)(this.autoGeneratedColumns.length * 4 + ClassSize.estimateArrayOverhead());
            memory += this.autoGeneratedKeysResultSet.estimateMemoryUsage();
        }
        if (this.batchRows != null) {
            memory += (long)ClassSize.estimateArrayOverhead();
            for (Object row : this.batchRows) {
                if (row instanceof DataValueDescriptor[]) {
                    memory += (long)ClassSize.estimateArrayOverhead();
                    for (DataValueDescriptor dvd : (DataValueDescriptor[])row) {
                        memory += (long)dvd.estimateMemoryUsage();
                    }
                    continue;
                }
                memory += (long)CachedDeserializableFactory.calcMemSize((Object)row);
            }
        }
        return memory;
    }
}

