/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql.catalog;

import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdDistributionAdvisor;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.SortedSet;

public final class DistributionDescriptor
extends TupleDescriptor {
    public static final int NONE = 0;
    public static final int REPLICATE = 1;
    public static final int COLOCATE = 2;
    public static final int PARTITIONBYGENERATEDKEY = 3;
    public static final int PARTITIONBYPRIMARYKEY = 4;
    public static final int PARTITIONBYEXPRESSION = 5;
    public static final int PARTITIONBYRANGE = 6;
    public static final int PARTITIONBYLIST = 7;
    public static final int LOCAL = 8;
    public static boolean TEST_BYPASS_DATASTORE_CHECK = false;
    private final int policy;
    private String[] columns;
    private ArrayList<ArrayList<DataValueDescriptor>> values;
    private final int redundancy;
    private final int maxPartSize;
    private String colocateTable;
    private int[] columnPositions;
    private final boolean isPersistent;
    private SortedSet<String> serverGroups;

    public DistributionDescriptor(int policy, String[] columns, int redundancy, int maxPartSize, String colocateTable, boolean isPersistent, SortedSet<String> serverGroups) {
        this.policy = policy;
        this.columns = columns != null ? (String[])columns.clone() : null;
        this.values = null;
        this.redundancy = redundancy;
        this.maxPartSize = maxPartSize;
        this.colocateTable = colocateTable;
        this.isPersistent = isPersistent;
        this.serverGroups = serverGroups;
    }

    public final String getColocateTableName() {
        return this.colocateTable;
    }

    public void setColocateTableName(String colocatedTable) {
        this.colocateTable = colocatedTable;
    }

    public void addValueSet(ArrayList<DataValueDescriptor> valueSet) {
        if (this.values == null) {
            this.values = new ArrayList();
        }
        this.values.add(valueSet);
    }

    public void setPartitionColumnNames(String[] cols) {
        this.columns = cols != null ? (String[])cols.clone() : null;
    }

    public final String[] getPartitionColumnNames() {
        return this.columns;
    }

    public void setColumnPositions(int[] cols) {
        if (cols != null && cols.length > 0) {
            this.columnPositions = (int[])cols.clone();
            Arrays.sort(this.columnPositions);
        } else {
            this.columnPositions = null;
        }
    }

    public final int[] getColumnPositionsSorted() {
        return this.columnPositions;
    }

    public int getMaxPartSize() {
        return this.maxPartSize;
    }

    public ArrayList<ArrayList<DataValueDescriptor>> getPartitionColumnValues() {
        return this.values;
    }

    public int getPolicy() {
        return this.policy;
    }

    public int getRedundancy() {
        return this.redundancy;
    }

    public boolean getPersistence() {
        return this.isPersistent;
    }

    public boolean isPartitioned() {
        return this.policy >= 2 && this.policy <= 7;
    }

    public SortedSet<String> getServerGroups() {
        return this.serverGroups;
    }

    public void setServerGroups(SortedSet<String> sgs) {
        this.serverGroups = sgs;
    }

    public void resolveColumnPositions(TableDescriptor td) throws StandardException {
        assert (td != null) : "Table descriptor should be non-null!";
        if (this.columns == null) {
            return;
        }
        this.columnPositions = new int[this.columns.length];
        boolean[] dupDetectBitmap = new boolean[1013];
        int columnPosition = 0;
        Arrays.fill(dupDetectBitmap, false);
        for (int index = 0; index < this.columns.length; ++index) {
            ColumnDescriptor cd = td.getColumnDescriptor(this.columns[index]);
            if (cd == null) {
                SanityManager.DEBUG_PRINT((String)"warning:syntax", (String)("Failed to find column " + this.columns[index] + " in TableDescriptor " + td));
                throw StandardException.newException("42X01", "Failed to find column " + this.columns[index] + " in table " + td.getQualifiedName());
            }
            columnPosition = cd.getPosition();
            if (dupDetectBitmap[columnPosition]) {
                throw StandardException.newException("42X12", this.columns[index]);
            }
            dupDetectBitmap[columnPosition] = true;
            this.columnPositions[index] = cd.getPosition();
        }
        Arrays.sort(this.columnPositions);
    }

    public static void checkAvailableDataStore(LanguageConnectionContext lcc, SortedSet<String> serverGroups, String op) throws StandardException {
        GfxdDistributionAdvisor advisor;
        GemFireStore memStore;
        if (lcc != null && !lcc.isConnectionForRemote() && (memStore = Misc.getMemStore()).initialDDLReplayDone() && memStore.getDDLStmtQueue() != null && !TEST_BYPASS_DATASTORE_CHECK && (advisor = memStore.getDistributionAdvisor()).adviseDataStore(serverGroups, true) == null) {
            throw StandardException.newException("X0Z08.S", "execution of " + op + " in " + (serverGroups == null || serverGroups.size() == 0 ? "distributed system" : "server groups '" + serverGroups + "'"));
        }
    }

    public int getPartitioningColumnIdx(String colName) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].equalsIgnoreCase(colName)) continue;
            return i;
        }
        return -1;
    }
}

