/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.message;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.message.LeadNodeExecutorMsg;
import com.pivotal.gemfirexd.internal.engine.distributed.message.LeadNodeGetStatsMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.MemberExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.snappy.CallbackFactoryProvider;
import com.pivotal.gemfirexd.internal.snappy.ClusterCallbacks;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.Set;

public class GetLeadNodeInfoMsg
extends MemberExecutorMessage<Object> {
    private Object[] additionalArgs;
    private DataReqType requestType;
    private Long connID;

    public GetLeadNodeInfoMsg(ResultCollector<Object, Object> rc, DataReqType reqType, Long connID, Object ... args) {
        super(rc, null, false, true);
        this.requestType = reqType;
        this.additionalArgs = args;
        this.connID = connID;
    }

    public GetLeadNodeInfoMsg(ResultCollector<Object, Object> rc, DataReqType reqType, Long connID, String filePath) {
        super(rc, null, false, true);
        this.requestType = reqType;
        this.additionalArgs = new Object[1];
        this.additionalArgs[0] = filePath;
        this.connID = connID;
    }

    public GetLeadNodeInfoMsg() {
        super(true);
    }

    @Override
    public Set<DistributedMember> getMembers() {
        return Misc.getLeadNodes();
    }

    @Override
    public void postExecutionCallback() {
    }

    @Override
    public boolean isHA() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    protected void execute() throws Exception {
        if (GemFireXDUtils.TraceQuery) {
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"GetLeadNodeInfoMsg.execute: ");
        }
        try {
            Object result = null;
            switch (this.requestType) {
                case GET_JARS: {
                    result = this.handleGetJarsRequest();
                    break;
                }
                case EXPORT_DATA: {
                    if (GemFireXDUtils.TraceQuery) {
                        SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"GetLeadNodeInfoMsg - case EXPORT_DATA");
                    }
                    result = this.exportData();
                    break;
                }
                case EXPORT_DDLS: {
                    if (GemFireXDUtils.TraceQuery) {
                        SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)"GetLeadNodeInfoMsg - case EXPORT_DDLS");
                    }
                    result = this.exportDDLs();
                    break;
                }
                case GET_CLASS_BYTES: {
                    result = this.getClassBytes();
                    break;
                }
                case CHECK_EXT_TABLE_PERMISSION: {
                    result = this.checkExternalTableAuthorization();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("GetLeadNodeInfoMsg: Unknown data request type: " + (Object)((Object)this.requestType));
                }
            }
            this.lastResult(result, false, false, true);
        }
        catch (Exception ex) {
            throw LeadNodeExecutorMsg.getExceptionToSendToServer(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getClassBytes() throws IOException {
        String filePath = (String)this.additionalArgs[0];
        Path p = Paths.get(filePath, new String[0]);
        if (!Files.exists(p, new LinkOption[0])) {
            throw new FileNotFoundException(filePath);
        }
        File file = new File(filePath);
        try (FileInputStream fip = new FileInputStream(file);){
            byte[] fileContent = new byte[(int)file.length()];
            fip.read(fileContent);
            byte[] byArray = fileContent;
            return byArray;
        }
    }

    private String checkExternalTableAuthorization() throws IOException {
        if (!Misc.isSecurityEnabled()) {
            return null;
        }
        boolean checkAuthOfExternalTables = Boolean.parseBoolean(System.getProperty("CHECK_EXTERNAL_TABLE_AUTHZ"));
        if (!checkAuthOfExternalTables) {
            return null;
        }
        String user = (String)this.additionalArgs[0];
        String allTableStr = (String)this.additionalArgs[1];
        String[] allTable = allTableStr.split(",");
        ClusterCallbacks ccb = CallbackFactoryProvider.getClusterCallbacks();
        String result = null;
        for (String t : allTable) {
            if (ccb.isUserAuthorizedForExternalTable(user, t)) continue;
            result = t;
            break;
        }
        return result;
    }

    private String exportData() {
        CallbackFactoryProvider.getClusterCallbacks().exportData(this.connID, this.additionalArgs[0].toString(), this.additionalArgs[1].toString(), this.additionalArgs[2].toString(), Boolean.parseBoolean(this.additionalArgs[3].toString()));
        return "Data recovered";
    }

    private String exportDDLs() {
        CallbackFactoryProvider.getClusterCallbacks().exportDDLs(this.connID, this.additionalArgs[0].toString());
        return "DDLs recovered.";
    }

    private String handleGetJarsRequest() {
        URLClassLoader ul = com.gemstone.gemfire.internal.snappy.CallbackFactoryProvider.getStoreCallbacks().getLeadClassLoader();
        URL[] allJarUris = ul.getURLs();
        StringBuffer res = new StringBuffer();
        for (URL u : allJarUris) {
            res.append(u);
            res.append(',');
        }
        if (res.length() > 0) {
            return res.substring(0, res.length() - 1);
        }
        return null;
    }

    @Override
    protected void executeFunction(boolean enableStreaming) throws StandardException, SQLException {
        try {
            super.executeFunction(enableStreaming);
        }
        catch (RuntimeException re) {
            throw LeadNodeExecutorMsg.handleLeadNodeRuntimeException(re);
        }
    }

    @Override
    protected LeadNodeGetStatsMessage clone() {
        LeadNodeGetStatsMessage msg = new LeadNodeGetStatsMessage((ResultCollector<Object, Object>)this.userCollector);
        return msg;
    }

    @Override
    public byte getGfxdID() {
        return 60;
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        super.fromData(in);
        this.requestType = (DataReqType)((Object)DataSerializer.readObject((DataInput)in));
        this.additionalArgs = DataSerializer.readObjectArray((DataInput)in);
        this.connID = DataSerializer.readLong((DataInput)in);
    }

    public void toData(DataOutput out) throws IOException {
        super.toData(out);
        DataSerializer.writeObject((Object)((Object)this.requestType), (DataOutput)out);
        DataSerializer.writeObjectArray((Object[])this.additionalArgs, (DataOutput)out);
        DataSerializer.writeLong((Long)this.connID, (DataOutput)out);
    }

    @Override
    public void appendFields(StringBuilder sb) {
    }

    public static enum DataReqType {
        GET_JARS,
        EXPORT_DATA,
        EXPORT_DDLS,
        GET_CLASS_BYTES,
        CHECK_EXT_TABLE_PERMISSION;

    }
}

