/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.message;

import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public final class BitSetSet
extends AbstractCollection<Integer>
implements Set<Integer>,
Serializable {
    private static final long serialVersionUID = 3340094932157368925L;
    static final int ADDRESS_BYTES = 3;
    static final int ADDRESS_SIZE = 8;
    static final int ADDRESS_SIZE_1 = 7;
    private final byte[] bitMap;
    private int numUsedBits;

    public static int udiv8(int i) {
        return i >> 3;
    }

    public static int umod8(int i) {
        return i & 7;
    }

    static int umul8(int i) {
        return i << 3;
    }

    static int numBytes(int nbits) {
        return BitSetSet.udiv8(nbits + 7);
    }

    public BitSetSet(int nbits) {
        this.bitMap = nbits != 0 ? new byte[BitSetSet.numBytes(nbits)] : ReuseFactory.getZeroLenByteArray();
    }

    private BitSetSet(int nbytes, boolean useAsBytes) {
        this.bitMap = nbytes != 0 ? new byte[nbytes] : ReuseFactory.getZeroLenByteArray();
    }

    @Override
    public boolean add(Integer val) {
        return this.addInt(val);
    }

    public boolean addInt(int val) {
        int posByteMask;
        int byteIndex = BitSetSet.udiv8(val);
        if ((this.bitMap[byteIndex] & (posByteMask = 1 << BitSetSet.umod8(val))) == 0) {
            int n = byteIndex;
            this.bitMap[n] = (byte)(this.bitMap[n] | posByteMask);
            ++this.numUsedBits;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object val) {
        return this.containsInt((Integer)val);
    }

    public boolean containsInt(int val) {
        int byteIndex = BitSetSet.udiv8(val);
        return byteIndex < this.bitMap.length && (this.bitMap[byteIndex] & 1 << BitSetSet.umod8(val)) != 0;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Itr();
    }

    @Override
    public boolean remove(Object val) {
        return this.removeInt((Integer)val);
    }

    public boolean removeInt(int pos) {
        int posByte;
        int byteIndex = BitSetSet.udiv8(pos);
        boolean isSet = (this.bitMap[byteIndex] & (posByte = 1 << BitSetSet.umod8(pos))) != 0;
        int n = byteIndex;
        this.bitMap[n] = (byte)(this.bitMap[n] & ~posByte);
        if (isSet) {
            --this.numUsedBits;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object val : c) {
            changed |= this.remove(val);
        }
        return changed;
    }

    @Override
    public void clear() {
        Arrays.fill(this.bitMap, (byte)0);
    }

    @Override
    public boolean isEmpty() {
        return this.numUsedBits == 0;
    }

    @Override
    public int size() {
        return this.numUsedBits;
    }

    public static void toData(BitSetSet bss, DataOutput out) throws IOException {
        if (bss != null) {
            bss.toData(out);
        } else {
            InternalDataSerializer.writeSignedVL((long)0L, (DataOutput)out);
        }
    }

    public void toData(DataOutput out) throws IOException {
        int nbytes = this.bitMap.length;
        if (nbytes > 0) {
            int limitForArraySerialization;
            int n = limitForArraySerialization = nbytes <= 32 ? nbytes * 3 / 5 : 1;
            if (this.numUsedBits <= limitForArraySerialization) {
                InternalDataSerializer.writeSignedVL((long)(-this.numUsedBits), (DataOutput)out);
                int pos = this.prevSetBit(nbytes - 1, 7);
                while (pos >= 0) {
                    InternalDataSerializer.writeUnsignedVL((long)pos, (DataOutput)out);
                    pos = this.prevSetBit(pos - 1);
                }
            } else {
                byte[] inUseByteMap = new byte[BitSetSet.numBytes(nbytes)];
                for (int index = 0; index < nbytes; ++index) {
                    if (this.bitMap[index] == 0) continue;
                    int n2 = BitSetSet.udiv8(index);
                    inUseByteMap[n2] = (byte)(inUseByteMap[n2] | 1 << BitSetSet.umod8(index));
                }
                int inUseLen = inUseByteMap.length;
                InternalDataSerializer.writeSignedVL((long)inUseLen, (DataOutput)out);
                out.write(inUseByteMap, 0, inUseLen);
                for (int index = 0; index < nbytes; ++index) {
                    byte currByte = this.bitMap[index];
                    if (currByte == 0) continue;
                    out.writeByte(currByte);
                }
            }
        } else {
            InternalDataSerializer.writeSignedVL((long)0L, (DataOutput)out);
        }
    }

    public static BitSetSet fromData(DataInput in) throws IOException, ClassNotFoundException {
        int inUseLen = (int)InternalDataSerializer.readSignedVL((DataInput)in);
        if (inUseLen < 0) {
            int maxVal = (int)InternalDataSerializer.readUnsignedVL((DataInput)in);
            BitSetSet set = new BitSetSet(maxVal + 1);
            set.addInt(maxVal);
            int numBits = -inUseLen;
            for (int index = 1; index < numBits; ++index) {
                set.addInt((int)InternalDataSerializer.readUnsignedVL((DataInput)in));
            }
            return set;
        }
        if (inUseLen > 0) {
            byte[] inUseByteMap = new byte[inUseLen];
            in.readFully(inUseByteMap, 0, inUseLen);
            BitSetSet set = new BitSetSet(BitSetSet.umul8(inUseLen), true);
            for (int index = 0; index < inUseLen; ++index) {
                byte inUseByte = inUseByteMap[index];
                int startPos = BitSetSet.umul8(index);
                for (int pos = 0; pos < 8; ++pos) {
                    byte v;
                    if ((inUseByte & 1 << pos) == 0) continue;
                    set.bitMap[startPos + pos] = v = in.readByte();
                    v = (byte)(v - (v >> 1 & 0x55));
                    v = (byte)((v & 0x33) + (v >> 2 & 0x33));
                    v = (byte)((v & 7) + (v >> 4));
                    set.numUsedBits += v;
                }
            }
            return set;
        }
        return null;
    }

    public int nextSetBit(int pos) {
        return this.nextSetBit(BitSetSet.udiv8(pos), BitSetSet.umod8(pos));
    }

    public int nextSetBit(int startIndex, int startPos) {
        int bitMapLen = this.bitMap.length;
        while (startIndex < bitMapLen) {
            int currByte = this.bitMap[startIndex] >>> startPos;
            if (currByte != 0) {
                startPos = (currByte & 0xF) != 0 ? ((currByte & 3) != 0 ? (startPos += (currByte & 1) != 0 ? 0 : 1) : (startPos += (currByte & 4) != 0 ? 2 : 3)) : ((currByte & 0x30) != 0 ? (startPos += (currByte & 0x10) != 0 ? 4 : 5) : (startPos += (currByte & 0x40) != 0 ? 6 : 7));
                return startPos + BitSetSet.umul8(startIndex);
            }
            startPos = 0;
            ++startIndex;
        }
        return -1;
    }

    public int prevSetBit(int pos) {
        return this.prevSetBit(BitSetSet.udiv8(pos), BitSetSet.umod8(pos));
    }

    public int prevSetBit(int startIndex, int startPos) {
        while (startIndex >= 0) {
            int currByte = this.bitMap[startIndex];
            if (startPos >= 0) {
                currByte &= (1 << startPos + 1) - 1;
            }
            if (currByte != 0) {
                int p = (currByte & 0xF0) != 0 ? ((currByte & 0xC0) != 0 ? ((currByte & 0x80) != 0 ? 7 : 6) : ((currByte & 0x20) != 0 ? 5 : 4)) : ((currByte & 0xC) != 0 ? ((currByte & 8) != 0 ? 3 : 2) : ((currByte & 2) != 0 ? 1 : 0));
                return p + BitSetSet.umul8(startIndex);
            }
            startPos = -1;
            --startIndex;
        }
        return -1;
    }

    private class Itr
    implements Iterator<Integer> {
        private int cursor;
        private int lastRet;

        Itr() {
            this.cursor = BitSetSet.this.nextSetBit(0, 0);
            this.lastRet = -1;
        }

        @Override
        public boolean hasNext() {
            return this.cursor >= 0;
        }

        @Override
        public Integer next() {
            if (this.cursor < 0) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            this.cursor = BitSetSet.this.nextSetBit(this.cursor + 1);
            return this.lastRet;
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            BitSetSet.this.removeInt(this.lastRet);
            this.lastRet = -1;
        }
    }
}

