/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gnu.trove.TObjectIntHashMap;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdReplyMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdReplyMessageProcessor;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResponseCode;
import java.util.Set;

public abstract class GfxdWaitingReplyProcessorBase
extends GfxdReplyMessageProcessor {
    protected TObjectIntHashMap waiters;

    public GfxdWaitingReplyProcessorBase(DM dm, Set<DistributedMember> members, boolean register) {
        super(dm, members, register);
    }

    public GfxdWaitingReplyProcessorBase(DM dm, InternalDistributedMember member, boolean register) {
        super(dm, member, register);
    }

    public final boolean hasWaiters() {
        return this.stillWaiting();
    }

    protected final int getCurrSequenceId(DistributedMember member) {
        assert (Thread.holdsLock((Object)this));
        if (this.waiters != null) {
            return this.waiters.get((Object)member);
        }
        return 0;
    }

    protected final TObjectIntHashMap newWaitersMap() {
        assert (Thread.holdsLock((Object)this));
        if (this.waiters != null) {
            return this.waiters;
        }
        this.waiters = new TObjectIntHashMap();
        return this.waiters;
    }

    protected abstract void addGrantedMember(DistributedMember var1);

    public final synchronized boolean addGrantedMember(DistributedMember member, int sequenceId) {
        assert (sequenceId > 0);
        int newSequenceId = 0;
        if (sequenceId == 1 || (newSequenceId = sequenceId - this.getCurrSequenceId(member)) <= 1) {
            this.addGrantedMember(member);
            return false;
        }
        this.newWaitersMap().put((Object)member, -(--newSequenceId));
        return true;
    }

    public final synchronized boolean addWaitingMember(DistributedMember member, int sequenceId) {
        assert (sequenceId >= 0);
        TObjectIntHashMap waiters = this.newWaitersMap();
        if (sequenceId == 0) {
            waiters.put((Object)member, 0);
        } else {
            int currSequenceId = this.getCurrSequenceId(member);
            if (currSequenceId != -1) {
                waiters.put((Object)member, ++currSequenceId);
            } else {
                this.addGrantedMember(member);
                return false;
            }
        }
        return true;
    }

    protected final boolean processResponseCode(GfxdReplyMessage reply, GfxdResponseCode responseCode) {
        if (responseCode.isWaiting()) {
            return this.addWaitingMember((DistributedMember)reply.getSender(), responseCode.waitingSequenceId());
        }
        if (responseCode.isGrant()) {
            return this.addGrantedMember((DistributedMember)reply.getSender(), responseCode.grantedSequenceId());
        }
        return false;
    }

    protected final boolean removeMember(InternalDistributedMember member, boolean departed) {
        boolean result = super.removeMember(member, departed);
        this.removeMemberFromLists(member, departed);
        return result;
    }

    protected synchronized void removeMemberFromLists(InternalDistributedMember member, boolean departed) {
        if (this.waiters != null) {
            this.waiters.remove((Object)member);
        }
    }
}

