/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.diag;

import com.gemstone.gemfire.cache.execute.FunctionException;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplate;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplateNoAllNodesRoute;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.FunctionExecutionException;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdSingleResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.message.LeadNodeGetStatsMessage;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.ui.SnappyRegionStats;
import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import com.pivotal.gemfirexd.internal.impl.jdbc.TransactionResourceImpl;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnappyTableStatsVTI
extends GfxdVTITemplate
implements GfxdVTITemplateNoAllNodesRoute {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private Iterator<?> tableStats;
    private SnappyRegionStats currentTableStats;
    private static final String TABLENAME = "TABLENAME";
    private static final String IS_COLUMN_TABLE = "IS_COLUMN_TABLE";
    private static final String IS_REPLICATED_TABLE = "IS_REPLICATED_TABLE";
    private static final String ROW_COUNT = "ROW_COUNT";
    private static final String SIZE_IN_MEMORY = "SIZE_IN_MEMORY";
    private static final String TOTAL_SIZE = "TOTAL_SIZE";
    private static final String BUCKETS = "BUCKETS";
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("TABLENAME", 12, false, 512), EmbedResultSetMetaData.getResultColumnDescriptor("IS_COLUMN_TABLE", 16, false), EmbedResultSetMetaData.getResultColumnDescriptor("IS_REPLICATED_TABLE", 16, false), EmbedResultSetMetaData.getResultColumnDescriptor("ROW_COUNT", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("SIZE_IN_MEMORY", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("TOTAL_SIZE", -5, false), EmbedResultSetMetaData.getResultColumnDescriptor("BUCKETS", 4, false)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return metadata;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.tableStats == null) {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("SnappyTableStatsVTI: getting table stats from lead " + Misc.getLeadNodes());
                }
                GfxdSingleResultCollector collector = new GfxdSingleResultCollector();
                LeadNodeGetStatsMessage msg = new LeadNodeGetStatsMessage(collector);
                this.tableStats = ((List)msg.executeFunction()).iterator();
            }
            catch (SQLException se) {
                throw se;
            }
            catch (StandardException se) {
                throw PublicAPI.wrapStandardException(se);
            }
            catch (RuntimeException re) {
                String message = (re instanceof FunctionException || re instanceof FunctionExecutionException) && re.getCause() != null ? re.getCause().getMessage() : re.getMessage();
                throw Util.newEmbedSQLException("38000", new Object[]{message}, re);
            }
            catch (Throwable t) {
                throw TransactionResourceImpl.wrapInSQLException(t);
            }
        }
        if (this.tableStats.hasNext()) {
            this.currentTableStats = (SnappyRegionStats)this.tableStats.next();
            this.wasNull = false;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SnappyTableStatsVTI: read: " + this.currentTableStats);
            }
            return true;
        }
        return false;
    }

    @Override
    protected Object getObjectForColumn(int columnNumber) throws SQLException {
        switch (columnNumber) {
            case 1: {
                return this.currentTableStats.getTableName();
            }
            case 2: {
                return this.currentTableStats.isColumnTable();
            }
            case 3: {
                return this.currentTableStats.isReplicatedTable();
            }
            case 4: {
                return this.currentTableStats.getRowCount();
            }
            case 5: {
                return this.currentTableStats.getSizeInMemory();
            }
            case 6: {
                return this.currentTableStats.getTotalSize();
            }
            case 7: {
                return this.currentTableStats.getBucketCount();
            }
        }
        throw new GemFireXDRuntimeException("unexpected column=" + columnNumber + " for SnappyTablesStatsVTI");
    }
}

