/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.index;

import com.gemstone.gemfire.CancelCriterion;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.Assert;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.TXEntryState;
import com.gemstone.gemfire.internal.cache.TXId;
import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gemfire.internal.cache.TXStateInterface;
import com.gemstone.gemfire.internal.cache.TXStateProxy;
import com.gemstone.gemfire.internal.cache.execute.InternalRegionFunctionContext;
import com.gemstone.gemfire.internal.cache.locks.LockMode;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.access.MemScanController;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.index.GlobalExecRowLocation;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndex;
import com.pivotal.gemfirexd.internal.engine.access.index.OpenMemIndex;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.BackingStoreHashtable;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowCountable;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.Conglomerate;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Page;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;
import java.util.Properties;
import java.util.Set;

public abstract class MemIndexScanController
implements MemScanController,
ScanInfo,
RowCountable {
    public static final int MAX = 7;
    protected final OpenMemIndex openConglom = new OpenMemIndex();
    protected GemFireXDQueryObserver observer;
    protected boolean hasNext = true;
    protected FormatableBitSet init_scanColumnList;
    protected DataValueDescriptor[] init_startKeyValue;
    protected int init_startSearchOperator;
    protected Qualifier[][] init_qualifier;
    protected DataValueDescriptor[] init_stopKeyValue;
    protected int init_stopSearchOperator;
    protected long estimatedRowCount = -1L;
    protected int openMode = -1;
    protected int forUpdate;
    protected boolean forReadOnly;
    protected Activation activation;
    protected GemFireContainer baseContainer;
    protected CancelCriterion cc;
    protected RowLocation currentRowLocation;
    protected LanguageConnectionContext lcc;
    protected GemFireTransaction tran;
    protected TXStateInterface txState;
    protected TXId txId;
    protected com.gemstone.gemfire.internal.cache.locks.LockingPolicy lockPolicy;
    protected LockMode readLockMode;
    protected TXState localTXState;
    protected LocalRegion currentDataRegion;
    protected Object lockContext;
    protected boolean restoreBatching = true;
    protected int[] statNumRowsVisited;
    protected int statNumRowsQualified;
    protected int statNumDeletedRowsVisited;
    protected FormatableBitSet statValidColumns;
    protected boolean queryHDFS = false;

    @Override
    public final void init(GemFireTransaction tran, MemConglomerate conglomerate, int openMode, int lockLevel, LockingPolicy locking, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, Activation act) throws StandardException {
        if (GemFireXDUtils.TraceIndex) {
            GfxdIndexManager.traceIndex("Opening MemIndexScanController for index container=%s, in mode=0x%s with scanColumnList=%s startKey=%s startOp=%s stopKey=%s stopOp=%s qualifier=%s", conglomerate.getGemFireContainer(), Integer.toHexString(openMode), scanColumnList, ArrayUtils.objectString((Object)startKeyValue), startSearchOperator, ArrayUtils.objectString((Object)stopKeyValue), stopSearchOperator, ArrayUtils.objectString((Object)qualifier));
        }
        this.openMode = openMode;
        this.openConglom.init(tran, (MemIndex)conglomerate, openMode, lockLevel, locking);
        this.init_scanColumnList = scanColumnList;
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null) {
            observer.scanControllerOpened(this, conglomerate);
        }
        this.positionAtInitScan(startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, act);
    }

    @Override
    public final boolean isScanClosed() {
        return this.openConglom.isClosed();
    }

    private final void initializeSearchCondition(DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator) {
        this.init_startKeyValue = RowUtil.isRowEmpty(startKeyValue) ? null : startKeyValue;
        this.init_startSearchOperator = startSearchOperator;
        if (qualifier != null && qualifier.length == 0) {
            qualifier = null;
        }
        this.init_qualifier = qualifier;
        this.init_stopKeyValue = RowUtil.isRowEmpty(stopKeyValue) ? null : stopKeyValue;
        this.init_stopSearchOperator = stopSearchOperator;
    }

    protected final void positionAtInitScan(DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, Activation act) throws StandardException {
        LocalRegion region;
        boolean restoreBatching;
        this.activation = act;
        this.baseContainer = this.openConglom.getBaseContainer();
        assert (this.baseContainer != null) : "GemFire baseContainer cannot be null";
        this.cc = this.baseContainer.getRegion().getCancelCriterion();
        if (this.baseContainer.isApplicationTableOrGlobalIndex()) {
            this.observer = GemFireXDQueryObserverHolder.getInstance();
        }
        this.tran = this.openConglom.getTransaction();
        this.lcc = this.tran.getLanguageConnectionContext();
        if (this.lcc != null && this.lcc.getRunTimeStatisticsMode()) {
            this.statNumRowsVisited = new int[]{0};
            this.statValidColumns = this.init_scanColumnList != null ? this.init_scanColumnList.clone() : null;
        } else {
            this.statNumRowsVisited = null;
            this.statValidColumns = null;
        }
        this.statNumDeletedRowsVisited = 0;
        this.statNumRowsQualified = 0;
        this.initializeSearchCondition(startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator);
        this.postProcessSearchCondition();
        if (GemFireXDUtils.TraceIndex) {
            GfxdIndexManager.traceIndex("MemIndexScanController#positionAtInit: startKey=%s, stopKey=%s", startKeyValue, stopKeyValue);
            if (this.init_qualifier != null) {
                StringBuilder qualStr = new StringBuilder();
                for (Qualifier[] qual : this.init_qualifier) {
                    qualStr.append('(');
                    if (qual != null) {
                        for (Qualifier q : qual) {
                            if (q != null) {
                                qualStr.append("id=").append(q.getColumnId()).append(" value=").append(q.getOrderable());
                                continue;
                            }
                            qualStr.append("null");
                        }
                        qualStr.append(',');
                    } else {
                        qualStr.append("NULL");
                    }
                    qualStr.append(')');
                }
                GfxdIndexManager.traceIndex("MemIndexScanController#positionAtInit: qualifier=%s", qualStr.toString());
            } else {
                GfxdIndexManager.traceIndex("MemIndexScanController#positionAtInit: qualifier is null", new Object[0]);
            }
        }
        this.forUpdate = (this.openMode & 4) != 0 ? 128 : 0;
        this.forReadOnly = (this.openMode & 0x800000) != 0;
        this.txState = this.baseContainer.getActiveTXState(this.tran);
        if (this.txState != null) {
            this.txId = this.txState.getTransactionId();
            this.lockPolicy = this.txState.getLockingPolicy();
            if (this.forUpdate != 0) {
                this.readLockMode = LockMode.SH;
                this.localTXState = this.txState.getTXStateForWrite();
                this.lockContext = this.localTXState.getReadLocksForScanContext((Object)this.lcc);
                restoreBatching = this.localTXState.getProxy().remoteBatching(true);
            } else if (this.forReadOnly) {
                this.readLockMode = this.lockPolicy.getReadOnlyLockMode();
                this.localTXState = this.txState.getTXStateForWrite();
                this.lockContext = null;
                restoreBatching = this.localTXState.getProxy().remoteBatching(true);
            } else if (this.lockPolicy.zeroDurationReadLocks()) {
                this.readLockMode = null;
                this.localTXState = this.txState.getLocalTXState();
                this.lockContext = null;
                restoreBatching = true;
            } else {
                this.readLockMode = this.lockPolicy.getReadLockMode();
                this.localTXState = this.txState.getTXStateForRead();
                if (this.localTXState == null) {
                    Assert.fail((Object)("unexpected null local read TXState lockingPolicy=" + this.lockPolicy + " for " + this.txState));
                }
                this.lockContext = this.localTXState.getReadLocksForScanContext((Object)this.lcc);
                restoreBatching = this.localTXState.getProxy().remoteBatching(true);
            }
        } else {
            this.txId = null;
            this.readLockMode = null;
            this.localTXState = null;
            this.lockContext = null;
            restoreBatching = true;
        }
        if (!restoreBatching && this.restoreBatching) {
            this.restoreBatching = false;
        }
        this.currentRowLocation = null;
        if (this.lcc != null) {
            this.queryHDFS = this.lcc.getQueryHDFS();
        }
        if (act != null && act.getHasQueryHDFS()) {
            this.queryHDFS = act.getQueryHDFS();
        }
        if (this.forUpdate != 0) {
            this.queryHDFS = true;
        }
        if ((region = this.baseContainer.getRegion()) != null && region instanceof PartitionedRegion) {
            ((PartitionedRegion)region).setQueryHDFS(this.queryHDFS);
        }
        this.initEnumerator();
    }

    protected final boolean containRowLocation(DataValueDescriptor[] searchKey) {
        SanityManager.ASSERT((searchKey != null ? 1 : 0) != 0);
        return searchKey[searchKey.length - 1] instanceof RowLocation;
    }

    protected final DataValueDescriptor[] removeRowLocation(DataValueDescriptor[] searchKey) {
        DataValueDescriptor[] newSearchKey = new DataValueDescriptor[searchKey.length - 1];
        for (int i = 0; i < searchKey.length - 1; ++i) {
            newSearchKey[i] = searchKey[i];
        }
        return newSearchKey;
    }

    protected void postProcessSearchCondition() throws StandardException {
    }

    protected abstract void initEnumerator() throws StandardException;

    @Override
    public final RowLocation fetchLocation(RowLocation destRowLocation) throws StandardException {
        if (this.currentRowLocation != null) {
            if (destRowLocation == null || !(destRowLocation instanceof GlobalExecRowLocation)) {
                return this.currentRowLocation;
            }
            GlobalExecRowLocation destloc = (GlobalExecRowLocation)destRowLocation;
            destloc.setFrom(this.currentRowLocation.getRegionEntry());
            return destloc;
        }
        return null;
    }

    public static Set<Integer> getLocalBucketSet(GemFireContainer gfc, LocalRegion region, Activation act, String indexType) {
        try {
            FunctionContext fc;
            if (act != null && (fc = act.getFunctionContext()) != null) {
                Set localBucketSet = ((InternalRegionFunctionContext)fc).getLocalBucketSet((Region)region);
                if (GemFireXDUtils.TraceIndex) {
                    GfxdIndexManager.traceIndex("%s the baseContainer is %s and the local data set is %s, function context is %s", indexType, region.getFullPath(), localBucketSet, fc);
                }
                if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
                    SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)(indexType + " scanning index: " + gfc + ", local data set is " + localBucketSet + ", and the function context: " + fc));
                }
                return localBucketSet;
            }
            if (GemFireXDUtils.TraceIndex) {
                GfxdIndexManager.traceIndex("%s the FunctionContext is null ", indexType);
            }
        }
        catch (CacheClosedException ex) {
            return null;
        }
        return null;
    }

    protected final void checkCancelInProgress() {
        if (this.cc == null) {
            this.cc = Misc.getGemFireCache().getCancelCriterion();
        }
        this.cc.checkCancelInProgress(null);
    }

    public final void dumpIndex(String marker) {
        this.openConglom.getConglomerate().dumpIndex(marker);
    }

    public int sizeOfIndex() {
        return 0;
    }

    @Override
    public long getEstimatedRowCount() throws StandardException {
        return 0L;
    }

    @Override
    public void didNotQualify() throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public boolean doesCurrentPositionQualify() throws StandardException {
        return false;
    }

    @Override
    public void fetchWithoutQualify(DataValueDescriptor[] destRow) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public boolean isCurrentPositionDeleted() throws StandardException {
        return false;
    }

    @Override
    public boolean isHeldAfterCommit() throws StandardException {
        return false;
    }

    @Override
    public boolean positionAtRowLocation(RowLocation rl) throws StandardException {
        return false;
    }

    @Override
    public boolean replace(DataValueDescriptor[] row, FormatableBitSet validColumns) throws StandardException {
        return false;
    }

    @Override
    public final void close() throws StandardException {
        if (this.tran != null) {
            this.tran.closeMe(this);
            this.openConglom.close();
            this.tran = null;
            if (this.localTXState != null) {
                if (this.lockContext != null) {
                    if (this.forUpdate != 0) {
                        this.localTXState.pendingReadLocksCleanup(this.lockPolicy, this.lockContext, (Object)this.lcc);
                    } else {
                        this.localTXState.pendingReadLocksToTXState(this.lockPolicy, this.lockContext, (Object)this.lcc);
                    }
                }
                if (!this.restoreBatching) {
                    this.localTXState.getProxy().remoteBatching(false);
                    this.restoreBatching = true;
                }
            }
            this.closeScan();
        }
        this.estimatedRowCount = -1L;
        this.baseContainer = null;
        this.cc = null;
        this.activation = null;
        this.lcc = null;
        this.txId = null;
        this.txState = null;
        this.localTXState = null;
        this.lockContext = null;
        this.hasNext = false;
        this.init_qualifier = null;
        this.init_scanColumnList = null;
        this.init_startKeyValue = null;
        this.init_stopKeyValue = null;
        this.currentRowLocation = null;
        this.currentDataRegion = null;
        this.observer = null;
    }

    protected abstract void closeScan();

    @Override
    public boolean isKeyed() {
        return true;
    }

    @Override
    public boolean isTableLocked() {
        return false;
    }

    @Override
    public RowLocation newRowLocationTemplate() throws StandardException {
        throw new AssertionError((Object)"not expected to be called");
    }

    @Override
    public void reopenScan(DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, Activation activation) throws StandardException {
        this.positionAtInitScan(startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, activation);
    }

    @Override
    public void reopenScanByRowLocation(RowLocation startRowLocation, Qualifier[][] qualifier) throws StandardException {
        throw new AssertionError((Object)"not expected to be called");
    }

    @Override
    public void setEstimatedRowCount(long count) throws StandardException {
        this.estimatedRowCount = count;
    }

    public String getIndexTypeName() {
        if (this.openConglom != null) {
            if (this.openConglom.getConglomerate() != null) {
                return this.openConglom.getConglomerate().getIndexTypeName();
            }
            return "Empty " + this.openConglom;
        }
        return "Empty openConglom";
    }

    @Override
    public final boolean closeForEndTransaction(boolean closeHeldScan) throws StandardException {
        if (closeHeldScan) {
            this.close();
            return true;
        }
        return false;
    }

    @Override
    public int getScanKeyGroupID() {
        throw new UnsupportedOperationException("not expected to be invoked");
    }

    @Override
    public final ScanInfo getScanInfo() throws StandardException {
        return this;
    }

    @Override
    public final Properties getAllScanInfo(Properties prop) throws StandardException {
        if (prop == null) {
            prop = new Properties();
        }
        prop.setProperty(MessageService.getTextMessage("XSAJ0.U"), this.getIndexTypeName());
        prop.setProperty(MessageService.getTextMessage("XSAJ2.U"), Integer.toString(this.getNumRowsVisited()));
        prop.setProperty(MessageService.getTextMessage("XSAJ3.U"), Integer.toString(this.statNumDeletedRowsVisited));
        prop.setProperty(MessageService.getTextMessage("XSAJ4.U"), Integer.toString(this.statNumRowsQualified));
        prop.setProperty(MessageService.getTextMessage("XSAJ7.U"), Integer.toString(this.openConglom.getConglomerate().getHeight()));
        prop.setProperty(MessageService.getTextMessage("XSAJ5.U"), Integer.toString(this.statValidColumns != null ? this.statValidColumns.getNumBitsSet() : this.openConglom.getRowForExportTemplate().length));
        prop.setProperty(MessageService.getTextMessage("XSAJ6.U"), this.statValidColumns == null ? MessageService.getTextMessage("XSAJE.U") : this.statValidColumns.toString());
        return prop;
    }

    @Override
    public void fetchSet(long max_rowcnt, int[] key_column_numbers, BackingStoreHashtable hash_table) throws StandardException {
        if (!this.hasNext) {
            return;
        }
        while (true) {
            DataValueDescriptor[] row = this.openConglom.getRowForExport();
            this.hasNext = this.fetchNext(row);
            if (!this.hasNext) break;
            hash_table.putRow(false, row, null);
        }
    }

    @Override
    public void savePosition(Conglomerate conglom, Page page) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public final int fetchNextGroup(DataValueDescriptor[][] row_array, RowLocation[] rowloc_array) throws StandardException {
        int row_idx;
        if (!this.hasNext) {
            return 0;
        }
        int rowCnt = row_array.length;
        for (row_idx = 0; row_idx < rowCnt; ++row_idx) {
            if (row_array[row_idx] != null) {
                this.hasNext = this.fetchNext(row_array[row_idx]);
                if (!this.hasNext) {
                    break;
                }
            } else {
                DataValueDescriptor[] row = this.openConglom.getRowForExport();
                this.hasNext = this.fetchNext(row);
                if (!this.hasNext) break;
                row_array[row_idx] = row;
            }
            if (rowloc_array == null) continue;
            rowloc_array[row_idx] = this.fetchLocation(rowloc_array[row_idx]);
        }
        return row_idx;
    }

    @Override
    public final int fetchNextGroup(ExecRow[] row_array, RowLocation[] rowloc_array, Object[] indexKeys, int[] nodeVersions, int[] scanKeyGroupID, LocalRegion[] dataRegions) throws StandardException {
        int i;
        assert (dataRegions == null);
        if (!this.hasNext) {
            return 0;
        }
        int max_rowcnt = row_array.length;
        for (i = 0; i < max_rowcnt; ++i) {
            if (row_array[i] != null) {
                this.hasNext = this.fetchNext(row_array[i]);
                if (!this.hasNext) {
                    break;
                }
            } else {
                ExecRow row = row_array[0].getNewNullRow();
                this.hasNext = this.fetchNext(row);
                if (!this.hasNext) break;
                row_array[i] = row;
            }
            if (rowloc_array != null) {
                rowloc_array[i] = this.fetchLocation(rowloc_array[i]);
            }
            if (indexKeys != null) {
                indexKeys[i] = this.getCurrentKey();
            }
            if (nodeVersions != null) {
                nodeVersions[i] = this.getCurrentNodeVersion();
            }
            if (scanKeyGroupID == null) continue;
            scanKeyGroupID[i] = this.getScanKeyGroupID();
        }
        return i;
    }

    @Override
    public final int fetchNextGroup(DataValueDescriptor[][] row_array, RowLocation[] oldrowloc_array, RowLocation[] newrowloc_array) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    @Override
    public void fetch(ExecRow destRow) throws StandardException {
        assert (destRow instanceof ValueRow);
        this.fetch(destRow.getRowArray());
    }

    @Override
    public ExecRow fetchRow(ExecRow destRow) throws StandardException {
        throw new AssertionError((Object)"should not be called");
    }

    @Override
    public boolean fetchNext(ExecRow destRow) throws StandardException {
        assert (destRow instanceof ValueRow);
        return this.fetchNext(destRow.getRowArray());
    }

    @Override
    public final RowLocation getCurrentRowLocation() {
        return this.currentRowLocation;
    }

    public Object getCurrentKey() {
        return null;
    }

    public int getCurrentNodeVersion() {
        return 0;
    }

    @Override
    public final void upgradeCurrentRowLocationLockToWrite() throws StandardException {
        if (this.currentRowLocation != null && this.currentDataRegion != null) {
            RegionEntry entry = this.currentRowLocation.getUnderlyingRegionEntry();
            TXStateProxy txProxy = this.localTXState.getProxy();
            if (this.observer != null) {
                this.observer.lockingRowForTX(txProxy, this.baseContainer, entry, true);
            }
            try {
                txProxy.lockEntry(entry, entry.getKey(), GemFireXDUtils.getRoutingObject(this.currentRowLocation.getBucketID()), this.baseContainer.getRegion(), this.currentDataRegion, true, TXEntryState.getLockForUpdateOp());
            }
            finally {
                GemFireXDUtils.releaseLockForReadOnPreviousEntry(entry, this.localTXState, this.txId, this.lockPolicy, this.readLockMode, this.baseContainer, this.currentDataRegion, this.lockContext);
            }
            this.currentDataRegion = null;
        }
    }

    @Override
    public void releaseCurrentRowLocationReadLock() throws StandardException {
        if (this.currentRowLocation != null && this.currentDataRegion != null) {
            GemFireXDUtils.releaseLockForReadOnPreviousEntry(this.currentRowLocation.getUnderlyingRegionEntry(), this.localTXState, this.txId, this.lockPolicy, this.readLockMode, this.baseContainer, this.currentDataRegion, this.lockContext);
            this.currentDataRegion = null;
        }
    }

    @Override
    public void fetchWithoutQualify(ExecRow destRow) throws StandardException {
        throw StandardException.newException("XSCB3.S");
    }

    public String getQualifiedIndexName() {
        return this.openConglom.getConglomerate().getGemFireContainer().getQualifiedTableName();
    }

    public final int getNumRowsVisited() {
        return this.statNumRowsVisited != null ? this.statNumRowsVisited[0] : 0;
    }

    public final int getNumRowsQualified() {
        return this.statNumRowsQualified;
    }
}

