/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools.utils;

import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.tools.planexporter.AccessDistributedSystem;
import com.pivotal.gemfirexd.tools.planexporter.CreateResultSet;
import com.pivotal.gemfirexd.tools.planexporter.CreateXML;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.w3c.dom.Element;

public final class ExecutionPlanUtils {
    private final AccessDistributedSystem ds;
    private final List<Element> planXML;
    private final List<String> planRS;

    public ExecutionPlanUtils(String connectionURL, Properties connectionProperties, String targetSchema, String statement, ArrayList<ArrayList<Object>> queryParameters) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        this.ds = new AccessDistributedSystem(connectionURL, connectionProperties, targetSchema, statement, queryParameters);
        this.planXML = this.getPlanAsXML();
        this.planRS = null;
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("caching final query plan in XML form as " + this.planXML));
        }
    }

    public ExecutionPlanUtils(Connection conn, String statement, ArrayList<ArrayList<Object>> queryParameters, boolean asXMLOrText) throws SQLException {
        assert (conn instanceof EmbedConnection);
        this.ds = new AccessDistributedSystem((EmbedConnection)conn, statement, queryParameters);
        if (asXMLOrText) {
            this.planXML = this.getPlanAsXML();
            this.planRS = null;
        } else {
            this.planXML = null;
            this.planRS = this.getPlanAsList();
        }
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("caching final query plan " + Integer.toHexString(System.identityHashCode(this.planXML)) + " in XML form as " + this.planXML));
        }
    }

    public List<String> getPlanAsList() throws SQLException {
        if (this.planRS != null) {
            return this.planRS;
        }
        return new CreateResultSet(this.ds, false).getPlan();
    }

    public List<Element> getPlanAsXML() throws SQLException {
        if (this.planXML != null) {
            return this.planXML;
        }
        ArrayList<Element> xmlPlan = new ArrayList<Element>();
        List<char[]> planAsChars = new CreateXML(this.ds, false, XPLAINUtil.XMLForms.none, null).getPlan();
        for (char[] p : planAsChars) {
            xmlPlan.add(CreateXML.transformToXML(p));
        }
        return xmlPlan;
    }

    public void getPlanAsHTML(String stylesheet, OutputStream output) {
    }

    public char[] getPlanAsText(String stylesheet) {
        if (stylesheet == null || stylesheet.length() <= 0) {
            stylesheet = "vanilla_text.xsl";
        }
        return Misc.serializeXMLAsCharArr(this.planXML, stylesheet);
    }

    public char[] getPlanAsText(Element e, String stylesheet) {
        if (stylesheet == null || stylesheet.length() <= 0) {
            stylesheet = "vanilla_text.xsl";
        }
        ArrayList<Element> l = new ArrayList<Element>(1);
        l.add(e);
        return Misc.serializeXMLAsCharArr(l, stylesheet);
    }

    public void writePlanToXMLFile(String filename) {
    }

    public void writePlanToHTMLFile(String filename, String stylesheet) {
    }
}

