/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.xact;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.locks.LockFactory;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerLock;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.impl.store.raw.xact.ContainerLocking3;
import com.pivotal.gemfirexd.internal.impl.store.raw.xact.EscalateContainerKey;

public class RowLocking3Escalate
extends ContainerLocking3 {
    protected RowLocking3Escalate(LockFactory lf) {
        super(lf);
    }

    @Override
    public boolean lockContainer(Transaction t, ContainerHandle container, boolean waitForLock, boolean forUpdate) throws StandardException {
        boolean gotLock;
        forUpdate = false;
        if (this.lf.isLockHeld(t.getCompatibilitySpace(), t, container.getId(), ContainerLock.CIX)) {
            forUpdate = true;
        }
        if (!(gotLock = super.lockContainer(t, container, waitForLock, forUpdate))) {
            return false;
        }
        this.lf.unlockGroup(t.getCompatibilitySpace(), t, new EscalateContainerKey(container.getId()));
        SanityManager.ASSERT((boolean)this.lf.isLockHeld(t.getCompatibilitySpace(), t, container.getId(), forUpdate ? ContainerLock.CX : ContainerLock.CS), (String)("Covering table lock (" + (forUpdate ? ContainerLock.CX : ContainerLock.CS) + " is not held after lock escalation."));
        return true;
    }
}

