/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.CompressedNumber;
import com.pivotal.gemfirexd.internal.iapi.services.io.DynamicByteArrayOutputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.RawTransaction;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BasePage;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.PhysicalPageOperation;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;

public final class PurgeOperation
extends PhysicalPageOperation {
    protected int slot;
    protected int num_rows;
    protected int[] recordIds;
    protected transient ByteArray preparedLog;

    public PurgeOperation(RawTransaction t, BasePage page, int slot, int num_rows, int[] recordIds, boolean needDataLogged) throws StandardException {
        super(page);
        this.slot = slot;
        this.num_rows = num_rows;
        this.recordIds = recordIds;
        try {
            this.writeOptionalDataToBuffer(t, needDataLogged);
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDA4.S", ioe);
        }
    }

    public PurgeOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        CompressedNumber.writeInt(out, this.slot);
        CompressedNumber.writeInt(out, this.num_rows);
        for (int i = 0; i < this.num_rows; ++i) {
            CompressedNumber.writeInt(out, this.recordIds[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.slot = CompressedNumber.readInt(in);
        this.num_rows = CompressedNumber.readInt(in);
        this.recordIds = new int[this.num_rows];
        for (int i = 0; i < this.num_rows; ++i) {
            this.recordIds[i] = CompressedNumber.readInt(in);
        }
    }

    @Override
    public int getTypeFormatId() {
        return 106;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        for (int i = this.num_rows - 1; i >= 0; --i) {
            this.page.purgeRecord(instant, this.slot + i, this.recordIds[i]);
        }
    }

    @Override
    public void undoMe(Transaction xact, BasePage undoPage, LogInstant CLRInstant, LimitObjectInput in) throws StandardException, IOException {
        for (int i = 0; i < this.num_rows; ++i) {
            undoPage.storeRecord(CLRInstant, this.slot + i, true, in);
        }
        undoPage.setAuxObject(null);
    }

    @Override
    public void restoreMe(Transaction xact, BasePage undoPage, LogInstant CLRInstant, LimitObjectInput in) throws StandardException, IOException {
        this.undoMe(xact, undoPage, CLRInstant, in);
    }

    @Override
    public ByteArray getPreparedLog() {
        return this.preparedLog;
    }

    private void writeOptionalDataToBuffer(RawTransaction t, boolean needDataLogged) throws StandardException, IOException {
        SanityManager.ASSERT((this.page != null ? 1 : 0) != 0);
        DynamicByteArrayOutputStream logBuffer = t.getLogBuffer();
        int optionalDataStart = logBuffer.getPosition();
        SanityManager.ASSERT((optionalDataStart == 0 ? 1 : 0) != 0, (String)"Buffer for writing the optional data should start at position 0");
        for (int i = 0; i < this.num_rows; ++i) {
            if (needDataLogged) {
                this.page.logRecord(i + this.slot, 0, this.recordIds[i], null, (OutputStream)((Object)logBuffer), null);
                continue;
            }
            this.page.logRecord(i + this.slot, 2, this.recordIds[i], null, (OutputStream)((Object)logBuffer), null);
        }
        int optionalDataLength = logBuffer.getPosition() - optionalDataStart;
        if (optionalDataLength != logBuffer.getUsed()) {
            SanityManager.THROWASSERT((String)("wrong optional data length, optionalDataLength = " + optionalDataLength + ", logBuffer.getUsed() = " + logBuffer.getUsed()));
        }
        logBuffer.setPosition(optionalDataStart);
        this.preparedLog = new ByteArray(logBuffer.getByteArray(), optionalDataStart, optionalDataLength);
    }

    @Override
    public String toString() {
        String str = super.toString() + "Purge : " + this.num_rows + " slots starting at " + this.slot;
        for (int i = 0; i < this.num_rows; ++i) {
            str = str + " (recordId=" + this.recordIds[i] + ")";
        }
        return str;
    }
}

