/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.heap;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.diag.DiagnosticUtil;
import com.pivotal.gemfirexd.internal.iapi.services.diag.DiagnosticableGeneric;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Page;
import com.pivotal.gemfirexd.internal.impl.store.access.heap.HeapController;
import com.pivotal.gemfirexd.internal.impl.store.access.heap.TableStats;
import java.util.Properties;

public class D_HeapController
extends DiagnosticableGeneric {
    private static void diag_page(Page page, Properties prop, TableStats stat) throws StandardException {
        ++stat.num_pages;
        stat.num_entries += page.recordCount();
        stat.num_deleted += page.recordCount() - page.nonDeletedRecordCount();
        stat.max_pageno = Math.max(stat.max_pageno, page.getPageNumber());
        DiagnosticUtil.findDiagnostic(page).diag_detail(prop);
        int free_bytes = Integer.parseInt(prop.getProperty("bytesFree"));
        stat.num_free_bytes += (long)free_bytes;
        int res_bytes = Integer.parseInt(prop.getProperty("bytesReserved"));
        stat.num_res_bytes += (long)res_bytes;
        int overflow = Integer.parseInt(prop.getProperty("numOverFlowed"));
        stat.num_overflow_rows += (long)overflow;
        int rowsize = Integer.parseInt(prop.getProperty("rowSize"));
        stat.num_rowsize_bytes += (long)rowsize;
        int min_rowsize = Integer.parseInt(prop.getProperty("minRowSize"));
        if (min_rowsize != 0) {
            stat.min_rowsize_bytes = Math.min(stat.min_rowsize_bytes, (long)min_rowsize);
        }
        int max_rowsize = Integer.parseInt(prop.getProperty("maxRowSize"));
        stat.max_rowsize_bytes = Math.max(stat.max_rowsize_bytes, (long)max_rowsize);
    }

    private static String out_summary(String hdr, long value, double ratio, String ratio_desc) {
        String double_str = "" + ratio;
        String short_str = ratio > 0.001 ? double_str.substring(0, Math.min(double_str.lastIndexOf(".") + 3, double_str.length())) : "NA";
        return "\t" + hdr + value + ".\t(" + short_str + " " + ratio_desc + ").\n";
    }

    private static String diag_tabulate(Properties prop, TableStats stat) {
        String ret_string = new String();
        ret_string = ret_string + "Heap conglom has:\n\t" + prop.getProperty("pageSize") + " bytes per page\n\t" + stat.num_pages + " total used pages (" + Integer.parseInt(prop.getProperty("pageSize")) * stat.num_pages + " bytes)\n\tmaximum page number   = " + stat.max_pageno + ".\n\treserved space %      = " + prop.getProperty("reserveSpace") + "%.\n\tminimum record size   = " + prop.getProperty("minRecSize") + ".\n\tminimum record length = " + stat.min_rowsize_bytes + ".\n\tmaximum record length = " + stat.max_rowsize_bytes + ".\n\t# of bytes in rows    = " + stat.num_rowsize_bytes + ".\t(" + (stat.num_entries == 0 ? 0L : stat.num_rowsize_bytes / (long)stat.num_entries) + " bytes/row).\n" + D_HeapController.out_summary("# of reserved bytes   = ", stat.num_res_bytes, stat.num_res_bytes / (long)stat.num_pages, "reserved bytes/page") + D_HeapController.out_summary("# of free bytes       = ", stat.num_free_bytes, stat.num_free_bytes / (long)stat.num_pages, "free bytes/page") + D_HeapController.out_summary("# of total records    = ", stat.num_entries, (double)stat.num_entries / (double)stat.num_pages, "records/page") + D_HeapController.out_summary("# of overflow records = ", stat.num_overflow_rows, (double)stat.num_overflow_rows / (double)stat.num_pages, "overflow records/page") + D_HeapController.out_summary("# of deleted records  = ", stat.num_deleted, (double)stat.num_deleted / (double)stat.num_pages, "deleted records/page");
        return ret_string;
    }

    @Override
    public void init(Object obj) {
        SanityManager.ASSERT((boolean)(obj instanceof HeapController));
        super.init(obj);
    }

    @Override
    public String diag() throws StandardException {
        ContainerHandle container = ((HeapController)this.diag_object).getOpenConglom().getContainer();
        TableStats stat = new TableStats();
        Properties prop = new Properties();
        prop.put("pageSize", "");
        prop.put("bytesFree", "");
        prop.put("bytesReserved", "");
        prop.put("reserveSpace", "");
        prop.put("minRecSize", "");
        prop.put("numOverFlowed", "");
        prop.put("rowSize", "");
        prop.put("minRowSize", "");
        prop.put("maxRowSize", "");
        Page page = container.getFirstPage();
        while (page != null) {
            D_HeapController.diag_page(page, prop, stat);
            long pageid = page.getPageNumber();
            page.unlatch();
            page = container.getNextPage(pageid);
        }
        return D_HeapController.diag_tabulate(prop, stat);
    }
}

