/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GenericAggregateResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GenericAggregator;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;

class ScalarAggregateResultSet
extends GenericAggregateResultSet
implements CursorResultSet {
    public int rowsInput;
    public boolean singleInputRow;
    protected ExecIndexRow sortTemplateRow;
    protected boolean isInSortedOrder;
    protected ExecIndexRow sourceExecIndexRow;
    private boolean nextSatisfied;
    protected int countOfRows;

    ScalarAggregateResultSet(NoPutResultSet s, boolean isInSortedOrder, int aggregateItem, Activation a, GeneratedMethod ra, int resultSetNumber, boolean singleInputRow, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(s, aggregateItem, a, ra, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost, true);
        this.isInSortedOrder = isInSortedOrder;
        SanityManager.ASSERT((this.source != null ? 1 : 0) != 0, (String)"SARS(), source expected to be non-null");
        this.sortTemplateRow = this.getExecutionFactory().getIndexableRow((ExecRow)this.rowAllocator.invoke(this.activation));
        this.singleInputRow = singleInputRow;
        SanityManager.DEBUG((String)"AggregateTrace", (String)("execution time: " + a.getSavedObject(aggregateItem)));
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((this.source != null ? 1 : 0) != 0, (String)"SARS.openCore(), source expected to be non-null");
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"ScalarAggregateResultSet already open");
        this.isOpen = true;
        this.sourceExecIndexRow = this.getExecutionFactory().getIndexableRow(this.sortTemplateRow);
        this.source.openCore();
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.nextSatisfied) {
            this.clearCurrentRow();
            return null;
        }
        ExecIndexRow execIndexRow = null;
        ExecIndexRow aggResult = null;
        boolean minAgg = this.singleInputRow && this.aggregates[0].getAggregatorInfo().aggregateName.equals("MIN");
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            while ((execIndexRow = this.getRowFromResultSet(false)) != null) {
                try {
                    if (aggResult == null) {
                        aggResult = this.singleInputRow && minAgg ? execIndexRow : (ExecIndexRow)execIndexRow.getClone();
                        this.initializeScalarAggregation(aggResult);
                    } else {
                        this.accumulateScalarAggregation(execIndexRow, aggResult, false);
                    }
                }
                finally {
                    this.source.releasePreviousByteSource();
                }
                if (!this.singleInputRow || !minAgg && aggResult.getColumn(this.aggregates[0].aggregatorColumnId).isNull()) continue;
            }
            if (this.countOfRows == 0) {
                aggResult = (ExecIndexRow)this.finishAggregation(aggResult);
                this.setCurrentRow(aggResult);
                ++this.countOfRows;
            }
        }
        this.nextSatisfied = true;
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return aggResult;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            this.clearCurrentRow();
            this.countOfRows = 0;
            this.sourceExecIndexRow = null;
            this.source.close(cleanupOnError);
            super.close(cleanupOnError);
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of SortResultSet repeated");
        }
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
        this.nextSatisfied = false;
        this.isOpen = false;
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (type == 0) {
            return time - this.source.getTimeSpent(1, timeType);
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        return null;
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        SanityManager.ASSERT((boolean)this.isOpen, (String)"SortResultSet expected to be open");
        return this.currentRow;
    }

    public ExecIndexRow getRowFromResultSet(boolean doClone) throws StandardException {
        ExecIndexRow inputRow = null;
        boolean isOffHeapEnabled = GemFireXDUtils.isOffHeapEnabled();
        ExecRow sourceRow = this.source.getNextRowCore();
        if (sourceRow != null) {
            ++this.rowsInput;
            this.sourceExecIndexRow.execRowToExecIndexRow(doClone ? sourceRow.getClone() : sourceRow);
            inputRow = this.sourceExecIndexRow;
        }
        return inputRow;
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((boolean)this.isOpen, (String)"NormalizeResultSet already open");
        this.source.reopenCore();
        ++this.numOpens;
        this.countOfRows = 0;
        this.nextSatisfied = false;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    protected void accumulateScalarAggregation(ExecRow inputRow, ExecRow accumulateRow, boolean hasDistinctAggregates) throws StandardException {
        int size = this.aggregates.length;
        SanityManager.ASSERT((inputRow != null && accumulateRow != null ? 1 : 0) != 0, (String)"Null row passed to accumulateScalarAggregation");
        for (int i = 0; i < size; ++i) {
            GenericAggregator currAggregate = this.aggregates[i];
            if (hasDistinctAggregates && !currAggregate.getAggregatorInfo().isDistinct()) {
                currAggregate.merge(inputRow, accumulateRow);
                continue;
            }
            currAggregate.accumulate(inputRow, accumulateRow);
        }
    }

    private void initializeScalarAggregation(ExecRow row) throws StandardException {
        int size = this.aggregates.length;
        SanityManager.ASSERT((row != null ? 1 : 0) != 0, (String)"Null row passed to initializeScalarAggregation");
        for (int i = 0; i < size; ++i) {
            GenericAggregator currAggregate = this.aggregates[i];
            currAggregate.initialize(row);
            currAggregate.accumulate(row, row);
        }
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        if (this.source != null) {
            this.source.updateRowLocationPostRead();
        }
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.setNumberOfChildren(1);
        visitor.visit(this);
        this.source.accept(visitor);
    }

    @Override
    public void resetStatistics() {
        this.rowsInput = 0;
        super.resetStatistics();
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "AGGREGATION");
        if (this.source != null) {
            this.source.buildQueryPlan(builder, context.pushContext());
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }
}

