/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecAggregator;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AggregatorInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.SystemAggregator;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

abstract class OrderableAggregator
extends SystemAggregator {
    protected DataValueDescriptor value;

    OrderableAggregator() {
    }

    @Override
    public void setup(String aggregateName, AggregatorInfo aggInfo) {
        if (aggInfo != null) {
            super.setup(aggInfo);
        }
    }

    @Override
    public void setup(String aggregateName, DataValueDescriptor initValue) throws StandardException {
        this.setup(aggregateName, (AggregatorInfo)null);
        this.value = initValue;
    }

    @Override
    public void clear() {
        if (this.value != null) {
            this.value.restoreToNull();
        }
        super.clear();
    }

    public String toString() {
        DataValueDescriptor value = this.value;
        if (value != null) {
            return value.toString();
        }
        return "NULL value (orderable aggregator)";
    }

    @Override
    public void merge(ExecAggregator addend) throws StandardException {
        SanityManager.ASSERT((boolean)(addend instanceof OrderableAggregator), (String)"addend is supposed to be the same type of aggregator for the merge operator");
        DataValueDescriptor bv = ((OrderableAggregator)addend).value;
        if (bv != null) {
            this.basicAccumulate(bv);
        }
    }

    @Override
    public DataValueDescriptor getResult() throws StandardException {
        return this.value;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.value != null) {
            out.writeBoolean(true);
            this.value.toData(out);
        } else {
            out.writeBoolean(false);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        boolean isValue = in.readBoolean();
        if (isValue) {
            this.value = DataType.readDVD(in);
        }
    }

    @Override
    public int compareTo(Object o) {
        try {
            return this.value.compare(((OrderableAggregator)o).value);
        }
        catch (StandardException e) {
            throw GemFireXDRuntimeException.newRuntimeException("OrderableAggregator: compare failed ", e);
        }
    }
}

