/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.auth.callback.UserAuthenticator;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.PermissionsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.jdbc.authentication.LDAPAuthenticationSchemeImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.naming.NameNotFoundException;

public final class GranteeIterator
implements Iterator<String> {
    private final Iterator<?> granteesIter;
    private final PermissionsDescriptor perms;
    private final boolean grant;
    private final int catalogNum;
    private final int indexNum;
    private final int groupColumnNum;
    private final DataDictionary dd;
    private final TransactionController tc;
    private Iterator<String> currentGroupIter;
    private LDAPAuthenticationSchemeImpl ldapAuth = null;
    private String currentLdapGroup = null;

    public GranteeIterator(List<?> grantees, PermissionsDescriptor perms, boolean grant, int catalogNum, int indexNum, int groupColumnNum, DataDictionary dd, TransactionController tc) {
        this.granteesIter = grantees.iterator();
        this.perms = perms;
        this.grant = grant;
        this.catalogNum = catalogNum;
        this.indexNum = indexNum;
        this.groupColumnNum = groupColumnNum;
        this.dd = dd;
        this.tc = tc;
    }

    @Override
    public boolean hasNext() {
        return this.currentGroupIter != null && this.currentGroupIter.hasNext() || this.granteesIter.hasNext();
    }

    @Override
    public String next() {
        try {
            return this.moveNext();
        }
        catch (StandardException se) {
            throw new GemFireXDRuntimeException(se);
        }
    }

    public String moveNext() throws StandardException {
        String grantee = null;
        if (this.currentGroupIter != null) {
            if (this.currentGroupIter.hasNext()) {
                grantee = this.currentGroupIter.next();
            } else {
                this.currentGroupIter = null;
                this.currentLdapGroup = null;
            }
        }
        if (grantee == null) {
            grantee = (String)this.granteesIter.next();
            int colonIndex = grantee.indexOf(58);
            if (colonIndex < 0) {
                this.currentLdapGroup = null;
            } else if (grantee.startsWith("LDAPGROUP:")) {
                this.currentLdapGroup = grantee.substring("LDAPGROUP:".length());
                if (this.grant) {
                    try {
                        if (this.ldapAuth == null) {
                            UserAuthenticator auth = Misc.getMemStoreBooting().getDatabase().getAuthenticationService().getAuthenticationScheme();
                            if (auth instanceof LDAPAuthenticationSchemeImpl) {
                                this.ldapAuth = (LDAPAuthenticationSchemeImpl)auth;
                            } else {
                                throw new NameNotFoundException("Require LDAP authentication scheme for LDAP group support but is " + auth);
                            }
                        }
                        this.currentGroupIter = this.ldapAuth.getLDAPGroupMembers(this.currentLdapGroup).iterator();
                    }
                    catch (Exception ne) {
                        throw StandardException.newException("4251B", (Throwable)ne, (Object)this.currentLdapGroup);
                    }
                } else if (this.perms != null) {
                    this.perms.setLdapGroup(this.currentLdapGroup);
                    List<PermissionsDescriptor> descs = this.dd.getLDAPDescriptorsHavingPermissions(this.perms, this.catalogNum, this.indexNum, this.groupColumnNum, this.tc);
                    ArrayList<String> members = new ArrayList<String>(descs.size());
                    String groupGrantee = "LDAPGROUP:" + this.currentLdapGroup;
                    for (PermissionsDescriptor desc : descs) {
                        String rgrantee = desc.getGrantee();
                        if (rgrantee.equals(groupGrantee)) continue;
                        members.add(rgrantee);
                    }
                    this.currentGroupIter = members.iterator();
                }
            } else {
                this.currentLdapGroup = grantee.substring(0, colonIndex);
                grantee = grantee.substring(colonIndex + 1);
            }
        }
        if (this.perms != null) {
            this.perms.setLdapGroup(this.currentLdapGroup);
        }
        return grantee;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String getCurrentLdapGroup() {
        return this.currentLdapGroup;
    }
}

