/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SingleChildResultSetNode;

public class NormalizeResultSetNode
extends SingleChildResultSetNode {
    private boolean forUpdate;

    @Override
    public void init(Object childResult, Object rcl, Object tableProperties, Object forUpdate) {
        super.init(childResult, tableProperties);
        this.resultColumns = (ResultColumnList)rcl;
        this.forUpdate = (Boolean)forUpdate;
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT((this.resultColumns != null ? 1 : 0) != 0, (String)"Tree structure bad");
        this.assignResultSetNumber();
        this.costEstimate = this.childResult.getFinalCostEstimate();
        int erdNumber = acb.addItem(this.makeResultDescription());
        acb.pushGetResultSetFactoryExpression(mb);
        this.childResult.generate(acb, mb);
        mb.push(this.resultSetNumber);
        mb.push(erdNumber);
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.push(this.forUpdate);
        mb.callMethod((short)185, null, "getNormalizeResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 6);
    }

    @Override
    public void setRefActionInfo(long fkIndexConglomId, int[] fkColArray, String parentResultSetId, boolean dependentScan) {
        this.childResult.setRefActionInfo(fkIndexConglomId, fkColArray, parentResultSetId, dependentScan);
    }

    @Override
    public QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        return this.childResult.computeQueryInfo(qic);
    }

    @Override
    public QueryInfo computeSubSelectQueryInfo(QueryInfoContext qic) throws StandardException {
        return this.childResult.computeSubSelectQueryInfo(qic);
    }
}

