/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BinaryRelationalOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CollectNodesVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.IndexToBaseRowNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.JoinNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ParameterNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Predicate;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ProjectRestrictNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NcjSQLGeneratorVisitor
extends VisitorAdaptor {
    private boolean resultColumnsDone = false;
    private String resultColumns = null;
    private int fbtSeenCount = 0;
    private String tableName = null;
    private ArrayList<String> predSqlList = null;
    private ArrayList<String> remoteInListCols = null;
    private boolean generateInList;

    public boolean isGenerateInList() {
        return this.generateInList;
    }

    public NcjSQLGeneratorVisitor(boolean genInList) {
        this.generateInList = genInList;
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("NcjSQLGeneratorVisitor constructor: Created with generateInList = " + this.generateInList));
        }
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (node instanceof ProjectRestrictNode) {
            ProjectRestrictNode prn = (ProjectRestrictNode)node;
            if (!this.resultColumnsDone) {
                this.resultColumnsDone = true;
                StringBuilder projectedColumns = new StringBuilder();
                boolean seenOneResultColumn = false;
                for (int i = 0; i < prn.resultColumns.size(); ++i) {
                    ResultColumn col = (ResultColumn)prn.resultColumns.elementAt(i);
                    if (col.getActualName() == null || col.getActualName().startsWith("##")) {
                        SanityManager.THROWASSERT((String)"NCJ: Not yet Supported");
                    }
                    if (seenOneResultColumn) {
                        projectedColumns.append(" ,");
                    } else {
                        seenOneResultColumn = true;
                    }
                    projectedColumns.append(col.getActualName());
                }
                this.resultColumns = projectedColumns.toString();
            }
            if (prn.getRemoteInListCols() != null) {
                SanityManager.ASSERT((this.remoteInListCols == null ? 1 : 0) != 0, (String)"Already got In-List");
                this.remoteInListCols = prn.getRemoteInListCols();
            }
        } else if (node instanceof FromBaseTable) {
            SanityManager.ASSERT((this.fbtSeenCount == 0 ? 1 : 0) != 0, (String)"Till we support remote colocated tables");
            ++this.fbtSeenCount;
            TableName tName = ((FromBaseTable)node).getActualTableName();
            this.tableName = tName.getFullTableName();
        } else if (node instanceof IndexToBaseRowNode) {
            this.visit(((IndexToBaseRowNode)node).source);
        } else if (node instanceof Predicate) {
            if (this.predSqlList == null) {
                this.predSqlList = new ArrayList();
            }
            Predicate pNode = (Predicate)node;
            String predSql = pNode.andNode.ncjGenerateSql();
            if (predSql != null) {
                this.predSqlList.add(predSql);
            }
            if (this.generateInList) {
                CollectNodesVisitor collectNodesVisitor = new CollectNodesVisitor(BinaryRelationalOperatorNode.class);
                pNode.accept(collectNodesVisitor);
                boolean ifAllEquals = true;
                boolean ifAnyOneEqual = false;
                for (BinaryRelationalOperatorNode brOpNode : collectNodesVisitor.getList()) {
                    if (brOpNode.getOperator() == 1) {
                        ifAnyOneEqual = true;
                        continue;
                    }
                    ifAllEquals = false;
                }
                if (ifAnyOneEqual && ifAllEquals) {
                    this.generateInList = false;
                    if (GemFireXDUtils.TraceNCJ) {
                        SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("NcjSQLGeneratorVisitor constructor: Marking generateInList from True to False. ifAnyOneEqual=" + ifAnyOneEqual + " ,ifAllEquals=" + ifAllEquals));
                    }
                }
            }
        }
        return node;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }

    @Override
    public boolean skipChildren(Visitable node) throws StandardException {
        return node instanceof ResultColumnList || node instanceof Predicate || node instanceof JoinNode;
    }

    private String getResultColumns() {
        SanityManager.ASSERT((boolean)this.resultColumnsDone, (String)"No Project Restriction Node found yet");
        return this.resultColumns;
    }

    private String getTableName() {
        SanityManager.ASSERT((this.fbtSeenCount == 1 ? 1 : 0) != 0, (String)("No of tables seen yet " + this.fbtSeenCount));
        return this.tableName;
    }

    private String getGeneratedWhereClause(ArrayList<Integer> params) {
        StringBuilder resultPred = null;
        if (this.predSqlList != null && this.predSqlList.size() > 0) {
            resultPred = new StringBuilder();
            for (String predSql : this.predSqlList) {
                String pattern = "\\b" + ParameterNode.GFXDPARAM + "\\d" + ParameterNode.GFXDPARAM + "\\b";
                Pattern r = Pattern.compile(pattern);
                Matcher m = r.matcher(predSql);
                while (m.find()) {
                    SanityManager.ASSERT((m.group().length() > 2 * ParameterNode.GFXDPARAM.length() ? 1 : 0) != 0);
                    String param = m.group().substring(ParameterNode.GFXDPARAM.length(), m.group().length() - ParameterNode.GFXDPARAM.length());
                    Integer prm = Integer.parseInt(param);
                    params.add(prm);
                }
                if (resultPred.length() > 0) {
                    resultPred.append(" and ");
                }
                resultPred.append(m.replaceAll("?"));
            }
        }
        return resultPred != null ? resultPred.toString() : null;
    }

    private String getGeneratedInListClause() {
        StringBuilder resultPred = new StringBuilder();
        SanityManager.ASSERT((this.remoteInListCols != null ? 1 : 0) != 0, (String)"In-list columns missing ");
        boolean foundRemoteColumn = false;
        for (String colName : this.remoteInListCols) {
            if (colName == null) continue;
            if (foundRemoteColumn) {
                resultPred.append(" and ");
            }
            resultPred.append(colName);
            resultPred.append(" IN ARRAY(?) ");
            foundRemoteColumn = true;
        }
        return resultPred != null ? resultPred.toString() : null;
    }

    public String getGeneratedSql(ArrayList<Integer> params) {
        String inlistClause;
        StringBuilder resultPred = new StringBuilder("Select ");
        resultPred.append(this.getResultColumns());
        resultPred.append(" from ");
        resultPred.append(this.getTableName());
        resultPred.append(" ");
        boolean whereTagAdded = false;
        String whereClause = this.getGeneratedWhereClause(params);
        if (whereClause != null) {
            resultPred.append(" where ");
            resultPred.append(whereClause);
            whereTagAdded = true;
        }
        if (this.generateInList && (inlistClause = this.getGeneratedInListClause()) != null) {
            if (!whereTagAdded) {
                resultPred.append(" where ");
            } else {
                resultPred.append(" and ");
            }
            resultPred.append(inlistClause);
        }
        return resultPred.toString();
    }
}

