/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseColumnNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderedColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StaticMethodCallNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VirtualColumnNode;
import java.util.Vector;

public class GroupByColumn
extends OrderedColumn {
    private ValueNode columnExpression;

    @Override
    public void init(Object colRef) {
        this.columnExpression = (ValueNode)colRef;
    }

    @Override
    public String toString() {
        return "Column Expression: " + this.columnExpression + super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.columnExpression != null) {
            this.printLabel(depth, "colRef: ");
            this.columnExpression.treePrint(depth + 1);
        }
    }

    public String getColumnName() {
        return this.columnExpression.getColumnName();
    }

    public void bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.columnExpression = this.columnExpression.bindExpression(fromList, subqueryList, aggregateVector);
        if (this.columnExpression.isParameterNode()) {
            throw StandardException.newException("42Y36", this.columnExpression);
        }
        TypeId ctid = this.columnExpression.getTypeId();
        if (!ctid.orderable(this.getClassFactory())) {
            throw StandardException.newException("X0X67.S", ctid.getSQLTypeName());
        }
    }

    public ValueNode getColumnExpression() {
        return this.columnExpression;
    }

    public void setColumnExpression(ValueNode cexpr) {
        this.columnExpression = cexpr;
    }

    public boolean hasDSID() throws StandardException {
        final boolean[] hasDSID = new boolean[]{false};
        VisitorAdaptor v = new VisitorAdaptor(){
            private int numColumns = 0;

            @Override
            public Visitable visit(Visitable node) throws StandardException {
                if (node instanceof StaticMethodCallNode) {
                    hasDSID[0] = ((StaticMethodCallNode)node).hasDSID() && this.numColumns == 0;
                } else if (node instanceof ColumnReference || node instanceof VirtualColumnNode || node instanceof BaseColumnNode) {
                    ++this.numColumns;
                }
                return node;
            }

            @Override
            public boolean stopTraversal() {
                return hasDSID[0] || this.numColumns != 0;
            }

            @Override
            public boolean skipChildren(Visitable node) throws StandardException {
                return hasDSID[0] || this.numColumns != 0;
            }
        };
        this.columnExpression.accept(v);
        return hasDSID[0];
    }

    @Override
    ResultColumn getResultColumn() {
        return this.columnExpression.getSourceResultColumn();
    }
}

