/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedClass;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SPSDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;

public class ExecSPSNode
extends StatementNode {
    private TableName name;
    private SPSDescriptor spsd;
    private ExecPreparedStatement ps;

    @Override
    public void init(Object newObjectName) {
        this.name = (TableName)newObjectName;
    }

    @Override
    public void bindStatement() throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        String schemaName = this.name.getSchemaName();
        SchemaDescriptor sd = this.getSchemaDescriptor(this.name.getSchemaName());
        if (schemaName == null) {
            this.name.setSchemaName(sd.getSchemaName());
        }
        if (sd.getUUID() != null) {
            this.spsd = dd.getSPSDescriptor(this.name.getTableName(), sd);
        }
        if (this.spsd == null) {
            throw StandardException.newException("42X94", (Object)"STATEMENT", (Object)this.name);
        }
        if (this.spsd.getType() == 'T') {
            throw StandardException.newException("42Y41", this.name);
        }
        this.getCompilerContext().createDependency(this.spsd);
    }

    @Override
    public boolean isAtomic() {
        SanityManager.ASSERT((this.ps != null ? 1 : 0) != 0, (String)"statement expected to be bound before calling isAtomic()");
        return this.ps.isAtomic();
    }

    @Override
    public GeneratedClass generate(ByteArray ignored) throws StandardException {
        if (!this.spsd.isValid()) {
            this.getLanguageConnectionContext().commitNestedTransaction();
            this.getLanguageConnectionContext().beginNestedTransaction(true);
        }
        this.ps = this.spsd.getPreparedStatement();
        this.getCompilerContext().setSavedObjects(this.ps.getSavedObjects());
        this.getCompilerContext().setCursorInfo(this.ps.getCursorInfo());
        GeneratedClass gc = this.ps.getActivationClass();
        return gc;
    }

    @Override
    public ResultDescription makeResultDescription() {
        return this.ps.getResultDescription();
    }

    @Override
    public Object getCursorInfo() {
        return this.ps.getCursorInfo();
    }

    @Override
    public DataTypeDescriptor[] getParameterTypes() throws StandardException {
        return this.spsd.getParams();
    }

    @Override
    public ConstantAction makeConstantAction() {
        return this.ps.getConstantAction();
    }

    @Override
    public boolean needsSavepoint() {
        SanityManager.ASSERT((this.ps != null ? 1 : 0) != 0, (String)"statement expected to be bound before calling needsSavepoint()");
        return this.ps.needsSavepoint();
    }

    @Override
    public String executeStatementName() {
        return this.name.getTableName();
    }

    @Override
    public String executeSchemaName() {
        return this.name.getSchemaName();
    }

    @Override
    public String getSPSName() {
        return this.spsd.getQualifiedName();
    }

    @Override
    int activationKind() {
        SanityManager.THROWASSERT((String)"activationKind not expected to be called for a stored prepared statement");
        return 2;
    }

    @Override
    public String statementToString() {
        return "EXECUTE STATEMENT";
    }

    private final SPSDescriptor getSPSDescriptor() {
        return this.spsd;
    }
}

