/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CollectNodesVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DDLStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TriggerReferencingStruct;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CreateTriggerConstantAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class CreateTriggerNode
extends DDLStatementNode {
    private TableName triggerName;
    private TableName tableName;
    private int triggerEventMask;
    private ResultColumnList triggerCols;
    private boolean isBefore;
    private boolean isRow;
    private boolean isEnabled;
    private Vector refClause;
    private ValueNode whenClause;
    private String whenText;
    private int whenOffset;
    private StatementNode actionNode;
    private String actionText;
    private String gfxdActionText;
    private List<GfxdIMParamInfo> gfxdParamInfos;
    private String originalActionText;
    private int actionOffset;
    private SchemaDescriptor triggerSchemaDescriptor;
    private SchemaDescriptor compSchemaDescriptor;
    private int[] referencedColInts;
    private TableDescriptor triggerTableDescriptor;
    private UUID actionCompSchemaId;
    private String oldTableName;
    private String newTableName;
    private boolean oldTableInReferencingClause;
    private boolean newTableInReferencingClause;

    @Override
    public void init(Object triggerName, Object tableName, Object triggerEventMask, Object triggerCols, Object isBefore, Object isRow, Object isEnabled, Object refClause, Object whenClause, Object whenText, Object whenOffset, Object actionNode, Object actionText, Object actionOffset) throws StandardException {
        this.initAndCheck(triggerName);
        this.triggerName = (TableName)triggerName;
        this.tableName = (TableName)tableName;
        this.triggerEventMask = (Integer)triggerEventMask;
        this.triggerCols = (ResultColumnList)triggerCols;
        this.isBefore = (Boolean)isBefore;
        this.isRow = (Boolean)isRow;
        this.isEnabled = (Boolean)isEnabled;
        this.refClause = (Vector)refClause;
        this.whenClause = (ValueNode)whenClause;
        this.whenText = whenText == null ? null : ((String)whenText).trim();
        this.whenOffset = (Integer)whenOffset;
        this.actionNode = (StatementNode)actionNode;
        this.originalActionText = (String)actionText;
        this.gfxdActionText = this.actionText = actionText == null ? null : ((String)actionText).trim();
        this.actionOffset = (Integer)actionOffset;
        this.implicitCreateSchema = true;
    }

    @Override
    public String statementToString() {
        return "CREATE TRIGGER";
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.triggerCols != null) {
            this.printLabel(depth, "triggerColumns: ");
            this.triggerCols.treePrint(depth + 1);
        }
        if (this.whenClause != null) {
            this.printLabel(depth, "whenClause: ");
            this.whenClause.treePrint(depth + 1);
        }
        if (this.actionNode != null) {
            this.printLabel(depth, "actionNode: ");
            this.actionNode.treePrint(depth + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindStatement() throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        DataDictionary dd = this.getDataDictionary();
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        this.compSchemaDescriptor = lcc.getDefaultSchema();
        this.triggerSchemaDescriptor = this.getSchemaDescriptor();
        this.triggerTableDescriptor = this.getTableDescriptor(this.tableName);
        if (this.isSessionSchema(this.triggerTableDescriptor.getSchemaDescriptor())) {
            throw StandardException.newException("XCL51.S");
        }
        if (this.isPrivilegeCollectionRequired()) {
            compilerContext.pushCurrentPrivType(5);
            compilerContext.addRequiredTablePriv(this.triggerTableDescriptor);
            compilerContext.popCurrentPrivType();
        }
        boolean needInternalSQL = this.bindReferencesClause(dd);
        lcc.pushTriggerTable(this.triggerTableDescriptor);
        try {
            if (needInternalSQL) {
                compilerContext.setReliability(0);
            }
            if (this.isBefore) {
                compilerContext.setReliability(2048);
            }
            this.actionNode.bindStatement();
        }
        finally {
            lcc.popTriggerTable(this.triggerTableDescriptor);
        }
        compilerContext.createDependency(this.triggerTableDescriptor);
        if (this.triggerCols != null && this.triggerCols.size() != 0) {
            this.referencedColInts = new int[this.triggerCols.size()];
            Hashtable<String, ResultColumn> columnNames = new Hashtable<String, ResultColumn>();
            int tcSize = this.triggerCols.size();
            for (int i = 0; i < tcSize; ++i) {
                ResultColumn rc = (ResultColumn)this.triggerCols.elementAt(i);
                if (columnNames.put(rc.getName(), rc) != null) {
                    throw StandardException.newException("42Y40", (Object)rc.getName(), (Object)this.triggerName);
                }
                ColumnDescriptor cd = this.triggerTableDescriptor.getColumnDescriptor(rc.getName());
                if (cd == null) {
                    throw StandardException.newException("42X14", (Object)rc.getName(), (Object)this.tableName);
                }
                this.referencedColInts[i] = cd.getPosition();
            }
            Arrays.sort(this.referencedColInts);
        }
        if (this.actionNode.referencesSessionSchema()) {
            throw StandardException.newException("XCL51.S");
        }
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.isSessionSchema(this.triggerTableDescriptor.getSchemaName()) || this.actionNode.referencesSessionSchema();
    }

    private boolean bindReferencesClause(DataDictionary dd) throws StandardException {
        this.validateReferencesClause(dd);
        StringBuilder newText = new StringBuilder();
        StringBuilder newGfxdActionText = new StringBuilder();
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        GemFireContainer container = GemFireXDUtils.getGemFireContainer(this.triggerTableDescriptor.getSchemaName(), this.triggerTableDescriptor.getName(), lcc);
        if (container != null && (container.isRowBuffer() || container.isColumnStore())) {
            throw StandardException.newException("0A000.S", "Triggers on column tables not supported (for table: " + this.triggerTableDescriptor.getQualifiedName() + ")");
        }
        CollectNodesVisitor tableVisitor = new CollectNodesVisitor(FromBaseTable.class);
        this.actionNode.accept(tableVisitor);
        Vector tableRefs = tableVisitor.getList();
        for (Object ref : tableRefs) {
            FromBaseTable fromTable = (FromBaseTable)ref;
            TableName table = fromTable.getActualTableName();
            GemFireContainer target = GemFireXDUtils.getGemFireContainer(table.getSchemaName(), table.getTableName(), lcc);
            if (target == null || !target.isRowBuffer() && !target.isColumnStore()) continue;
            throw StandardException.newException("0A000.S", "Triggers cannot change column tables (for table: " + this.triggerTableDescriptor.getQualifiedName() + ", trigger action: " + this.actionText + ")");
        }
        boolean regenNode = false;
        int start = 0;
        if (this.isRow) {
            CollectNodesVisitor visitor = new CollectNodesVisitor(ColumnReference.class);
            this.actionNode.accept(visitor);
            Vector refs = visitor.getList();
            QueryTreeNode[] cols = this.sortRefs(refs, true);
            for (int i = 0; i < cols.length; ++i) {
                TableName tableName;
                ColumnReference ref = (ColumnReference)cols[i];
                if (ref.getBeginOffset() == -1 || (tableName = ref.getTableNameNode()) == null || (this.oldTableName == null || !this.oldTableName.equals(tableName.getTableName())) && (this.newTableName == null || !this.newTableName.equals(tableName.getTableName()))) continue;
                int tokBeginOffset = tableName.getBeginOffset();
                int tokEndOffset = tableName.getEndOffset();
                if (tokBeginOffset == -1) continue;
                regenNode = true;
                this.checkInvalidTriggerReference(tableName.getTableName());
                String colName = ref.getColumnName();
                int columnLength = ref.getEndOffset() - ref.getBeginOffset() + 1;
                newText.append(this.originalActionText.substring(start, tokBeginOffset - this.actionOffset));
                newText.append(this.genColumnReferenceSQL(dd, colName, tableName.getTableName(), tableName.getTableName().equals(this.oldTableName)));
                newGfxdActionText.append(this.originalActionText.substring(start, tokBeginOffset - this.actionOffset));
                ColumnDescriptor colDesc = null;
                colDesc = this.triggerTableDescriptor.getColumnDescriptor(colName);
                if (colDesc == null) {
                    throw StandardException.newException("42X04", tableName.getTableName() + "." + colName);
                }
                newGfxdActionText.append(this.genColumnReferenceSQL_forGfxd(dd, colName, tableName.getTableName(), tableName.getTableName().equals(this.oldTableName), colDesc));
                this.addToParamInfos(dd, colName, tableName.getTableName().equals(this.oldTableName), colDesc.getType());
                start = tokEndOffset - this.actionOffset + columnLength + 2;
            }
        } else {
            QueryTreeNode[] tabs = this.sortRefs(tableRefs, false);
            for (int i = 0; i < tabs.length; ++i) {
                FromBaseTable fromTable = (FromBaseTable)tabs[i];
                String refTableName = fromTable.getTableName().getTableName();
                String baseTableName = fromTable.getBaseTableName();
                if (baseTableName == null || (this.oldTableName == null || !this.oldTableName.equals(baseTableName)) && (this.newTableName == null || !this.newTableName.equals(baseTableName))) continue;
                int tokBeginOffset = fromTable.getTableNameField().getBeginOffset();
                int tokEndOffset = fromTable.getTableNameField().getEndOffset();
                if (tokBeginOffset == -1) continue;
                this.checkInvalidTriggerReference(baseTableName);
                regenNode = true;
                newText.append(this.originalActionText.substring(start, tokBeginOffset - this.actionOffset));
                newText.append(baseTableName.equals(this.oldTableName) ? "new com.pivotal.gemfirexd.internal.catalog.TriggerOldTransitionRows() " : "new com.pivotal.gemfirexd.internal.catalog.TriggerNewTransitionRows() ");
                if (refTableName.equals(baseTableName)) {
                    newText.append(baseTableName).append(" ");
                }
                start = tokEndOffset - this.actionOffset + 1;
            }
        }
        if (regenNode) {
            if (start < this.originalActionText.length()) {
                newText.append(this.originalActionText.substring(start));
                newGfxdActionText.append(this.originalActionText.substring(start));
            }
            this.actionText = newText.toString();
            this.actionNode = this.parseStatement(this.actionText, true);
            this.gfxdActionText = newGfxdActionText.toString();
        }
        return regenNode;
    }

    private void addToParamInfos(DataDictionary dd, String colName, boolean isOld, DataTypeDescriptor type) throws StandardException {
        if (this.gfxdParamInfos == null) {
            this.gfxdParamInfos = new ArrayList<GfxdIMParamInfo>();
        }
        ColumnDescriptor colDesc = null;
        colDesc = this.triggerTableDescriptor.getColumnDescriptor(colName);
        if (colDesc == null) {
            throw StandardException.newException("42X04", colName);
        }
        int pos = colDesc.getPosition();
        this.gfxdParamInfos.add(new GfxdIMParamInfo(isOld, pos, type));
    }

    private QueryTreeNode[] sortRefs(Vector refs, boolean isRow) {
        int size = refs.size();
        QueryTreeNode[] sorted = new QueryTreeNode[size];
        int i = 0;
        Enumeration e = refs.elements();
        while (e.hasMoreElements()) {
            if (isRow) {
                sorted[i++] = (ColumnReference)e.nextElement();
                continue;
            }
            sorted[i++] = (FromBaseTable)e.nextElement();
        }
        for (i = 0; i < size - 1; ++i) {
            QueryTreeNode temp = null;
            for (int j = 0; j < size - i - 1; ++j) {
                if ((!isRow || sorted[j].getBeginOffset() <= sorted[j + 1].getBeginOffset()) && (isRow || ((FromBaseTable)sorted[j]).getTableNameField().getBeginOffset() <= ((FromBaseTable)sorted[j + 1]).getTableNameField().getBeginOffset())) continue;
                temp = sorted[j];
                sorted[j] = sorted[j + 1];
                sorted[j + 1] = temp;
            }
            if (temp == null) break;
        }
        return sorted;
    }

    private String genColumnReferenceSQL(DataDictionary dd, String colName, String tabName, boolean isOldTable) throws StandardException {
        ColumnDescriptor colDesc = null;
        colDesc = this.triggerTableDescriptor.getColumnDescriptor(colName);
        if (colDesc == null) {
            throw StandardException.newException("42X04", tabName + "." + colName);
        }
        DataTypeDescriptor dts = colDesc.getType();
        TypeId typeId = dts.getTypeId();
        if (!typeId.isXMLTypeId()) {
            StringBuilder methodCall = new StringBuilder();
            methodCall.append("CAST (com.pivotal.gemfirexd.internal.iapi.db.Factory::getTriggerExecutionContext().");
            methodCall.append(isOldTable ? "getOldRow()" : "getNewRow()");
            methodCall.append(".getObject(");
            methodCall.append(colDesc.getPosition());
            methodCall.append(") AS ");
            methodCall.append(typeId.userType() ? typeId.getSQLTypeName() : dts.getSQLstring());
            methodCall.append(") ");
            return methodCall.toString();
        }
        StringBuilder methodCall = new StringBuilder();
        methodCall.append("XMLPARSE(DOCUMENT CAST( ");
        methodCall.append("com.pivotal.gemfirexd.internal.iapi.db.Factory::getTriggerExecutionContext().");
        methodCall.append(isOldTable ? "getOldRow()" : "getNewRow()");
        methodCall.append(".getString(");
        methodCall.append(colDesc.getPosition());
        methodCall.append(") AS CLOB) PRESERVE WHITESPACE ) ");
        return methodCall.toString();
    }

    private String genColumnReferenceSQL_forGfxd(DataDictionary dd, String colName, String tabName, boolean isOldTable, ColumnDescriptor colDesc) throws StandardException {
        DataTypeDescriptor dts = colDesc.getType();
        TypeId typeId = dts.getTypeId();
        if (!typeId.isXMLTypeId()) {
            StringBuilder methodCall = new StringBuilder();
            methodCall.append("CAST( ? AS ");
            methodCall.append(typeId.userType() ? typeId.getSQLTypeName() : dts.getSQLstring());
            methodCall.append(") ");
            return methodCall.toString();
        }
        StringBuilder methodCall = new StringBuilder();
        methodCall.append("XMLPARSE(DOCUMENT CAST( ? AS CLOB) PRESERVE WHITESPACE ) ");
        return methodCall.toString();
    }

    private void checkInvalidTriggerReference(String tableName) throws StandardException {
        if (tableName.equals(this.oldTableName) && (this.triggerEventMask & 4) == 4) {
            throw StandardException.newException("42Y92", (Object)"INSERT", (Object)"new");
        }
        if (tableName.equals(this.newTableName) && (this.triggerEventMask & 2) == 2) {
            throw StandardException.newException("42Y92", (Object)"DELETE", (Object)"old");
        }
    }

    private void validateReferencesClause(DataDictionary dd) throws StandardException {
        if (this.refClause == null || this.refClause.size() == 0) {
            return;
        }
        Enumeration e = this.refClause.elements();
        while (e.hasMoreElements()) {
            TriggerReferencingStruct trn = (TriggerReferencingStruct)e.nextElement();
            if (this.isRow && !trn.isRow) {
                throw StandardException.newException("42Y92", (Object)"ROW", (Object)"row");
            }
            if (!this.isRow && trn.isRow) {
                throw StandardException.newException("42Y92", (Object)"STATEMENT", (Object)"table");
            }
            if (trn.isNew) {
                if (this.newTableInReferencingClause) {
                    throw StandardException.newException("42Y93");
                }
                if ((this.triggerEventMask & 2) == 2) {
                    throw StandardException.newException("42Y92", (Object)"DELETE", (Object)"old");
                }
                this.newTableName = trn.identifier;
                this.newTableInReferencingClause = true;
            } else {
                if (this.oldTableInReferencingClause) {
                    throw StandardException.newException("42Y93");
                }
                if ((this.triggerEventMask & 4) == 4) {
                    throw StandardException.newException("42Y92", (Object)"INSERT", (Object)"new");
                }
                this.oldTableName = trn.identifier;
                this.oldTableInReferencingClause = true;
            }
            if (!this.isBefore || trn.isRow) continue;
            throw StandardException.newException("42Y92", (Object)"BEFORE", (Object)"row");
        }
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        String oldReferencingName = this.oldTableInReferencingClause ? this.oldTableName : null;
        String newReferencingName = this.newTableInReferencingClause ? this.newTableName : null;
        ConstantAction trigCA = this.getGenericConstantActionFactory().getCreateTriggerConstantAction(this.triggerSchemaDescriptor.getSchemaName(), this.getRelativeName(), this.triggerEventMask, this.isBefore, this.isRow, this.isEnabled, this.triggerTableDescriptor, null, this.whenText, null, this.actionText, this.actionCompSchemaId == null ? this.compSchemaDescriptor.getUUID() : this.actionCompSchemaId, null, this.referencedColInts, this.originalActionText, this.oldTableInReferencingClause, this.newTableInReferencingClause, oldReferencingName, newReferencingName);
        if (trigCA instanceof CreateTriggerConstantAction) {
            CreateTriggerConstantAction ctca = (CreateTriggerConstantAction)trigCA;
            ctca.setGfxdActionText(this.gfxdActionText);
            ctca.setParamInfos(this.gfxdParamInfos);
        }
        return trigCA;
    }

    @Override
    public String toString() {
        String refString = "null";
        if (this.refClause != null) {
            StringBuilder buf = new StringBuilder();
            Enumeration e = this.refClause.elements();
            while (e.hasMoreElements()) {
                buf.append("\t");
                TriggerReferencingStruct trn = (TriggerReferencingStruct)e.nextElement();
                buf.append(trn.toString());
                buf.append("\n");
            }
            refString = buf.toString();
        }
        return super.toString() + "tableName: " + this.tableName + "\ntriggerEventMask: " + this.triggerEventMask + "\nisBefore: " + this.isBefore + "\nisRow: " + this.isRow + "\nisEnabled: " + this.isEnabled + "\nwhenText: " + this.whenText + "\nrefClause: " + refString + "\nactionText: " + this.actionText + "\n";
    }

    public static class GfxdIMParamInfo {
        private boolean fromOldRow;
        private int position;
        private DataTypeDescriptor type;

        public GfxdIMParamInfo(boolean fromOld, int positionInRow, DataTypeDescriptor dtype) {
            this.fromOldRow = fromOld;
            this.position = positionInRow;
            this.type = dtype;
        }

        public int getPosition() {
            return this.position;
        }

        public boolean isFromOld() {
            return this.fromOldRow;
        }

        public DataTypeDescriptor getDTDType() {
            return this.type;
        }
    }
}

