/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.TypeCompiler;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeUtilities;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataType;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BooleanConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CharConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UntypedNullConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UserTypeConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public class CastNode
extends ValueNode {
    ValueNode castOperand;
    private int targetCharType;
    TypeId sourceCTI = null;
    private boolean forDataTypeFunction = false;
    private boolean externallyGeneratedCastNode = false;

    @Override
    public void init(Object castOperand, Object castTarget) throws StandardException {
        this.castOperand = (ValueNode)castOperand;
        this.setType((DataTypeDescriptor)castTarget);
    }

    @Override
    public void init(Object castOperand, Object charType, Object charLength) throws StandardException {
        this.castOperand = (ValueNode)castOperand;
        int charLen = (Integer)charLength;
        this.targetCharType = (Integer)charType;
        if (charLen < 0) {
            return;
        }
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(this.targetCharType, charLen));
    }

    @Override
    public String toString() {
        return "castTarget: " + this.getTypeServices() + "\n" + super.toString();
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.castOperand != null) {
            this.printLabel(depth, "castOperand: ");
            this.castOperand.treePrint(depth + 1);
        }
    }

    @Override
    protected int getOrderableVariantType() throws StandardException {
        return this.castOperand.getOrderableVariantType();
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.castOperand = this.castOperand.bindExpression(fromList, subqueryList, aggregateVector);
        if (this.getTypeServices() == null) {
            DataTypeDescriptor opndType = this.castOperand.getTypeServices();
            int length = -1;
            if (opndType != null) {
                TypeId srcTypeId = opndType.getTypeId();
                if (srcTypeId.isNumericTypeId()) {
                    length = opndType.getPrecision() + 1;
                    if (opndType.getScale() > 0) {
                        ++length;
                    }
                } else if (srcTypeId.isStringTypeId()) {
                    length = opndType.getMaximumWidth();
                    if (this.targetCharType == 1) {
                        length = Math.min(length, 254);
                    } else if (this.targetCharType == 12) {
                        length = Math.min(length, 32672);
                    }
                } else {
                    TypeId typeid = opndType.getTypeId();
                    if (length < 0) {
                        length = DataTypeUtilities.getColumnDisplaySize(typeid.getJDBCTypeId(), -1);
                    }
                }
            }
            if (length < 0) {
                length = 1;
            }
            this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(this.targetCharType, length));
        }
        if (this.castOperand instanceof UntypedNullConstantNode) {
            this.castOperand.setType(this.getTypeServices());
        }
        this.bindCastNodeOnly();
        if (this.castOperand instanceof ConstantNode && !(this.castOperand instanceof UntypedNullConstantNode)) {
            ValueNode retNode = this;
            int sourceJDBCTypeId = this.sourceCTI.getJDBCTypeId();
            int destJDBCTypeId = this.getTypeId().getJDBCTypeId();
            switch (sourceJDBCTypeId) {
                case -7: 
                case 16: {
                    if (destJDBCTypeId == -7 || destJDBCTypeId == 16) {
                        retNode = this.castOperand;
                        break;
                    }
                    if (destJDBCTypeId != 1) break;
                    BooleanConstantNode bcn = (BooleanConstantNode)this.castOperand;
                    String booleanString = bcn.getValueAsString();
                    retNode = (ValueNode)this.getNodeFactory().getNode(61, booleanString, ReuseFactory.getInteger(this.getTypeServices().getMaximumWidth()), this.getContextManager());
                    break;
                }
                case 1: {
                    retNode = this.getCastFromCharConstant(destJDBCTypeId);
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    if (destJDBCTypeId != 1) break;
                    String castValue = ((UserTypeConstantNode)this.castOperand).getObjectValue().toString();
                    retNode = (ValueNode)this.getNodeFactory().getNode(61, castValue, ReuseFactory.getInteger(this.getTypeServices().getMaximumWidth()), this.getContextManager());
                    break;
                }
                case 3: {
                    if (destJDBCTypeId == 3 || destJDBCTypeId == 2) break;
                }
                case -6: 
                case -5: 
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    retNode = this.getCastFromNumericType(((ConstantNode)this.castOperand).getValue(), destJDBCTypeId);
                }
            }
            return retNode;
        }
        return this;
    }

    public void bindCastNodeOnly() throws StandardException {
        TypeCompiler tc;
        this.sourceCTI = this.castOperand.getTypeId();
        if (this.externallyGeneratedCastNode && this.getTypeId().isStringTypeId()) {
            this.setCollationUsingCompilationSchema();
        }
        if (this.getTypeId().userType()) {
            this.setType(this.bindUserType(this.getTypeServices()));
            String className = this.getTypeId().getCorrespondingJavaTypeName();
            this.verifyClassExist(className);
        }
        if (this.castOperand.requiresTypeFromContext()) {
            this.castOperand.setType(this.getTypeServices());
        } else if (!(this.castOperand instanceof UntypedNullConstantNode) && !(tc = this.castOperand.getTypeCompiler()).convertible(this.getTypeId(), this.forDataTypeFunction)) {
            throw StandardException.newException("42846", (Object)this.sourceCTI.getSQLTypeName(), (Object)this.getTypeId().getSQLTypeName());
        }
        this.setNullability(this.castOperand.getTypeServices().isNullable());
    }

    private ValueNode getCastFromCharConstant(int destJDBCTypeId) throws StandardException {
        String charValue = ((CharConstantNode)this.castOperand).getString();
        String cleanCharValue = StringUtil.SQLToUpperCase(charValue.trim());
        CastNode retNode = this;
        switch (destJDBCTypeId) {
            case -7: 
            case 16: {
                if (cleanCharValue.equals("TRUE")) {
                    return (ValueNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
                }
                if (cleanCharValue.equals("FALSE")) {
                    return (ValueNode)this.getNodeFactory().getNode(38, Boolean.FALSE, this.getContextManager());
                }
                throw StandardException.newException("22018", (Object)"boolean", (Object)null);
            }
            case 91: {
                return (ValueNode)this.getNodeFactory().getNode(76, this.getDataValueFactory().getDateValue(cleanCharValue, false), this.getContextManager());
            }
            case 93: {
                return (ValueNode)this.getNodeFactory().getNode(76, this.getDataValueFactory().getTimestampValue(cleanCharValue, false), this.getContextManager());
            }
            case 92: {
                return (ValueNode)this.getNodeFactory().getNode(76, this.getDataValueFactory().getTimeValue(cleanCharValue, false), this.getContextManager());
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                try {
                    return this.getCastFromIntegralType(new Double(cleanCharValue).longValue(), destJDBCTypeId);
                }
                catch (NumberFormatException nfe) {
                    String sqlName = TypeId.getBuiltInTypeId(destJDBCTypeId).getSQLTypeName();
                    throw StandardException.newException("22018", (Object)sqlName, (Object)null);
                }
            }
            case 7: {
                Float floatValue;
                try {
                    floatValue = Float.valueOf(cleanCharValue);
                }
                catch (NumberFormatException nfe) {
                    throw StandardException.newException("22018", (Object)"float", (Object)null);
                }
                return (ValueNode)this.getNodeFactory().getNode(69, floatValue, this.getContextManager());
            }
            case 8: {
                Double doubleValue;
                try {
                    doubleValue = new Double(cleanCharValue);
                }
                catch (NumberFormatException nfe) {
                    throw StandardException.newException("22018", (Object)"double", (Object)null);
                }
                return (ValueNode)this.getNodeFactory().getNode(68, doubleValue, this.getContextManager());
            }
        }
        return retNode;
    }

    private ValueNode getCastFromIntegralType(long longValue, int destJDBCTypeId) throws StandardException {
        CastNode retNode = this;
        switch (destJDBCTypeId) {
            case 1: {
                return (ValueNode)this.getNodeFactory().getNode(61, Long.toString(longValue), ReuseFactory.getInteger(this.getTypeServices().getMaximumWidth()), this.getContextManager());
            }
            case -6: {
                if (longValue < -128L || longValue > 127L) {
                    throw StandardException.newException("22003", (Object)"TINYINT", (Object)null);
                }
                return (ValueNode)this.getNodeFactory().getNode(75, ReuseFactory.getByte((byte)longValue), this.getContextManager());
            }
            case 5: {
                if (longValue < -32768L || longValue > 32767L) {
                    throw StandardException.newException("22003", (Object)"SHORT", (Object)null);
                }
                return (ValueNode)this.getNodeFactory().getNode(74, ReuseFactory.getShort((short)longValue), this.getContextManager());
            }
            case 4: {
                if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
                    throw StandardException.newException("22003", (Object)"INTEGER", (Object)null);
                }
                return (ValueNode)this.getNodeFactory().getNode(70, ReuseFactory.getInteger((int)longValue), this.getContextManager());
            }
            case -5: {
                return (ValueNode)this.getNodeFactory().getNode(71, ReuseFactory.getLong(longValue), this.getContextManager());
            }
            case 7: {
                if ((float)Math.abs(longValue) > Float.MAX_VALUE) {
                    throw StandardException.newException("22003", (Object)"REAL", (Object)null);
                }
                return (ValueNode)this.getNodeFactory().getNode(69, new Float(longValue), this.getContextManager());
            }
            case 8: {
                return (ValueNode)this.getNodeFactory().getNode(68, new Double(longValue), this.getContextManager());
            }
        }
        return retNode;
    }

    private ValueNode getCastFromNumericType(DataValueDescriptor constantValue, int destJDBCTypeId) throws StandardException {
        int nodeType = -1;
        Object constantObject = null;
        switch (destJDBCTypeId) {
            case 1: {
                nodeType = 61;
                constantObject = constantValue.getString();
                return (ValueNode)this.getNodeFactory().getNode(nodeType, constantObject, ReuseFactory.getInteger(this.getTypeServices().getMaximumWidth()), this.getContextManager());
            }
            case -6: {
                nodeType = 75;
                constantObject = constantValue.getByte();
                break;
            }
            case 5: {
                nodeType = 74;
                constantObject = ReuseFactory.getShort(constantValue.getShort());
                break;
            }
            case 4: {
                nodeType = 70;
                constantObject = ReuseFactory.getInteger(constantValue.getInt());
                break;
            }
            case -5: {
                nodeType = 71;
                constantObject = ReuseFactory.getLong(constantValue.getLong());
                break;
            }
            case 7: {
                nodeType = 69;
                constantObject = new Float(NumberDataType.normalizeREALAllowNaN(constantValue.getDouble()));
                break;
            }
            case 8: {
                nodeType = 68;
                constantObject = new Double(constantValue.getDouble());
            }
        }
        if (nodeType == -1) {
            return this;
        }
        return (ValueNode)this.getNodeFactory().getNode(nodeType, constantObject, this.getContextManager());
    }

    @Override
    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        this.castOperand = this.castOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    @Override
    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        return this.castOperand.categorize(referencedTabs, simplePredsOnly);
    }

    @Override
    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.castOperand = this.castOperand.remapColumnReferencesToExpressions();
        return this;
    }

    @Override
    public boolean isConstantExpression() {
        return this.castOperand.isConstantExpression();
    }

    @Override
    public boolean constantExpression(PredicateList whereClause) {
        return this.castOperand.constantExpression(whereClause);
    }

    @Override
    public Object getConstantValueAsObject() throws StandardException {
        Object sourceObject = this.castOperand.getConstantValueAsObject();
        if (sourceObject == null) {
            return null;
        }
        if (this.sourceCTI.getCorrespondingJavaTypeName().equals(this.getTypeId().getCorrespondingJavaTypeName())) {
            return sourceObject;
        }
        return null;
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.castOperand.generateExpression(acb, mb);
        if (this.castOperand instanceof UntypedNullConstantNode) {
            return;
        }
        if (this.castOperand.requiresTypeFromContext()) {
            this.sourceCTI = this.getTypeId();
        }
        this.genDataValueConversion(acb, mb);
    }

    private void genDataValueConversion(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        MethodBuilder acbConstructor = acb.getConstructor();
        String resultTypeName = this.getTypeCompiler().interfaceName();
        LocalField field = acb.newFieldDeclaration(2, resultTypeName);
        acb.generateNull(acbConstructor, this.getTypeCompiler(this.getTypeId()), this.getTypeServices().getCollationType());
        acbConstructor.setField(field);
        if (!this.sourceCTI.userType() && !this.getTypeId().userType()) {
            mb.getField(field);
            mb.swap();
            mb.upCast("com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor");
            mb.callMethod((short)185, "com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor", "setValue", "void", 1);
        } else {
            mb.callMethod((short)185, "com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor", "getObject", "java.lang.Object", 0);
            mb.getField(field);
            mb.swap();
            String destinationType = this.getTypeId().getCorrespondingJavaTypeName();
            mb.dup();
            mb.isInstanceOf(destinationType);
            mb.push(destinationType);
            mb.callMethod((short)185, "com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor", "setObjectForCast", "void", 3);
        }
        mb.getField(field);
        if (this.getTypeId().variableLength()) {
            boolean isNumber = this.getTypeId().isNumericTypeId();
            mb.dup();
            mb.push(isNumber ? this.getTypeServices().getPrecision() : this.getTypeServices().getMaximumWidth());
            mb.push(this.getTypeServices().getScale());
            mb.push(!this.sourceCTI.variableLength() || isNumber);
            mb.callMethod((short)185, "com.pivotal.gemfirexd.internal.iapi.types.VariableSizeDataValue", "setWidth", "void", 3);
        }
    }

    @Override
    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (this.castOperand != null && !v.stopTraversal()) {
            this.castOperand = (ValueNode)this.castOperand.accept(v);
        }
        return returnNode;
    }

    public void setForExternallyGeneratedCASTnode() {
        this.externallyGeneratedCastNode = true;
    }

    public void setForDataTypeFunction(boolean b) {
        this.forDataTypeFunction = b;
    }

    @Override
    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeType(o)) {
            CastNode other = (CastNode)o;
            return this.getTypeServices().equals(other.getTypeServices()) && this.castOperand.isEquivalent(other.castOperand);
        }
        return false;
    }

    @Override
    public ValueNode genExpressionOperands(ResultColumnList outerResultColumns, ResultColumn parentRC, boolean remapToNew) throws StandardException {
        this.castOperand = this.castOperand.genExpressionOperands(outerResultColumns, null, remapToNew);
        return this;
    }

    @Override
    public String printExplainInfo() {
        return "CAST " + this.castOperand.printExplainInfo() + " AS " + this.getTypeServices().getTypeName();
    }

    @Override
    public String ncjGenerateSql() {
        String sql = this.castOperand.ncjGenerateSql();
        if (sql == null) {
            return null;
        }
        if (sql.equalsIgnoreCase("true") || sql.equalsIgnoreCase("false")) {
            return sql;
        }
        return super.ncjGenerateSql();
    }
}

