/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;

public final class BooleanConstantNode
extends ConstantNode {
    boolean booleanValue;
    boolean unknownValue;

    @Override
    public void init(Object arg1) throws StandardException {
        if (arg1 instanceof Boolean) {
            super.init(TypeId.BOOLEAN_ID, Boolean.FALSE, ReuseFactory.getInteger(1));
            this.booleanValue = (Boolean)arg1;
            super.setValue(this.getDataValueFactory().getDataValue(this.booleanValue));
        } else {
            super.init(arg1, Boolean.TRUE, ReuseFactory.getInteger(0));
            this.unknownValue = true;
        }
    }

    @Override
    public Object getConstantValueAsObject() {
        return this.booleanValue ? Boolean.TRUE : Boolean.FALSE;
    }

    String getValueAsString() {
        if (this.booleanValue) {
            return "true";
        }
        return "false";
    }

    @Override
    public boolean isBooleanTrue() {
        return this.booleanValue && !this.unknownValue;
    }

    @Override
    public boolean isBooleanFalse() {
        return !this.booleanValue && !this.unknownValue;
    }

    @Override
    public double selectivity(Optimizable optTable) {
        if (this.isBooleanTrue()) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public ValueNode eliminateNots(boolean underNotNode) {
        if (!underNotNode) {
            return this;
        }
        this.booleanValue = !this.booleanValue;
        super.setValue(this.getDataValueFactory().getDataValue(this.booleanValue));
        return this;
    }

    @Override
    void generateConstant(ExpressionClassBuilder acb, MethodBuilder mb) {
        mb.push(this.booleanValue);
    }

    @Override
    public void setValue(DataValueDescriptor value) {
        super.setValue(value);
        this.unknownValue = true;
        try {
            if (value != null && value.isNotNull().getBoolean()) {
                this.booleanValue = value.getBoolean();
                this.unknownValue = false;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
    }
}

