/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.ExpressionClassBuilderInterface;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.JoinStrategy;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicateList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.util.PropertyUtil;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;

abstract class BaseJoinStrategy
implements JoinStrategy {
    BaseJoinStrategy() {
    }

    @Override
    public boolean bulkFetchOK() {
        return true;
    }

    @Override
    public boolean ignoreBulkFetch() {
        return false;
    }

    void fillInScanArgs1(TransactionController tc, MethodBuilder mb, Optimizable innerTable, OptimizablePredicateList predList, ExpressionClassBuilderInterface acbi, MethodBuilder resultRowAllocator) throws StandardException {
        boolean sameStartStopPosition = predList.sameStartStopPosition();
        ExpressionClassBuilder acb = (ExpressionClassBuilder)acbi;
        long conglomNumber = innerTable.getTrulyTheBestAccessPath().getConglomerateDescriptor().getConglomerateNumber();
        StaticCompiledOpenConglomInfo scoci = tc.getStaticCompiledConglomInfo(conglomNumber);
        acb.pushThisAsActivation(mb);
        mb.push(conglomNumber);
        mb.push(acb.addItem(scoci));
        acb.pushMethodReference(mb, resultRowAllocator);
        mb.push(innerTable.getResultSetNumber());
        predList.generateStartKey(acb, mb, innerTable);
        mb.push(predList.startOperator(innerTable));
        if (!sameStartStopPosition) {
            predList.generateStopKey(acb, mb, innerTable);
        } else {
            mb.pushNull("com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod");
        }
        mb.push(predList.stopOperator(innerTable));
        mb.push(sameStartStopPosition);
        predList.generateQualifiers(acb, mb, innerTable, true);
        mb.upCast("com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier[][]");
    }

    final void fillInScanArgs2(MethodBuilder mb, Optimizable innerTable, int bulkFetch, int colRefItem, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, boolean delayScanOpening, boolean optimizeForOffHeap, boolean indexAccessesBaseTable) throws StandardException {
        mb.push(innerTable.getBaseTableName());
        if (innerTable.getProperties() != null) {
            mb.push(PropertyUtil.sortProperties(innerTable.getProperties()));
        } else {
            mb.pushNull("java.lang.String");
        }
        ConglomerateDescriptor cd = innerTable.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        if (cd.isConstraint()) {
            DataDictionary dd = innerTable.getDataDictionary();
            TableDescriptor td = innerTable.getTableDescriptor();
            ConstraintDescriptor constraintDesc = dd.getConstraintDescriptor(td, cd.getUUID());
            mb.push(constraintDesc.getConstraintName());
        } else if (cd.isIndex()) {
            mb.push(cd.getConglomerateName());
        } else {
            mb.pushNull("java.lang.String");
        }
        mb.push(cd.isConstraint());
        mb.push(innerTable.forUpdate());
        mb.push(colRefItem);
        mb.push(indexColItem);
        mb.push(lockMode);
        mb.push(tableLocked);
        mb.push(isolationLevel);
        if (bulkFetch > 0) {
            mb.push(bulkFetch);
        }
        if (this.validForOutermostTable()) {
            mb.push(innerTable.isOneRowScan());
        }
        mb.push(innerTable.getTrulyTheBestAccessPath().getCostEstimate().rowCount());
        mb.push(innerTable.getTrulyTheBestAccessPath().getCostEstimate().getEstimatedCost());
        mb.push(delayScanOpening);
        mb.push(optimizeForOffHeap);
        mb.push(indexAccessesBaseTable);
        mb.push(innerTable.getTrulyTheBestAccessPath().getFlagSupportsMoveToNextKey());
    }

    @Override
    public boolean isHashJoin() {
        return false;
    }

    protected boolean validForOutermostTable() {
        return false;
    }
}

