/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.gemstone.gemfire.internal.shared.ClientSharedData;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SPSDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTimestamp;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DataDictionaryImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;
import java.sql.Timestamp;
import java.util.Properties;

public class SYSSTATEMENTSRowFactory
extends CatalogRowFactory {
    static final String TABLENAME_STRING = "SYSSTATEMENTS";
    public static final int SYSSTATEMENTS_STMTID = 1;
    public static final int SYSSTATEMENTS_STMTNAME = 2;
    public static final int SYSSTATEMENTS_SCHEMAID = 3;
    public static final int SYSSTATEMENTS_TYPE = 4;
    public static final int SYSSTATEMENTS_VALID = 5;
    public static final int SYSSTATEMENTS_TEXT = 6;
    public static final int SYSSTATEMENTS_LASTCOMPILED = 7;
    public static final int SYSSTATEMENTS_COMPILATION_SCHEMAID = 8;
    public static final int SYSSTATEMENTS_USINGTEXT = 9;
    public static final int SYSSTATEMENTS_CONSTANTSTATE = 10;
    public static final int SYSSTATEMENTS_INITIALLY_COMPILABLE = 11;
    public static final int SYSSTATEMENTS_COLUMN_COUNT = 11;
    public static final int SYSSTATEMENTS_HIDDEN_COLUMN_COUNT = 2;
    protected static final int SYSSTATEMENTS_INDEX1_ID = 0;
    protected static final int SYSSTATEMENTS_INDEX2_ID = 1;
    private static final int[][] indexColumnPositions = new int[][]{{1}, {2, 3}};
    private static final boolean[] uniqueness = null;
    private static final String[] uuids = new String[]{"80000000-00d1-15f7-ab70-000a0a0b1500", "80000000-00d1-15fc-60b9-000a0a0b1500", "80000000-00d1-15fc-eda1-000a0a0b1500", "80000000-00d1-15fe-bdf8-000a0a0b1500"};

    SYSSTATEMENTSRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(11, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    public ExecRow makeSYSSTATEMENTSrow(boolean compileMe, SPSDescriptor spsDescriptor) throws StandardException {
        String name = null;
        UUID uuid = null;
        String uuidStr = null;
        String suuidStr = null;
        String compUuidStr = null;
        String text = null;
        String usingText = null;
        ExecPreparedStatement preparedStatement = null;
        String typeStr = null;
        boolean valid = true;
        Timestamp time = null;
        boolean initiallyCompilable = true;
        if (spsDescriptor != null) {
            name = spsDescriptor.getName();
            uuid = spsDescriptor.getUUID();
            if (uuid == null) {
                uuid = this.getUUIDFactory().createUUID();
                spsDescriptor.setUUID(uuid);
            }
            suuidStr = spsDescriptor.getSchemaDescriptor().getUUID().toString();
            uuidStr = uuid.toString();
            text = spsDescriptor.getText();
            valid = spsDescriptor.isValid();
            time = spsDescriptor.getCompileTime();
            typeStr = spsDescriptor.getTypeAsString();
            initiallyCompilable = spsDescriptor.initiallyCompilable();
            preparedStatement = spsDescriptor.getPreparedStatement(compileMe);
            compUuidStr = spsDescriptor.getCompSchemaId() != null ? spsDescriptor.getCompSchemaId().toString() : null;
            usingText = spsDescriptor.getUsingText();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(11);
        row.setColumn(1, new SQLChar(uuidStr));
        row.setColumn(2, new SQLVarchar(name));
        row.setColumn(3, new SQLChar(suuidStr));
        row.setColumn(4, new SQLChar(typeStr));
        row.setColumn(5, this.dvf.getDataValue(valid));
        row.setColumn(6, this.dvf.getLongvarcharDataValue(text));
        row.setColumn(7, new SQLTimestamp(time));
        row.setColumn(8, new SQLChar(compUuidStr));
        row.setColumn(9, this.dvf.getLongvarcharDataValue(usingText));
        row.setColumn(10, this.dvf.getDataValue(preparedStatement));
        row.setColumn(11, this.dvf.getDataValue(initiallyCompilable));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        boolean valid;
        UUID compUuid = null;
        Timestamp time = null;
        ExecPreparedStatement preparedStatement = null;
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        SanityManager.ASSERT((row.nColumns() == 11 ? 1 : 0) != 0, (String)"Wrong number of columns for a SYSSTATEMENTS row");
        DataValueDescriptor col = row.getColumn(1);
        String uuidStr = col.getString();
        UUID uuid = this.getUUIDFactory().recreateUUID(uuidStr);
        col = row.getColumn(2);
        String name = col.getString();
        col = row.getColumn(3);
        String suuidStr = col.getString();
        UUID suuid = this.getUUIDFactory().recreateUUID(suuidStr);
        col = row.getColumn(4);
        char type = col.getString().charAt(0);
        if (!SPSDescriptor.validType(type)) {
            SanityManager.THROWASSERT((String)("Bad type value (" + type + ") for  statement " + name));
        }
        if (((DataDictionaryImpl)dd).readOnlyUpgrade) {
            valid = false;
        } else {
            col = row.getColumn(5);
            valid = col.getBoolean();
        }
        col = row.getColumn(6);
        String text = col.getString();
        col = row.getColumn(7);
        time = col.getTimestamp(ClientSharedData.getDefaultCleanCalendar());
        col = row.getColumn(8);
        uuidStr = col.getString();
        if (uuidStr != null) {
            compUuid = this.getUUIDFactory().recreateUUID(uuidStr);
        }
        col = row.getColumn(9);
        String usingText = col.getString();
        if (valid) {
            col = row.getColumn(10);
            preparedStatement = (ExecPreparedStatement)col.getObject();
        }
        boolean initiallyCompilable = (col = row.getColumn(11)).isNull() ? true : col.getBoolean();
        SPSDescriptor descriptor = new SPSDescriptor(dd, name, uuid, suuid, compUuid, type, valid, text, usingText, time, preparedStatement, initiallyCompilable);
        return descriptor;
    }

    @Override
    public ExecRow makeEmptyRow() throws StandardException {
        return this.makeSYSSTATEMENTSrow(false, null);
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("STMTID", false), SystemColumnImpl.getIdentifierColumn("STMTNAME", false), SystemColumnImpl.getUUIDColumn("SCHEMAID", false), SystemColumnImpl.getIndicatorColumn("TYPE"), SystemColumnImpl.getColumn("VALID", 16, false), SystemColumnImpl.getColumn("TEXT", -1, false, 32700), SystemColumnImpl.getColumn("LASTCOMPILED", 93, true), SystemColumnImpl.getUUIDColumn("COMPILATIONSCHEMAID", true), SystemColumnImpl.getColumn("USINGTEXT", -1, true, 32700)};
    }

    @Override
    public Properties getCreateHeapProperties() {
        Properties properties = new Properties();
        properties.put("gemfirexd.storage.pageSize", "2048");
        properties.put("gemfirexd.storage.pageReservedSpace", "0");
        properties.put("gemfirexd.storage.minimumRecordSize", "1");
        return properties;
    }
}

