/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.IllegalTransactionStateException;
import com.gemstone.gemfire.cache.LockTimeoutException;
import com.gemstone.gemfire.cache.TransactionDataNodeHasDepartedException;
import com.gemstone.gemfire.cache.TransactionDataRebalancedException;
import com.gemstone.gemfire.cache.TransactionFlag;
import com.gemstone.gemfire.cache.TransactionInDoubtException;
import com.gemstone.gemfire.cache.TransactionStateReadOnlyException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.TXManagerImpl;
import com.pivotal.gemfirexd.FabricService;
import com.pivotal.gemfirexd.FabricServiceManager;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.db.Database;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.io.DerbyIOException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedSQLException;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.jdbc.InternalDriver;
import java.sql.SQLException;
import java.util.EnumSet;
import java.util.Properties;

public final class TransactionResourceImpl {
    protected ContextManager cm;
    protected ContextService csf;
    protected String username;
    private String dbname;
    private InternalDriver driver;
    private String url;
    private String drdaID;
    private String authToken;
    protected Database database;
    protected LanguageConnectionContext lcc;
    private final boolean disableStreaming;
    private final boolean skipListeners;
    private final EnumSet<TransactionFlag> txFlags;
    private final boolean enableStats;
    private final boolean enableTimeStats;
    private final boolean queryHDFS;
    private final boolean routeQuery;
    private final boolean snappyInternalConnection;
    private final boolean allowExplicitCommit;
    private final boolean defaultPersistent;
    private final boolean skipConstraintChecks;
    private final boolean enableBulkFkChecks;
    private final int queryTimeOut;
    private final int ncjBatchSize;
    private final int ncjCacheSize;
    private final boolean skipLocks;
    final String defaultSchema;
    private final boolean enableMetadataPrepare;

    TransactionResourceImpl(InternalDriver driver, String url, Properties info) throws SQLException {
        this.driver = driver;
        this.csf = driver.getContextServiceFactory();
        this.dbname = InternalDriver.getDatabaseName(url, info);
        this.url = url;
        this.username = IdUtil.getUserNameFromURLProps(info);
        this.authToken = info.getProperty("password", "");
        this.drdaID = info.getProperty("drdaID", null);
        this.cm = this.csf.newContextManager();
        this.skipLocks = this.getPropertyValue("skip-locks", null, info, false);
        this.defaultSchema = PropertyUtil.findAndGetProperty(info, "default-schema", null);
        this.disableStreaming = this.getPropertyValue("disable-streaming", GfxdConstants.GFXD_DISABLE_STREAMING, info, false);
        this.skipListeners = this.getPropertyValue("skip-listeners", null, info, false);
        EnumSet<TransactionFlag> flags = null;
        if (this.getPropertyValue("enable-tx-wait-mode", "gemfirexd.enable-tx-wait-mode", info, false)) {
            flags = GemFireXDUtils.addTXFlag(TransactionFlag.WAITING_MODE, TXManagerImpl.WAITING_MODE, flags);
        }
        if (this.getPropertyValue("disable-tx-batching", "gemfirexd.disable-tx-batching", info, false)) {
            flags = GemFireXDUtils.addTXFlag(TransactionFlag.DISABLE_BATCHING, TXManagerImpl.DISABLE_BATCHING, flags);
        }
        if (this.getPropertyValue("disable-tx-batching", "sqlfire.disable-tx-batching", info, false)) {
            flags = GemFireXDUtils.addTXFlag(TransactionFlag.DISABLE_BATCHING, TXManagerImpl.DISABLE_BATCHING, flags);
        }
        if (this.getPropertyValue("sync-commits", "gemfirexd.sync-commits", info, false)) {
            flags = GemFireXDUtils.addTXFlag(TransactionFlag.SYNC_COMMITS, TXManagerImpl.SYNC_COMMITS, flags);
        }
        if (this.getPropertyValue("sync-commits", "sqlfire.sync-commits", info, false)) {
            flags = GemFireXDUtils.addTXFlag(TransactionFlag.SYNC_COMMITS, TXManagerImpl.SYNC_COMMITS, flags);
        }
        this.txFlags = flags;
        this.enableStats = this.getPropertyValue("enable-stats", GfxdConstants.GFXD_ENABLE_STATS, info, false);
        this.enableTimeStats = this.enableStats ? this.getPropertyValue("enable-timestats", GfxdConstants.GFXD_ENABLE_TIMESTATS, info, false) : false;
        this.queryHDFS = this.getPropertyValue("query-HDFS", GfxdConstants.GFXD_QUERY_HDFS, info, false);
        this.routeQuery = this.getPropertyValue("route-query", GfxdConstants.GFXD_ROUTE_QUERY, info, false);
        this.snappyInternalConnection = this.getPropertyValue("internal-connection", GfxdConstants.INTERNAL_CONNECTION, info, false);
        this.allowExplicitCommit = this.getPropertyValue("allow-explicit-commit", GfxdConstants.ALLOW_EXPLICIT_COMMIT, info, false);
        this.defaultPersistent = this.getPropertyValue("default-persistent", GfxdConstants.GFXD_PREFIX + "default-persistent", info, false);
        this.enableBulkFkChecks = PropertyUtil.getBooleanProperty("enable-bulk-fk-checks", GfxdConstants.GFXD_ENABLE_BULK_FK_CHECKS, info, true, null);
        this.skipConstraintChecks = this.getPropertyValue("skip-constraint-checks", null, info, false);
        this.enableMetadataPrepare = PropertyUtil.getBooleanProperty("enable-metadata-prepare", GfxdConstants.GFXD_ENABLE_METADATA_PREPARE, info, false, null);
        String qt = PropertyUtil.findAndGetProperty(info, GfxdConstants.GFXD_QUERY_TIMEOUT, "query-timeout");
        if (qt == null) {
            qt = PropertyUtil.findAndGetProperty(info, "sqlfire.query-timeout", "query-timeout");
        }
        this.queryTimeOut = qt != null ? Integer.parseInt(qt) : 0;
        String ncjBatch = PropertyUtil.findAndGetProperty(info, GfxdConstants.GFXD_NCJ_BATCH_SIZE, "ncj-batch-size");
        this.ncjBatchSize = ncjBatch != null ? Integer.parseInt(ncjBatch) : 0;
        String ncjCache = PropertyUtil.findAndGetProperty(info, GfxdConstants.GFXD_NCJ_CACHE_SIZE, "ncj-cache-size");
        this.ncjCacheSize = ncjCache != null ? Integer.parseInt(ncjCache) : 0;
    }

    private final boolean getPropertyValue(String propName, String sysPropName, Properties info, boolean def) {
        return PropertyUtil.getBooleanProperty(propName, sysPropName, info, def, null);
    }

    public final EnumSet<TransactionFlag> getTXFlags() {
        return this.txFlags;
    }

    void setDatabase(Database db) {
        SanityManager.ASSERT((this.database == null ? 1 : 0) != 0, (String)"setting database when it is not null");
        this.database = db;
    }

    void startTransaction(long connectionID, boolean isRemote) throws StandardException, SQLException {
        this.lcc = this.database.setupConnection(this.cm, this.username, this.authToken, this.drdaID, this.dbname, connectionID, isRemote);
        this.lcc.setEnableStreaming(!isRemote && !this.disableStreaming);
        this.lcc.setStatsEnabled(this.enableStats, this.enableTimeStats, this.lcc.explainConnection());
        if (this.skipListeners) {
            this.lcc.setSkipListeners();
        }
        this.lcc.setTXFlags(this.txFlags);
        this.lcc.setQueryHDFS(this.queryHDFS);
        this.lcc.setQueryRoutingFlag(this.routeQuery);
        this.lcc.setSnappyInternalConnection(this.snappyInternalConnection);
        this.lcc.setAllowExplicitCommit(this.allowExplicitCommit);
        this.lcc.setDefaultPersistent(this.defaultPersistent);
        this.lcc.setEnableBulkFkChecks(this.enableBulkFkChecks);
        this.lcc.setSkipConstraintChecks(this.skipConstraintChecks);
        this.lcc.setDefaultQueryTimeOut(this.queryTimeOut);
        this.lcc.setSkipLocksForConnection(this.skipLocks);
        this.lcc.setNcjBatchSize(this.ncjBatchSize);
        this.lcc.setNcjCacheSize(this.ncjCacheSize);
    }

    InternalDriver getDriver() {
        return this.driver;
    }

    ContextService getCsf() {
        return this.csf;
    }

    ContextManager getContextManager() {
        return this.cm;
    }

    final LanguageConnectionContext getLcc() {
        return this.lcc;
    }

    String getDBName() {
        return this.dbname;
    }

    String getUrl() {
        return this.url;
    }

    public Database getDatabase() {
        return this.database;
    }

    StandardException shutdownDatabaseException() {
        StandardException se = StandardException.newException("08006.D", this.getDBName());
        se.setReport(1);
        return se;
    }

    public void commit(EmbedConnection conn) throws StandardException {
        this.lcc.userCommit();
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null) {
            observer.afterCommit(conn);
        }
    }

    void rollback() throws StandardException {
        if (this.lcc != null) {
            this.lcc.userRollback();
        }
    }

    void clearContextInError() {
        ContextManager cm = this.cm;
        if (cm != null) {
            this.csf.resetCurrentContextManager(cm);
            this.csf.removeContext(cm);
            this.cm = null;
        }
    }

    void clearLcc() {
        this.lcc = null;
    }

    public final void setupContextStack() {
        SanityManager.ASSERT((this.cm != null ? 1 : 0) != 0, (String)"setting up null context manager stack");
        this.csf.setCurrentContextManager(this.cm);
    }

    final void setupContextStackAndReattach(boolean isOperation) throws SQLException {
        SanityManager.ASSERT((this.cm != null ? 1 : 0) != 0, (String)"setting up null context manager stack");
        if (this.csf.setCurrentContextManager(this.cm)) {
            GemFireTransaction.reattachTransaction(this.lcc, isOperation);
        } else if (isOperation) {
            GemFireTransaction.setActiveStateForTransaction(this.lcc);
        }
    }

    public final void restoreContextStack() {
        if (this.csf == null || this.cm == null) {
            return;
        }
        this.csf.resetCurrentContextManager(this.cm);
    }

    final SQLException handleException(Throwable thrownException, boolean autoCommit, boolean rollbackOnAutoCommit) throws SQLException {
        try {
            StandardException txEx;
            SanityManager.ASSERT((thrownException != null ? 1 : 0) != 0);
            if (thrownException instanceof SQLException) {
                if (this.lcc != null) {
                    ((GemFireTransaction)this.lcc.getTransactionExecute()).release();
                }
                return (SQLException)thrownException;
            }
            boolean checkForShutdown = false;
            if (thrownException instanceof StandardException) {
                StandardException se = (StandardException)thrownException;
                int severity = se.getSeverity();
                if (severity <= 20000) {
                    if (autoCommit && rollbackOnAutoCommit || ((GemFireTransaction)this.lcc.getTransactionExecute()).getImplcitSnapshotTxStarted()) {
                        se.setSeverity(30000);
                    }
                } else if ("08000".equals(se.getMessageId())) {
                    checkForShutdown = true;
                }
            }
            if ((txEx = TransactionResourceImpl.wrapsTransactionException(thrownException)) != null) {
                if (thrownException instanceof StandardException) {
                    StandardException thrownSe = (StandardException)thrownException;
                    if (!txEx.getMessageId().equals(thrownSe.getMessageId())) {
                        if (txEx.getMessageId().startsWith(thrownSe.getSQLState())) {
                            thrownSe.setSeverity(30000);
                        } else {
                            thrownException = txEx;
                        }
                    }
                } else {
                    StandardException se = txEx;
                    se.setSeverity(30000);
                    thrownException = se;
                }
            }
            if (this.cm != null) {
                boolean isShutdown = thrownException instanceof CacheClosedException;
                if (!isShutdown) {
                    isShutdown = this.cleanupOnError(thrownException);
                } else if (this.lcc != null) {
                    ((GemFireTransaction)this.lcc.getTransactionExecute()).release();
                }
                if (checkForShutdown && isShutdown) {
                    thrownException = this.shutdownDatabaseException();
                }
            }
            return TransactionResourceImpl.wrapInSQLException(thrownException);
        }
        catch (Throwable t) {
            if (this.cm != null) {
                this.cm.cleanupOnError(t);
            }
            throw TransactionResourceImpl.wrapInSQLException(t);
        }
    }

    public static SQLException wrapInSQLException(Throwable thrownException) {
        SQLException sqle;
        DerbyIOException dioe;
        Throwable cause;
        Error err;
        if (thrownException == null) {
            return null;
        }
        if (thrownException instanceof Error && SystemFailure.isJVMFailureError((Error)(err = (Error)thrownException))) {
            SystemFailure.initiateFailure((Error)err);
            throw err;
        }
        SystemFailure.checkFailure();
        GemFireCacheImpl cache = Misc.getGemFireCacheNoThrow();
        FabricService service = FabricServiceManager.currentFabricServiceInstance();
        if (cache == null || cache.getCancelCriterion().cancelInProgress() != null || service == null || service.status() == FabricService.State.STOPPING || service.status() == FabricService.State.STOPPED || Monitor.inShutdown()) {
            StandardException se;
            if (thrownException instanceof SQLException && ((SQLException)thrownException).getErrorCode() >= 40000) {
                return (SQLException)thrownException;
            }
            if (thrownException instanceof StandardException && ((StandardException)thrownException).getSeverity() >= 40000) {
                se = (StandardException)thrownException;
            } else {
                se = StandardException.newException("08006.D", thrownException, (Object)"gemfirexd");
                se.setReport(1);
            }
            return EmbedSQLException.wrapStandardException(se.getMessage(), se.getMessageId(), se.getSeverity(), se);
        }
        if (thrownException instanceof GemFireXDRuntimeException && thrownException.getCause() != null) {
            thrownException = thrownException.getCause();
        }
        if ((cause = thrownException.getCause()) != null && cause instanceof SQLException && ((SQLException)cause).getSQLState() != null || cause instanceof StandardException && ((StandardException)cause).getSQLState() != null) {
            thrownException = cause;
        }
        if (thrownException instanceof DerbyIOException && (dioe = (DerbyIOException)thrownException).getSQLState() != null) {
            return Util.getExceptionFactory().getSQLException(dioe.getMessage(), dioe.getSQLState(), null, StandardException.getSeverityFromIdentifier(dioe.getSQLState()), dioe, null);
        }
        if (thrownException instanceof SQLException) {
            return (SQLException)thrownException;
        }
        if (thrownException instanceof StandardException) {
            StandardException se = (StandardException)thrownException;
            if (se.getCause() == null) {
                return Util.generateCsSQLException(se);
            }
            if (!"38000".equals(se.getMessageId()) || !TransactionResourceImpl.wrapsCancelException(se.getCause(), true)) {
                return Util.generateCsSQLException(se);
            }
        }
        if (TransactionResourceImpl.wrapsCancelException(thrownException, false)) {
            sqle = TransactionResourceImpl.checkTransactionNodeFailureException(thrownException);
            if (sqle != null) {
                return sqle;
            }
            StandardException se = StandardException.newException("08006.D", thrownException, (Object)"gemfirexd");
            se.setReport(1);
            return EmbedSQLException.wrapStandardException(se.getMessage(), se.getMessageId(), se.getSeverity(), se);
        }
        if (GemFireXDUtils.retryToBeDone(thrownException)) {
            sqle = TransactionResourceImpl.checkTransactionNodeFailureException(thrownException);
            if (sqle != null) {
                return sqle;
            }
            StandardException se = StandardException.newException("X0Z01.S", thrownException, null, (Object)"handleException");
            return EmbedSQLException.wrapStandardException(se.getMessage(), se.getMessageId(), se.getSeverity(), se);
        }
        if (thrownException instanceof GemFireException) {
            Throwable t = thrownException;
            while ((t = t.getCause()) != null) {
                if (!(t instanceof SQLException)) continue;
                return (SQLException)t;
            }
            StandardException se = Misc.processKnownGemFireException((GemFireException)thrownException, thrownException, "handleException", false);
            if (se != null) {
                return Util.generateCsSQLException(se);
            }
        }
        return Util.javaException(thrownException);
    }

    private static boolean wrapsCancelException(Throwable thrownException, boolean checkRemote) {
        return GemFireXDUtils.nodeFailureException(thrownException, checkRemote);
    }

    private static StandardException wrapsTransactionException(Throwable thrownException) {
        Throwable cause = thrownException;
        do {
            if (cause instanceof ConflictException) {
                return StandardException.newException("X0Z02.T", thrownException, (Object)cause.getMessage());
            }
            if (cause instanceof LockTimeoutException) {
                return StandardException.newException("40XL1", thrownException);
            }
            if (cause instanceof TransactionInDoubtException) {
                return StandardException.newException("X0Z06.T", thrownException);
            }
            if (cause instanceof TransactionDataRebalancedException) {
                TransactionDataRebalancedException tdre = (TransactionDataRebalancedException)cause;
                return StandardException.newException("40XD2", thrownException, (Object)Misc.getFullTableNameFromRegionPath(tdre.getRegionPath()));
            }
            if (cause instanceof TransactionDataNodeHasDepartedException) {
                return StandardException.newException("40XD0", thrownException, (Object)StandardException.getSenderFromExceptionOrSelf(thrownException), (Object)"");
            }
            if (cause instanceof IllegalTransactionStateException) {
                return StandardException.newException("X0Z16.T", thrownException, (Object)cause.getLocalizedMessage());
            }
            if (!(cause instanceof TransactionStateReadOnlyException)) continue;
            return StandardException.newException("X0Z03.T", thrownException, (Object)cause.getLocalizedMessage());
        } while ((cause = cause.getCause()) != null);
        return null;
    }

    private static SQLException checkTransactionNodeFailureException(Throwable thrownException) {
        if (TXManagerImpl.getCurrentTXState() != null) {
            return Util.generateCsSQLException(StandardException.newException("40XD0", thrownException, (Object)StandardException.getSenderFromExceptionOrSelf(thrownException), (Object)""));
        }
        return null;
    }

    String getUserName() {
        return this.username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cleanupOnError(Throwable e) {
        SanityManager.ASSERT((this.cm != null ? 1 : 0) != 0, (String)"cannot cleanup on error with null context manager");
        try {
            boolean bl = this.cm.cleanupOnError(e);
            return bl;
        }
        finally {
            TransactionController tc;
            LanguageConnectionContext lcc = this.getLcc();
            if (lcc != null && !lcc.isConnectionForRemote() && !(tc = lcc.getTransactionExecute()).isTransactional()) {
                tc.releaseAllLocks(false, false);
            }
            if (this.getDatabase() != null && !this.getDatabase().isActive()) {
                this.getDatabase().cleanupOnError(e);
            }
        }
    }

    boolean isIdle() {
        return this.lcc == null || this.lcc.getTransactionExecute().isIdle();
    }

    boolean isActive() {
        return this.driver.isActive() && (this.database == null || this.database.isActive());
    }

    public final boolean forMetadataPrepare() {
        return this.enableMetadataPrepare;
    }
}

