/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.StreamStorable;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDecimal;
import com.pivotal.gemfirexd.internal.impl.jdbc.BinaryToRawStream;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedCallableStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.UTF8Reader;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public abstract class EmbedCallableStatement20
extends EmbedCallableStatement {
    public EmbedCallableStatement20(EmbedConnection conn, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, long id, short execFlags) throws SQLException {
        super(conn, sql, resultSetType, resultSetConcurrency, resultSetHoldability, id, execFlags);
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        this.checkStatus();
        try {
            DataValueDescriptor dvd = this.getParms().getParameterForGet(parameterIndex - 1);
            this.wasNull = dvd.isNull();
            if (this.wasNull) {
                return null;
            }
            return SQLDecimal.getBigDecimal(dvd);
        }
        catch (StandardException e) {
            throw EmbedResultSet.noStateChangeException(e, "parameter index " + parameterIndex);
        }
    }

    public Object getObject(int i, Map map) throws SQLException {
        this.checkStatus();
        if (map == null) {
            throw Util.generateCsSQLException("XJ081.S", map, "map", "java.sql.CallableStatement.getObject");
        }
        if (!map.isEmpty()) {
            throw Util.notImplemented();
        }
        return this.getObject(i);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        throw Util.notImplemented();
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        this.checkStatus();
        if (map == null) {
            throw Util.generateCsSQLException("XJ081.S", map, "map", "java.sql.CallableStatement.getObject");
        }
        if (!map.isEmpty()) {
            throw Util.notImplemented();
        }
        return this.getObject(parameterName);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setBigDecimal(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t, "parameter index " + parameterIndex);
        }
    }

    @Override
    public final BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        BigDecimal v = this.getBigDecimal(parameterIndex);
        if (v != null) {
            v = v.setScale(scale, 5);
        }
        return v;
    }

    @Override
    boolean setObjectConvert(int parameterIndex, Object x) throws SQLException {
        if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        this.checkStatus();
        switch (this.getParms().getParameterMode(parameterIndex)) {
            case 0: 
            case 1: {
                throw this.newSQLException("XCL26.S", Integer.toString(parameterIndex));
            }
        }
        Reader reader = null;
        int paramType = this.getParameterJDBCType(parameterIndex);
        switch (paramType) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                Object syncObject;
                boolean pushStack = false;
                Object object = syncObject = this.getConnectionSynchronization();
                synchronized (object) {
                    try {
                        DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
                        if (param.isNull()) {
                            break;
                        }
                        pushStack = true;
                        this.setupContextStack(false);
                        StreamStorable ss = (StreamStorable)((Object)param);
                        InputStream stream = ss.returnStream();
                        reader = stream == null ? new StringReader(param.getString()) : new UTF8Reader(stream, 0L, this, syncObject);
                        break;
                    }
                    catch (Throwable t) {
                        throw EmbedResultSet.noStateChangeException(t, "parameter index " + parameterIndex);
                    }
                    finally {
                        if (pushStack) {
                            this.restoreContextStack();
                        }
                    }
                }
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                try {
                    InputStream is = this.getBinaryStream(parameterIndex);
                    if (is == null) break;
                    reader = new InputStreamReader(is, "UTF-16BE");
                    break;
                }
                catch (UnsupportedEncodingException uee) {
                    throw this.newSQLException(uee.getMessage());
                }
            }
            default: {
                throw this.newSQLException("22005", "java.io.Reader", Util.typeName(paramType), parameterIndex);
            }
        }
        this.wasNull = reader == null;
        return reader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream getBinaryStream(int parameterIndex) throws SQLException {
        int paramType = this.getParameterJDBCType(parameterIndex);
        switch (paramType) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                break;
            }
            default: {
                throw this.newSQLException("22005", "java.io.InputStream", Util.typeName(paramType), parameterIndex);
            }
        }
        boolean pushStack = false;
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            try {
                DataValueDescriptor param = this.getParms().getParameterForGet(parameterIndex - 1);
                this.wasNull = param.isNull();
                if (this.wasNull) {
                    InputStream inputStream = null;
                    return inputStream;
                }
                pushStack = true;
                this.setupContextStack(false);
                StreamStorable ss = (StreamStorable)((Object)param);
                InputStream stream = ss.returnStream();
                stream = stream == null ? new ByteArrayInputStream(param.getBytes()) : new BinaryToRawStream(stream, param);
                InputStream inputStream = stream;
                return inputStream;
            }
            catch (Throwable t) {
                throw EmbedResultSet.noStateChangeException(t, "parameter index " + parameterIndex);
            }
            finally {
                if (pushStack) {
                    this.restoreContextStack();
                }
            }
        }
    }
}

