/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataType;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDouble;
import com.pivotal.gemfirexd.internal.iapi.types.StringDataValue;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class SQLReal
extends NumberDataType {
    static final int REAL_LENGTH = 16;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLReal.class);
    private float value;
    private boolean isnull;

    @Override
    public int getInt() throws StandardException {
        if ((double)this.value > 2.147483648E9 || (double)this.value < -2.147483649E9) {
            throw StandardException.newException("22003", (Object)"INTEGER", (Object)null);
        }
        return (int)this.value;
    }

    @Override
    public byte getByte() throws StandardException {
        if ((double)this.value > 128.0 || (double)this.value < -129.0) {
            throw StandardException.newException("22003", (Object)"TINYINT", (Object)null);
        }
        return (byte)this.value;
    }

    @Override
    public short getShort() throws StandardException {
        if ((double)this.value > 32768.0 || (double)this.value < -32769.0) {
            throw StandardException.newException("22003", (Object)"SMALLINT", (Object)null);
        }
        return (short)this.value;
    }

    @Override
    public long getLong() throws StandardException {
        if ((double)this.value > 9.223372036854776E18 || (double)this.value < -9.223372036854776E18) {
            throw StandardException.newException("22003", (Object)"BIGINT", (Object)null);
        }
        return (long)this.value;
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public int typeToBigDecimal() {
        return 1;
    }

    @Override
    public boolean getBoolean() {
        return this.value != 0.0f;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Float.toString(this.value);
    }

    @Override
    public int getLength() {
        return 16;
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return new Float(this.value);
    }

    @Override
    public String getTypeName() {
        return "REAL";
    }

    @Override
    public int getTypeFormatId() {
        return 81;
    }

    @Override
    public boolean isNull() {
        return this.isnull;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT((!this.isNull() ? 1 : 0) != 0);
        out.writeFloat(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.value = in.readFloat();
        this.isnull = false;
    }

    @Override
    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        this.value = in.readFloat();
        this.isnull = false;
    }

    @Override
    public void restoreToNull() {
        this.value = 0.0f;
        this.isnull = true;
    }

    @Override
    protected int typeCompare(DataValueDescriptor arg) throws StandardException {
        float otherValue;
        float thisValue = this.getFloat();
        if (thisValue == (otherValue = NumberDataType.normalizeREALAllowNaN(arg.getFloat()))) {
            return 0;
        }
        if (thisValue > otherValue) {
            return 1;
        }
        return -1;
    }

    @Override
    public DataValueDescriptor getClone() {
        SQLReal ret = new SQLReal();
        ret.value = this.value;
        ret.isnull = this.isnull;
        return ret;
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLReal();
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws StandardException, SQLException {
        float fv = resultSet.getFloat(colNumber);
        if (isNullable && resultSet.wasNull()) {
            this.restoreToNull();
        } else {
            this.setValue(fv);
        }
    }

    @Override
    public final void setInto(PreparedStatement ps, int position) throws SQLException {
        if (this.isNull()) {
            ps.setNull(position, 7);
            return;
        }
        ps.setFloat(position, this.value);
    }

    @Override
    public final void setInto(ResultSet rs, int position) throws SQLException, StandardException {
        rs.updateFloat(position, this.value);
    }

    public SQLReal() {
        this.isnull = true;
    }

    public SQLReal(float val) throws StandardException {
        this.value = NumberDataType.normalizeREALAllowNaN(val);
    }

    public SQLReal(Float obj) throws StandardException {
        this.isnull = obj == null;
        if (!this.isnull) {
            this.value = NumberDataType.normalizeREALAllowNaN(obj.floatValue());
        }
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        if (theValue == null) {
            this.value = 0.0f;
            this.isnull = true;
        } else {
            try {
                this.setValue(Double.valueOf(theValue.trim()));
            }
            catch (NumberFormatException nfe) {
                throw this.invalidFormat();
            }
        }
    }

    @Override
    public void setValue(Number theValue) throws StandardException {
        if (this.objectNull(theValue)) {
            return;
        }
        if (!(theValue instanceof Float)) {
            SanityManager.THROWASSERT((String)("SQLReal.setValue(Number) passed a " + theValue.getClass()));
        }
        this.setValue(theValue.floatValue());
    }

    @Override
    public void setBigDecimal(Number bigDecimal) throws StandardException {
        if (this.objectNull(bigDecimal)) {
            return;
        }
        this.setValue(bigDecimal.floatValue());
    }

    @Override
    public void setValue(float theValue) throws StandardException {
        this.value = NumberDataType.normalizeREALAllowNaN(theValue);
        this.isnull = false;
    }

    @Override
    public void setValue(int theValue) {
        this.value = theValue;
        this.isnull = false;
    }

    @Override
    public void setValue(long theValue) {
        this.value = theValue;
        this.isnull = false;
    }

    @Override
    public void setValue(double theValue) throws StandardException {
        float fv = (float)theValue;
        if (fv == 0.0f && theValue != 0.0 && !Misc.getMemStore().isSnappyStore()) {
            throw StandardException.newException("22003", (Object)"REAL", (Object)null);
        }
        this.setValue(fv);
    }

    @Override
    public void setValue(boolean theValue) {
        this.value = theValue ? 1.0f : 0.0f;
        this.isnull = false;
    }

    @Override
    void setObject(Object theValue) throws StandardException {
        this.setValue(((Float)theValue).floatValue());
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        if (theValue instanceof StringDataValue) {
            this.setValue(theValue.getString());
        } else if (theValue instanceof SQLDouble) {
            this.setValue(theValue.getDouble());
        } else {
            this.setValue(theValue.getFloat());
        }
    }

    @Override
    public int typePrecedence() {
        return 80;
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getFloat() == right.getFloat());
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getFloat() != right.getFloat());
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getFloat() < right.getFloat());
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getFloat() > right.getFloat());
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getFloat() <= right.getFloat());
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getFloat() >= right.getFloat());
    }

    @Override
    public NumberDataValue plus(NumberDataValue addend1, NumberDataValue addend2, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLReal();
        }
        if (addend1.isNull() || addend2.isNull()) {
            result.setToNull();
            return result;
        }
        double dsum = addend1.getDouble() + addend2.getDouble();
        result.setValue(dsum);
        return result;
    }

    @Override
    public NumberDataValue minus(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLReal();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        double ddifference = left.getDouble() - right.getDouble();
        result.setValue(ddifference);
        return result;
    }

    @Override
    public NumberDataValue times(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        double rightValue;
        if (result == null) {
            result = new SQLReal();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        double leftValue = left.getDouble();
        double tempResult = leftValue * (rightValue = right.getDouble());
        if (tempResult == 0.0 && leftValue != 0.0 && rightValue != 0.0) {
            throw StandardException.newException("22003", (Object)"REAL", (Object)null);
        }
        result.setValue(tempResult);
        return result;
    }

    @Override
    public NumberDataValue divide(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLReal();
        }
        if (dividend.isNull() || divisor.isNull()) {
            result.setToNull();
            return result;
        }
        double divisorValue = divisor.getDouble();
        if (divisorValue == 0.0) {
            throw StandardException.newException("22012");
        }
        double dividendValue = dividend.getDouble();
        double resultValue = dividendValue / divisorValue;
        if (Double.isNaN(resultValue)) {
            throw StandardException.newException("22012");
        }
        if (resultValue == 0.0 && dividendValue != 0.0) {
            throw StandardException.newException("22003", (Object)"REAL", (Object)null);
        }
        result.setValue(resultValue);
        return result;
    }

    @Override
    public NumberDataValue minus(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLReal();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        float minusResult = -this.getFloat();
        result.setValue(minusResult);
        return result;
    }

    @Override
    protected boolean isNegative() {
        return !this.isNull() && this.value < 0.0f;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Float.toString(this.value);
    }

    public int hashCode() {
        long longVal = (long)this.value;
        if ((float)longVal != this.value) {
            longVal = Double.doubleToLongBits(this.value);
        }
        return (int)(longVal ^ longVal >> 32);
    }

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        if (!this.isNull()) {
            out.writeByte(this.getTypeId());
            out.writeFloat(this.value);
            return;
        }
        this.writeNullDVD(out);
    }

    @Override
    public final void fromDataForOptimizedResultHolder(DataInput dis) throws IOException, ClassNotFoundException {
        this.value = dis.readFloat();
        this.isnull = false;
    }

    @Override
    public final void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
        assert (!this.isNull());
        dos.writeFloat(this.value);
    }

    @Override
    public int getLengthInBytes(DataTypeDescriptor dtd) {
        if (!this.isNull()) {
            return 4;
        }
        return 0;
    }

    @Override
    public int writeBytes(byte[] outBytes, int offset, DataTypeDescriptor dtd) {
        assert (!this.isNull());
        int bits = Float.floatToIntBits(this.value);
        int numBytes = RowFormatter.writeInt(outBytes, bits, offset);
        return numBytes;
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        this.value = Float.intBitsToFloat(RowFormatter.readInt(inBytes, offset));
        this.isnull = false;
        assert (columnWidth == 4);
        return columnWidth;
    }

    @Override
    public int readBytes(long memOffset, int columnWidth, ByteSource bs) {
        this.value = Float.intBitsToFloat(RowFormatter.readInt(memOffset));
        this.isnull = false;
        assert (columnWidth == 4);
        return columnWidth;
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        assert (!this.isNull());
        int bits = Float.floatToIntBits(this.value);
        return ResolverUtils.addIntToBucketHash((int)bits, (int)hash, (int)this.getTypeFormatId());
    }

    static final float getAsFloat(byte[] inBytes, int offset) {
        return Float.intBitsToFloat(RowFormatter.readInt(inBytes, offset));
    }

    static final float getAsFloat(long memOffset) {
        return Float.intBitsToFloat(RowFormatter.readInt(memOffset));
    }

    @Override
    public byte getTypeId() {
        return 59;
    }
}

