/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.StatArchiveWriter;
import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataType;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public final class SQLLongint
extends NumberDataType {
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLLongint.class);
    private long value;
    private boolean isnull;

    @Override
    public int getInt() throws StandardException {
        if (this.value > Integer.MAX_VALUE || this.value < Integer.MIN_VALUE) {
            throw StandardException.newException("22003", (Object)"INTEGER", (Object)null);
        }
        return (int)this.value;
    }

    @Override
    public byte getByte() throws StandardException {
        if (this.value > 127L || this.value < -128L) {
            throw StandardException.newException("22003", (Object)"TINYINT", (Object)null);
        }
        return (byte)this.value;
    }

    @Override
    public short getShort() throws StandardException {
        if (this.value > 32767L || this.value < -32768L) {
            throw StandardException.newException("22003", (Object)"SMALLINT", (Object)null);
        }
        return (short)this.value;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public float getFloat() {
        return this.value;
    }

    @Override
    public double getDouble() {
        return this.value;
    }

    @Override
    public boolean getBoolean() {
        return this.value != 0L;
    }

    @Override
    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Long.toString(this.value);
    }

    @Override
    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public String getTypeName() {
        return "BIGINT";
    }

    @Override
    public int getTypeFormatId() {
        return 84;
    }

    @Override
    public boolean isNull() {
        return this.isnull;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        boolean isNull = this.isNull();
        out.writeBoolean(isNull);
        if (isNull) {
            return;
        }
        SanityManager.ASSERT((!this.isNull() ? 1 : 0) != 0);
        out.writeLong(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        boolean isNull = in.readBoolean();
        if (isNull) {
            this.setToNull();
            return;
        }
        this.value = in.readLong();
        this.isnull = false;
    }

    @Override
    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        this.value = in.readLong();
        this.isnull = false;
    }

    @Override
    public void restoreToNull() {
        this.value = 0L;
        this.isnull = true;
    }

    @Override
    protected int typeCompare(DataValueDescriptor arg) throws StandardException {
        long otherValue;
        long thisValue = this.getLong();
        if (thisValue == (otherValue = arg.getLong())) {
            return 0;
        }
        if (thisValue > otherValue) {
            return 1;
        }
        return -1;
    }

    @Override
    public DataValueDescriptor getClone() {
        return new SQLLongint(this.value, this.isnull);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLLongint();
    }

    @Override
    public void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException {
        this.value = resultSet.getLong(colNumber);
        this.isnull = this.value == 0L ? isNullable && resultSet.wasNull() : false;
    }

    @Override
    public final void setInto(PreparedStatement ps, int position) throws SQLException {
        if (this.isNull()) {
            ps.setNull(position, -5);
            return;
        }
        ps.setLong(position, this.value);
    }

    @Override
    public final void setInto(ResultSet rs, int position) throws SQLException {
        rs.updateLong(position, this.value);
    }

    public SQLLongint() {
        this.isnull = true;
    }

    public SQLLongint(long val) {
        this.value = val;
    }

    private SQLLongint(long val, boolean isnull) {
        this.value = val;
        this.isnull = isnull;
    }

    public SQLLongint(Long obj) {
        this.isnull = obj == null;
        if (!this.isnull) {
            this.value = obj;
        }
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        if (theValue == null) {
            this.value = 0L;
            this.isnull = true;
        } else {
            try {
                this.value = Long.valueOf(theValue.trim());
            }
            catch (NumberFormatException nfe) {
                throw this.invalidFormat();
            }
            this.isnull = false;
        }
    }

    @Override
    public final void setValue(Number theValue) {
        if (this.objectNull(theValue)) {
            return;
        }
        if (!(theValue instanceof Long)) {
            SanityManager.THROWASSERT((String)("SQLLongint.setValue(Number) passed a " + theValue.getClass()));
        }
        this.setValue(theValue.longValue());
    }

    @Override
    public void setValue(long theValue) {
        this.value = theValue;
        this.isnull = false;
    }

    @Override
    public void setValue(int theValue) {
        this.value = theValue;
        this.isnull = false;
    }

    @Override
    public void setValue(float theValue) throws StandardException {
        if ((theValue = NumberDataType.normalizeREAL(theValue)) > 9.223372E18f || theValue < -9.223372E18f) {
            throw StandardException.newException("22003", (Object)"BIGINT", (Object)null);
        }
        float floorValue = (float)Math.floor(theValue);
        this.value = (long)floorValue;
        this.isnull = false;
    }

    @Override
    public void setValue(double theValue) throws StandardException {
        if ((theValue = NumberDataType.normalizeDOUBLE(theValue)) > 9.223372036854776E18 || theValue < -9.223372036854776E18) {
            throw StandardException.newException("22003", (Object)"BIGINT", (Object)null);
        }
        double floorValue = Math.floor(theValue);
        this.value = (long)floorValue;
        this.isnull = false;
    }

    @Override
    public void setValue(boolean theValue) {
        this.value = theValue ? 1L : 0L;
        this.isnull = false;
    }

    @Override
    void setObject(Object theValue) {
        this.setValue((Long)theValue);
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        this.setValue(theValue.getLong());
    }

    @Override
    public int typePrecedence() {
        return 60;
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getLong() == right.getLong());
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getLong() != right.getLong());
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getLong() < right.getLong());
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getLong() > right.getLong());
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getLong() <= right.getLong());
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        return SQLBoolean.truthValue(left, right, left.getLong() >= right.getLong());
    }

    @Override
    public NumberDataValue plus(NumberDataValue addend1, NumberDataValue addend2, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLLongint();
        }
        if (addend1.isNull() || addend2.isNull()) {
            result.setToNull();
            return result;
        }
        long addend1Long = addend1.getLong();
        long addend2Long = addend2.getLong();
        long resultValue = addend1Long + addend2Long;
        if (addend1Long < 0L == addend2Long < 0L && addend1Long < 0L != resultValue < 0L) {
            throw StandardException.newException("22003", (Object)"BIGINT", (Object)null);
        }
        result.setValue(resultValue);
        return result;
    }

    @Override
    public NumberDataValue minus(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLLongint();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        long diff = left.getLong() - right.getLong();
        if (left.getLong() < 0L != right.getLong() < 0L && left.getLong() < 0L != diff < 0L) {
            throw StandardException.newException("22003", (Object)"BIGINT", (Object)null);
        }
        result.setValue(diff);
        return result;
    }

    @Override
    public NumberDataValue times(NumberDataValue left, NumberDataValue right, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLLongint();
        }
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        long tempResult = left.getLong() * right.getLong();
        if (right.getLong() != 0L && left.getLong() != tempResult / right.getLong()) {
            throw StandardException.newException("22003", (Object)"BIGINT", (Object)null);
        }
        result.setValue(tempResult);
        return result;
    }

    @Override
    public NumberDataValue divide(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLLongint();
        }
        if (dividend.isNull() || divisor.isNull()) {
            result.setToNull();
            return result;
        }
        long longDivisor = divisor.getLong();
        if (longDivisor == 0L) {
            throw StandardException.newException("22012");
        }
        result.setValue(dividend.getLong() / longDivisor);
        return result;
    }

    @Override
    public NumberDataValue mod(NumberDataValue dividend, NumberDataValue divisor, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLLongint();
        }
        if (dividend.isNull() || divisor.isNull()) {
            result.setToNull();
            return result;
        }
        long longDivisor = divisor.getLong();
        if (longDivisor == 0L) {
            throw StandardException.newException("22012");
        }
        result.setValue(dividend.getLong() % longDivisor);
        return result;
    }

    @Override
    public NumberDataValue minus(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLLongint();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        long operandValue = this.getLong();
        if (operandValue == Long.MIN_VALUE) {
            throw StandardException.newException("22003", (Object)"BIGINT", (Object)null);
        }
        result.setValue(-operandValue);
        return result;
    }

    @Override
    protected boolean isNegative() {
        return !this.isNull() && this.value < 0L;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Long.toString(this.value);
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    @Override
    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        if (!this.isNull()) {
            out.writeByte(this.getTypeId());
            InternalDataSerializer.writeSignedVL((long)this.value, (DataOutput)out);
            return;
        }
        this.writeNullDVD(out);
    }

    @Override
    public final void fromDataForOptimizedResultHolder(DataInput dis) throws IOException, ClassNotFoundException {
        Version version = InternalDataSerializer.getVersionForDataStream((DataInput)dis);
        this.value = Version.SQLF_1099.compareTo(version) <= 0 ? InternalDataSerializer.readSignedVL((DataInput)dis) : StatArchiveWriter.readCompactValue((DataInput)dis);
        this.isnull = false;
    }

    @Override
    public final void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
        assert (!this.isNull());
        InternalDataSerializer.writeSignedVL((long)this.value, (DataOutput)dos);
    }

    @Override
    public int writeBytes(byte[] outBytes, int offset, DataTypeDescriptor dtd) {
        return RowFormatter.writeLong(outBytes, this.value, offset);
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        assert (columnWidth == 8) : columnWidth;
        this.value = RowFormatter.readLong(inBytes, offset);
        this.isnull = false;
        return 8;
    }

    @Override
    public int readBytes(long memOffset, int columnWidth, ByteSource bs) {
        assert (columnWidth == 8) : columnWidth;
        this.value = RowFormatter.readLong(memOffset);
        this.isnull = false;
        return 8;
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        assert (!this.isNull());
        return ResolverUtils.addLongToBucketHash((long)this.value, (int)hash, (int)this.getTypeFormatId());
    }

    @Override
    public byte getTypeId() {
        return 58;
    }
}

