/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.store.access;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.BackingStoreHashtable;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowSource;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import java.util.Arrays;

public class NcjBackingStoreHashtable
extends BackingStoreHashtable {
    final int batchSize;
    private boolean moreRowsExpected;

    public NcjBackingStoreHashtable(TransactionController tc, RowSource row_source, int[] key_column_numbers, boolean remove_duplicates, long estimated_rowcnt, long max_inmemory_rowcnt, int initialCapacity, float loadFactor, boolean skipNullKeyColumns, boolean keepAfterCommit, int batchSize) throws StandardException {
        super(tc, row_source, key_column_numbers, remove_duplicates, estimated_rowcnt, max_inmemory_rowcnt, initialCapacity, loadFactor, skipNullKeyColumns, keepAfterCommit, false);
        this.batchSize = batchSize <= 0 ? Integer.MAX_VALUE : batchSize;
        this.fillUpHashTable();
    }

    @Override
    public boolean fillUpHashTable() throws StandardException {
        Object[] row;
        this.moreRowsExpected = false;
        this.assertHashTableNotNull();
        SanityManager.ASSERT((this.row_source != null ? 1 : 0) != 0);
        boolean needsToClone = this.row_source.needsToClone();
        int row_count = 0;
        while ((row = this.getNextRowFromRowSource()) != null) {
            if (GemFireXDUtils.TraceNCJIter) {
                SanityManager.DEBUG_PRINT((String)"TraceNCJIter", (String)("NcjBackingStoreHashTable::fillUpHashTable() calling add_row_to_hash_table for row = " + Arrays.toString(row) + ", row_count: " + row_count));
            }
            this.add_row_to_hash_table((DataValueDescriptor[])row, needsToClone, null);
            if (++row_count < this.batchSize) continue;
            this.moreRowsExpected = true;
            break;
        }
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("NcjBackingStoreHashTable::fillUpHashTable() calling add_row_to_hash_table.  batchSize: " + this.batchSize + ", needsToclone: " + needsToClone + ", row_count: " + row_count + ", moreRowsExpected: " + this.moreRowsExpected));
        }
        return row_count > 0;
    }

    @Override
    public boolean moreRowsExpected() {
        return this.moreRowsExpected;
    }
}

