/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConglomerateDescriptorList
extends CopyOnWriteArrayList {
    public ConglomerateDescriptor getConglomerateDescriptor(long conglomerateNumber) {
        ConglomerateDescriptor returnValue = null;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ConglomerateDescriptor conglomerateDescriptor = (ConglomerateDescriptor)this.get(index);
            if (conglomerateNumber != conglomerateDescriptor.getConglomerateNumber()) continue;
            returnValue = conglomerateDescriptor;
            break;
        }
        return returnValue;
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(long conglomerateNumber) {
        int size = this.size();
        int j = 0;
        ConglomerateDescriptor[] draft = new ConglomerateDescriptor[size];
        for (int index = 0; index < size; ++index) {
            ConglomerateDescriptor conglomerateDescriptor = (ConglomerateDescriptor)this.get(index);
            if (conglomerateNumber != conglomerateDescriptor.getConglomerateNumber()) continue;
            draft[j++] = conglomerateDescriptor;
        }
        if (j == size) {
            return draft;
        }
        ConglomerateDescriptor[] returnValue = new ConglomerateDescriptor[j];
        for (int i = 0; i < j; ++i) {
            returnValue[i] = draft[i];
        }
        return returnValue;
    }

    public ConglomerateDescriptor getConglomerateDescriptor(String conglomerateName) {
        ConglomerateDescriptor returnValue = null;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ConglomerateDescriptor conglomerateDescriptor = (ConglomerateDescriptor)this.get(index);
            if (!conglomerateName.equals(conglomerateDescriptor.getConglomerateName())) continue;
            returnValue = conglomerateDescriptor;
            break;
        }
        return returnValue;
    }

    public ConglomerateDescriptor getConglomerateDescriptor(UUID uuid) throws StandardException {
        ConglomerateDescriptor returnValue = null;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ConglomerateDescriptor conglomerateDescriptor = (ConglomerateDescriptor)this.get(index);
            if (!uuid.equals(conglomerateDescriptor.getUUID())) continue;
            returnValue = conglomerateDescriptor;
            break;
        }
        return returnValue;
    }

    public ConglomerateDescriptor[] getConglomerateDescriptors(UUID uuid) {
        int size = this.size();
        int j = 0;
        ConglomerateDescriptor[] draft = new ConglomerateDescriptor[size];
        for (int index = 0; index < size; ++index) {
            ConglomerateDescriptor conglomerateDescriptor = (ConglomerateDescriptor)this.get(index);
            if (!uuid.equals(conglomerateDescriptor.getUUID())) continue;
            draft[j++] = conglomerateDescriptor;
        }
        if (j == size) {
            return draft;
        }
        ConglomerateDescriptor[] returnValue = new ConglomerateDescriptor[j];
        for (int i = 0; i < j; ++i) {
            returnValue[i] = draft[i];
        }
        return returnValue;
    }

    public void dropConglomerateDescriptor(UUID tableID, ConglomerateDescriptor cgDesc) throws StandardException {
        for (ConglomerateDescriptor localCgDesc : this) {
            if (localCgDesc.getConglomerateNumber() != cgDesc.getConglomerateNumber() || !localCgDesc.getConglomerateName().equals(cgDesc.getConglomerateName()) || !localCgDesc.getSchemaID().equals(cgDesc.getSchemaID())) continue;
            this.remove(localCgDesc);
            break;
        }
    }

    public void dropConglomerateDescriptorByUUID(UUID conglomerateID) throws StandardException {
        for (ConglomerateDescriptor localCgDesc : this) {
            if (!conglomerateID.equals(localCgDesc.getUUID())) continue;
            this.remove(localCgDesc);
            break;
        }
    }
}

