/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.catalog.DependableFinder;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.PermissionsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DDdependableFinder;

public class ColPermsDescriptor
extends PermissionsDescriptor {
    private UUID tableUUID;
    private String type;
    private FormatableBitSet columns;
    private String tableName;

    public ColPermsDescriptor(DataDictionary dd, String grantee, String grantor, UUID tableUUID, String type, FormatableBitSet columns) throws StandardException {
        super(dd, grantee, grantor);
        this.tableUUID = tableUUID;
        this.type = type;
        this.columns = columns;
        if (tableUUID != null) {
            this.tableName = dd.getTableDescriptor(tableUUID).getName();
        }
    }

    public ColPermsDescriptor(DataDictionary dd, String grantee, String grantor, UUID tableUUID, String type) throws StandardException {
        this(dd, grantee, grantor, tableUUID, type, null);
    }

    public ColPermsDescriptor(DataDictionary dd, UUID colPermsUUID) throws StandardException {
        super(dd, null, null);
        this.oid = colPermsUUID;
    }

    @Override
    public int getCatalogNumber() {
        return 17;
    }

    public UUID getTableUUID() {
        return this.tableUUID;
    }

    public String getType() {
        return this.type;
    }

    public FormatableBitSet getColumns() {
        return this.columns;
    }

    public String toString() {
        return "colPerms: grantee=" + this.getGrantee() + ",colPermsUUID=" + this.getUUID() + ",grantor=" + this.getGrantor() + ",tableUUID=" + this.getTableUUID() + ",type=" + this.getType() + ",columns=" + this.getColumns();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ColPermsDescriptor)) {
            return false;
        }
        ColPermsDescriptor otherColPerms = (ColPermsDescriptor)other;
        return super.keyEquals(otherColPerms) && this.tableUUID.equals(otherColPerms.tableUUID) && (this.type == null ? otherColPerms.type == null : this.type.equals(otherColPerms.type));
    }

    public int hashCode() {
        return super.keyHashCode() + this.tableUUID.hashCode() + (this.type == null ? 0 : this.type.hashCode());
    }

    @Override
    public boolean checkOwner(String authorizationId) throws StandardException {
        SchemaDescriptor sd = this.getDataDictionary().getTableDescriptor(this.tableUUID).getSchemaDescriptor();
        String schemaOwner = sd.getAuthorizationId();
        return schemaOwner.equals(authorizationId) || Misc.checkLDAPGroupOwnership(sd.getSchemaName(), schemaOwner, authorizationId);
    }

    @Override
    public String getObjectName() {
        return "Column Privilege on " + this.tableName;
    }

    @Override
    public String getClassType() {
        return "ColumnsPrivilege";
    }

    @Override
    public DependableFinder getDependableFinder() {
        return new DDdependableFinder(463);
    }
}

