/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.sql;

import com.gemstone.gnu.trove.THashMap;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.compile.Token;
import com.pivotal.gemfirexd.internal.engine.sql.execute.ConstantValueSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericStatement;
import com.pivotal.gemfirexd.internal.impl.sql.conn.GenericLanguageConnectionContext;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.util.List;

public final class GeneralizedStatement
extends GenericStatement {
    public static final String CONSTANT_PLACEHOLDER = "<?>";

    public GeneralizedStatement(SchemaDescriptor compilationSchema, String statementText, short execFlags, THashMap ncjMetaData) {
        super(compilationSchema, statementText, execFlags, ncjMetaData);
    }

    public void setPreparedStatement(GenericPreparedStatement ps) {
        this.preparedStmt = ps;
    }

    public void setSource(String sqlText, boolean createQueryInfo, SchemaDescriptor compilationSchema, CompilerContext cc) {
        this.statementText = sqlText;
        this.execFlags = createQueryInfo ? GemFireXDUtils.set(this.execFlags, (short)2) : GemFireXDUtils.clear(this.execFlags, (short)2);
        this.compilationSchema = compilationSchema;
        this.hash = this.getHashCode();
    }

    @Override
    public String getQueryStringForParse(LanguageConnectionContext lcc) {
        return GeneralizedStatement.recreateUserQuery(this.statementText, (ConstantValueSet)lcc.getConstantValueSet(null));
    }

    public void reset() {
        this.statementText = null;
        this.execFlags = GemFireXDUtils.clear(this.execFlags, (short)2);
        this.compilationSchema = null;
        this.hash = -1;
    }

    public String restoreOriginalString(GenericLanguageConnectionContext lcc) throws StandardException {
        ConstantValueSet constants = (ConstantValueSet)lcc.getConstantValueSet(null);
        if (constants == null) {
            SanityManager.THROWASSERT((String)"Cannot restore original string as no constantValueSet is available yet");
        }
        return GeneralizedStatement.recreateUserQuery(this.statementText, constants);
    }

    public static String recreateUserQuery(String sql, ConstantValueSet constants) {
        int index = sql.indexOf(CONSTANT_PLACEHOLDER, 0);
        int constantIdx = 0;
        int len = 0;
        if (constants != null) {
            len = constants.getParameterCount();
        }
        while (index != -1 && index < sql.length() && constantIdx < len) {
            sql = sql.substring(0, index) + constants.getConstantImage(constantIdx) + sql.substring(index + CONSTANT_PLACEHOLDER.length());
            index = sql.indexOf(CONSTANT_PLACEHOLDER, index + 1);
            ++constantIdx;
        }
        if (GemFireXDUtils.TraceStatementMatching) {
            SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)("returning restored user query " + sql));
        }
        return sql;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof GeneralizedStatement)) {
            return false;
        }
        GeneralizedStatement _this = this;
        GeneralizedStatement os = (GeneralizedStatement)other;
        return _this.isEquivalent(os) && _this.isForReadOnly() == os.isForReadOnly() && _this.compilationSchema.equals(os.compilationSchema) && _this.createQueryInfo() == os.createQueryInfo() && _this.prepareIsolationLevel == os.prepareIsolationLevel;
    }

    private boolean isEquivalent(GeneralizedStatement other) {
        if (this == other) {
            return true;
        }
        String thisstmt = this.statementText;
        String otherstmt = other.statementText;
        String strmsg = GemFireXDUtils.TraceStatementMatching ? "lhs=[" + thisstmt + "] rhs=[" + otherstmt + "]  this=" + this + "  other=" + other : null;
        if (thisstmt == null || otherstmt == null) {
            SanityManager.THROWASSERT(strmsg == null ? "lhs=" + this + " rhs=" + other : strmsg);
        }
        boolean isequal = thisstmt.equals(otherstmt);
        return isequal;
    }

    private final int getHashCode() {
        int h;
        String stmt = this.statementText;
        assert (!this.isPreparedStatement() && this.isOptimizedStatement());
        this.stmtHash = h = super.getHashCode(0, stmt.length(), 0);
        h = ResolverUtils.addIntToHash((int)(this.createQueryInfo() ? 1231 : 1237), (int)h);
        return ResolverUtils.addIntToHash((int)(this.isPreparedStatement() || !this.isOptimizedStatement() ? 19531 : 20161), (int)h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        boolean isCompiling;
        String st;
        GeneralizedStatement generalizedStatement = this;
        synchronized (generalizedStatement) {
            st = this.statementText;
            isCompiling = true;
        }
        return GemFireXDUtils.addressOf(this) + (!isCompiling ? ' ' + st : " compilingQuery=" + this.statementText + " genericQuery=" + st);
    }

    public static String generalizedStatement(String statementText, List<Token> constantTokenList) {
        assert (constantTokenList != null);
        StringBuilder generalizedStmtStr = new StringBuilder(statementText.length());
        if (constantTokenList.size() != 0) {
            int startPos = 0;
            for (Token v : constantTokenList) {
                int beginC = v.beginOffset;
                String str = statementText.substring(startPos, beginC);
                startPos = v.endOffset;
                generalizedStmtStr.append(str).append(CONSTANT_PLACEHOLDER);
            }
            int cLen = statementText.length();
            if (startPos < cLen) {
                String str = statementText.substring(startPos, cLen);
                generalizedStmtStr.append(str);
            }
        }
        if (GemFireXDUtils.TraceStatementMatching) {
            SanityManager.DEBUG_PRINT((String)"StatementMatching", (String)("returning generalizedStmt " + generalizedStmtStr.toString()));
        }
        return generalizedStmtStr.toString();
    }
}

