/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.message;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.AbstractDiskRegion;
import com.gemstone.gemfire.internal.cache.DiskInitFile;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.RegionEntry;
import com.gemstone.gemfire.internal.cache.persistence.PRPersistentConfig;
import com.gemstone.gemfire.internal.cache.versions.RegionVersionVector;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.DDLConflatable;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PersistentStateInRecoveryMode {
    private InternalDistributedMember member = null;
    private final ArrayList<RecoveryModePersistentView> allRegionView = new ArrayList();
    private final ArrayList<Object> catalogObjects = new ArrayList();
    private ArrayList<String> otherExtractedDDLText = new ArrayList();
    private final HashMap<String, Integer> prToNumBuckets = new HashMap();
    private HashSet<String> replicatedRegions = new HashSet();
    private boolean isServer;

    public PersistentStateInRecoveryMode(List<Object> allEntries, List<DDLConflatable> extractedDDLs) {
        this.member = Misc.getMyId();
        if (allEntries != null && !allEntries.isEmpty()) {
            this.catalogObjects.addAll(allEntries);
        }
        if (extractedDDLs != null && !extractedDDLs.isEmpty()) {
            extractedDDLs.forEach(x -> this.otherExtractedDDLText.add(x.getValueToConflate()));
        }
        this.isServer = Misc.getMemStore().getMyVMKind().isStore();
    }

    public PersistentStateInRecoveryMode(InternalDistributedMember member, ArrayList<RecoveryModePersistentView> allRegionView, ArrayList<Object> catalogObjects, ArrayList<String> otherExtractedDDLText, HashMap<String, Integer> prToNumBuckets, HashSet<String> replicatedRegions, boolean isServer) {
        this.member = member;
        this.allRegionView.addAll(allRegionView);
        this.catalogObjects.addAll(catalogObjects);
        this.otherExtractedDDLText.addAll(otherExtractedDDLText);
        this.prToNumBuckets.putAll(prToNumBuckets);
        this.replicatedRegions = replicatedRegions;
        this.isServer = isServer;
    }

    public PersistentStateInRecoveryMode() {
    }

    public void addView(RecoveryModePersistentView v) {
        this.allRegionView.add(v);
    }

    public void addPRConfigs() {
        GemFireCacheImpl cache = Misc.getGemFireCache();
        Collection diskStores = cache.listDiskStores();
        for (DiskStoreImpl ds : diskStores) {
            String dsName = ds.getName();
            if (dsName.equals("GFXD-DD-DISKSTORE") && !dsName.equals("SNAPPY-INTERNAL-DELTA") && !dsName.endsWith("-SNAPPY-DELTA")) continue;
            DiskInitFile dif = ds.getDiskInitFile();
            Map prConfigs = dif.getAllPRs();
            for (Map.Entry e : prConfigs.entrySet()) {
                this.prToNumBuckets.put((String)e.getKey(), ((PRPersistentConfig)e.getValue()).getTotalNumBuckets());
            }
            HashSet<String> diskRegionNames = new HashSet<String>();
            for (AbstractDiskRegion adr : ds.getAllDiskRegions().values()) {
                if (adr.isBucket()) continue;
                diskRegionNames.add(adr.getFullPath());
            }
            this.replicatedRegions.addAll(diskRegionNames);
        }
    }

    public ArrayList<RecoveryModePersistentView> getAllRegionViews() {
        return this.allRegionView;
    }

    public InternalDistributedMember getMember() {
        return this.member;
    }

    public Boolean isServer() {
        return this.isServer;
    }

    public ArrayList<String> getOtherDDLs() {
        return this.otherExtractedDDLText;
    }

    public ArrayList<Object> getCatalogObjects() {
        return this.catalogObjects;
    }

    public HashMap<String, Integer> getPrToNumBuckets() {
        return this.prToNumBuckets;
    }

    public HashSet<String> getReplicatedRegions() {
        return this.replicatedRegions;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("member: ");
        sb.append(this.member);
        sb.append("\n");
        sb.append("RecoveryModePersistentView objects");
        for (RecoveryModePersistentView recoveryModePersistentView : this.allRegionView) {
            sb.append(recoveryModePersistentView);
            sb.append("\n");
        }
        sb.append("prToNumBuckets:");
        for (Map.Entry entry : this.prToNumBuckets.entrySet()) {
            sb.append("\nbucket: " + (String)entry.getKey() + " ::: numBuckets: " + entry.getValue());
        }
        sb.append("\n");
        sb.append("replicatedRegions\n");
        sb.append(this.replicatedRegions);
        sb.append("\n");
        sb.append("Catalog Objects\n");
        for (Object object : this.catalogObjects) {
            sb.append(object);
            sb.append("\n");
        }
        sb.append("Other Extracted ddls\n");
        for (String string : this.otherExtractedDDLText) {
            sb.append(string);
            sb.append("\n");
        }
        return sb.toString();
    }

    public static long getLatestModifiedTime(AbstractDiskRegion adr) {
        Optional rmax = adr.getRecoveredEntryMap().regionEntries().stream().max((t1, t2) -> {
            if (t1.getLastModified() <= t2.getLastModified()) {
                return -1;
            }
            return 1;
        });
        assert (rmax.isPresent());
        return ((RegionEntry)rmax.get()).getLastModified();
    }

    public static class RecoveryModePersistentViewPair
    implements Comparable<RecoveryModePersistentViewPair> {
        private RecoveryModePersistentView rowView = null;
        private RecoveryModePersistentView colView = null;

        public RecoveryModePersistentView getRowView() {
            return this.rowView;
        }

        public RecoveryModePersistentView getColView() {
            return this.colView;
        }

        public RecoveryModePersistentViewPair(RecoveryModePersistentView rowView, RecoveryModePersistentView colView) {
            this.rowView = rowView;
            this.colView = colView;
        }

        public String toString() {
            String theString = "RecoveryModePersistentViewPair\nROW VIEW: " + this.getRowView() + "\nCOL VIEW: " + this.getColView();
            return theString;
        }

        @Override
        public int compareTo(RecoveryModePersistentViewPair other) {
            this.log("Comparing RecoveryModePersistentViewPairs :::\nthis view: " + this + "\n other view: " + other);
            RecoveryModePersistentView thisRowView = this.getRowView();
            RecoveryModePersistentView thisColView = this.getColView();
            RecoveryModePersistentView otherRowView = other.getRowView();
            RecoveryModePersistentView otherColView = other.getColView();
            if (thisRowView.mostRecentEntryModifiedTime == otherRowView.mostRecentEntryModifiedTime && thisRowView.latestOplogTime == otherRowView.latestOplogTime && Objects.equals(thisRowView.regionPath, otherRowView.regionPath) && Objects.equals(thisRowView.diskStoreName, otherRowView.diskStoreName) && thisRowView.rvv.sameAs(otherRowView.rvv) && thisRowView.member.equals(otherRowView.member) && (thisColView.mostRecentEntryModifiedTime == otherColView.mostRecentEntryModifiedTime && thisColView.latestOplogTime == otherColView.latestOplogTime && Objects.equals(thisColView.regionPath, otherColView.regionPath) && Objects.equals(thisColView.diskStoreName, otherColView.diskStoreName) && thisColView.rvv.sameAs(otherColView.rvv) && thisColView.member.equals(otherColView.member) || thisColView == null && otherColView == null)) {
                this.log("Comparing same object. Doesn't make sense to do this. Please check debug logs.");
                return 0;
            }
            int compareValue = this.getCompareValue(thisRowView, thisColView, otherRowView, otherColView);
            return compareValue;
        }

        void log(String str) {
            if (GemFireXDUtils.TraceRecoveryMode) {
                SanityManager.DEBUG_PRINT((String)"TraceRecoveryMode", (String)str);
            }
        }

        private int getCompareValue(RecoveryModePersistentView thisRowView, RecoveryModePersistentView thisColView, RecoveryModePersistentView otherRowView, RecoveryModePersistentView otherColView) {
            boolean rowAndColLatestEntryModifiedTimeIsSame;
            if (thisColView == null || otherColView == null) {
                int retVal = new RecoveryModePersistentView(thisRowView).compareTo(otherRowView);
                this.log("Row table: return value = " + retVal);
                return retVal;
            }
            boolean otherRowDominates = otherRowView.rvv.dominates(thisRowView.rvv);
            boolean otherColDominates = otherColView.rvv.dominates(thisColView.rvv);
            boolean thisRowDominates = thisRowView.rvv.dominates(otherRowView.rvv);
            boolean thisColDominates = thisColView.rvv.dominates(otherColView.rvv);
            this.log("thisRowView Dominates otherRowView: " + thisRowView.rvv.dominates(otherRowView.rvv));
            this.log("otherRowView Dominates thisRowView: " + otherRowView.rvv.dominates(thisRowView.rvv));
            this.log("thisColView Dominates otherColView: " + thisColView.rvv.dominates(otherColView.rvv));
            this.log("otherColView Dominates thisColView: " + otherColView.rvv.dominates(thisColView.rvv));
            boolean isRVVNotUsable = thisRowDominates == otherRowDominates && otherColDominates == thisColDominates || thisRowDominates != otherRowDominates && otherColDominates != thisColDominates;
            boolean bl = rowAndColLatestEntryModifiedTimeIsSame = thisColView.mostRecentEntryModifiedTime == otherColView.mostRecentEntryModifiedTime && thisRowView.mostRecentEntryModifiedTime == otherRowView.mostRecentEntryModifiedTime;
            if (isRVVNotUsable) {
                this.log("RVV based approach is not usable.");
                if (rowAndColLatestEntryModifiedTimeIsSame) {
                    int retVal = this.compareTime(thisColView.getLatestOplogTime(), otherColView.getLatestOplogTime(), thisRowView.getLatestOplogTime(), otherRowView.getLatestOplogTime());
                    this.log("Decide on basis of LatestOplogTime: return value = " + retVal);
                    return retVal;
                }
                int retVal = this.compareTime(thisColView.getMostRecentEntryModifiedTime(), otherColView.getMostRecentEntryModifiedTime(), thisRowView.getMostRecentEntryModifiedTime(), otherRowView.getMostRecentEntryModifiedTime());
                this.log("Decide on basis of MostRecentEntryModifiedTime: return value = " + retVal);
                return retVal;
            }
            if (thisColDominates == otherColDominates) {
                return thisRowDominates ? 1 : -1;
            }
            if (thisRowDominates == otherRowDominates) {
                return thisColDominates ? 1 : -1;
            }
            return thisColDominates && thisRowDominates ? 1 : -1;
        }

        private int compareTime(Long thisColViewTime, Long otherColViewTime, Long thisRowViewTime, Long otherRowViewTime) {
            if (thisColViewTime > otherColViewTime && thisRowViewTime >= otherRowViewTime || thisColViewTime == otherColViewTime && thisRowViewTime > otherRowViewTime) {
                return 1;
            }
            return -1;
        }
    }

    public static class RecoveryModePersistentView
    implements Comparable<RecoveryModePersistentView>,
    DataSerializable {
        private String regionPath;
        private String diskStoreName;
        private transient RegionVersionVector rvv;
        private long mostRecentEntryModifiedTime;
        private long latestOplogTime;
        private transient InternalDistributedMember member;

        public void setMember(InternalDistributedMember member) {
            this.member = member;
        }

        public RecoveryModePersistentView(String diskStoreName, String regionFullPath, RegionVersionVector regionVersionVector, long recentModifiedTime, long latestOplogTime) {
            this.regionPath = regionFullPath;
            this.diskStoreName = diskStoreName;
            this.rvv = regionVersionVector.getCloneForTransmission();
            this.mostRecentEntryModifiedTime = recentModifiedTime;
            this.latestOplogTime = latestOplogTime;
        }

        public RecoveryModePersistentView() {
        }

        public RecoveryModePersistentView(RecoveryModePersistentView view) {
            this.member = view.getMember();
            this.regionPath = view.getRegionPath();
            this.diskStoreName = view.getDiskStoreName();
            this.rvv = view.getRvv().getCloneForTransmission();
            this.mostRecentEntryModifiedTime = view.getMostRecentEntryModifiedTime();
            this.latestOplogTime = view.getLatestOplogTime();
        }

        public long getMostRecentEntryModifiedTime() {
            return this.mostRecentEntryModifiedTime;
        }

        public long getLatestOplogTime() {
            return this.latestOplogTime;
        }

        public RegionVersionVector getRvv() {
            return this.rvv;
        }

        public String getRegionPath() {
            return this.regionPath;
        }

        public InternalDistributedMember getMember() {
            return this.member;
        }

        public String getExecutorHost() {
            return this.member.canonicalString();
        }

        public String getDiskStoreName() {
            return this.diskStoreName;
        }

        public void toData(DataOutput out) throws IOException {
            out.writeUTF(this.regionPath);
            out.writeUTF(this.diskStoreName);
            DataSerializer.writeObject((Object)this.rvv, (DataOutput)out);
            DataSerializer.writeLong((Long)this.mostRecentEntryModifiedTime, (DataOutput)out);
            DataSerializer.writeLong((Long)this.latestOplogTime, (DataOutput)out);
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.regionPath = in.readUTF();
            this.diskStoreName = in.readUTF();
            this.rvv = (RegionVersionVector)DataSerializer.readObject((DataInput)in);
            this.mostRecentEntryModifiedTime = DataSerializer.readLong((DataInput)in);
            this.latestOplogTime = DataSerializer.readLong((DataInput)in);
        }

        public String toString() {
            String sb = "RecoveryModePersistentView member: " + this.member + ": region: " + this.regionPath + ": latestOplogTime:" + this.latestOplogTime + ": mostRecentEntryModifiedTime:" + this.mostRecentEntryModifiedTime + ": rvv:" + this.rvv + ": diskStoreName:" + this.diskStoreName;
            return sb;
        }

        void log(String str) {
            if (GemFireXDUtils.TraceRecoveryMode) {
                SanityManager.DEBUG_PRINT((String)"TraceRecoveryMode", (String)str);
            }
        }

        @Override
        public int compareTo(RecoveryModePersistentView other) {
            this.log("Comparing RecoveryModePersistentViews :::\nthis view: " + this + "\n other view: " + other);
            assert (this.regionPath.equals(other.regionPath));
            if (this.mostRecentEntryModifiedTime == other.mostRecentEntryModifiedTime && this.latestOplogTime == other.latestOplogTime && Objects.equals(this.regionPath, other.regionPath) && Objects.equals(this.diskStoreName, other.diskStoreName) && this.rvv.sameAs(other.rvv) && this.member.equals(other.member)) {
                this.log("Comparing same object. Doesn't make sense to do this. Please check.");
                return 0;
            }
            if (this.rvv.logicallySameAs(other.rvv) || !this.rvv.dominates(other.rvv) && !other.rvv.dominates(this.rvv)) {
                this.log("Both dominate each other?" + this.rvv.logicallySameAs(other.rvv));
                this.log("Both don't dominate each other?" + (!this.rvv.dominates(other.rvv) && !other.rvv.dominates(this.rvv)));
                this.log("RVV based approach is not usable.");
                if (this.mostRecentEntryModifiedTime < other.mostRecentEntryModifiedTime) {
                    this.log("Deciding on basis of Modified entry time: return -1");
                    return -1;
                }
                if (this.mostRecentEntryModifiedTime > other.mostRecentEntryModifiedTime) {
                    this.log("Deciding on basis of Modified entry time: return 1");
                    return 1;
                }
                if (this.latestOplogTime <= other.latestOplogTime) {
                    this.log("Deciding on basis of Oplog file time: return -1");
                    return -1;
                }
                this.log("Deciding on basis of Oplog file time: return 1");
                return 1;
            }
            this.log("Use RVV based approach.");
            if (this.rvv.dominates(other.rvv)) {
                this.log("RVV of LHS dominates RHS: return 1");
                return 1;
            }
            this.log("RVV of RHS dominates LHS: return -1");
            return -1;
        }
    }
}

