/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed.execution;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.shared.Version;
import com.pivotal.gemfirexd.internal.engine.distributed.DVDIOUtil;
import com.pivotal.gemfirexd.internal.engine.distributed.SnappyResultHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.execution.LeadNodeExecutionObject;
import com.pivotal.gemfirexd.internal.engine.distributed.message.BitSetSet;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDecimal;
import com.pivotal.gemfirexd.internal.impl.sql.GenericParameterValueSet;
import com.pivotal.gemfirexd.internal.snappy.CallbackFactoryProvider;
import com.pivotal.gemfirexd.internal.snappy.LeadNodeExecutionContext;
import com.pivotal.gemfirexd.internal.snappy.SparkSQLExecute;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;

public class SQLLeadNodeExecutionObject
extends LeadNodeExecutionObject {
    private String sql;
    private String schema;
    private transient byte[] pvsData;
    private transient int[] pvsTypes;
    protected ParameterValueSet pvs;
    private transient byte leadNodeFlags;
    private static final byte IS_PREPARED_STATEMENT = 1;
    private static final byte IS_PREPARED_PHASE = 2;
    private static final byte IS_UPDATE_OR_DELETE_OR_PUT = 4;

    public SQLLeadNodeExecutionObject(String sql, String schema, ParameterValueSet inpvs, boolean isPreparedStatement, boolean isPreparedPhase, Boolean isUpdateOrDeleteOrPut) {
        this.schema = schema;
        this.sql = sql;
        this.pvs = inpvs;
        if (isPreparedStatement) {
            this.leadNodeFlags = (byte)(this.leadNodeFlags | 1);
        }
        if (isPreparedPhase) {
            this.leadNodeFlags = (byte)(this.leadNodeFlags | 2);
        }
        if (isUpdateOrDeleteOrPut.booleanValue()) {
            this.leadNodeFlags = (byte)(this.leadNodeFlags | 4);
        }
    }

    public SQLLeadNodeExecutionObject() {
    }

    @Override
    public SparkSQLExecute getSparkSQlExecute(Version v, LeadNodeExecutionContext ctx, Object dfObject) throws Exception {
        if (this.isPreparedStatement() && !this.isPreparedPhase()) {
            this.getParams();
        }
        return CallbackFactoryProvider.getClusterCallbacks().getSQLExecute(dfObject, this.sql, this.schema, ctx, v, this.isPreparedStatement(), this.isPreparedPhase(), this.pvs);
    }

    public boolean isPreparedStatement() {
        return (this.leadNodeFlags & 1) != 0;
    }

    public boolean isPreparedPhase() {
        return (this.leadNodeFlags & 2) != 0;
    }

    @Override
    public boolean isUpdateOrDeleteOrPut() {
        return (this.leadNodeFlags & 4) != 0;
    }

    public ParameterValueSet getParams() throws Exception {
        if (this.pvsData != null) {
            ByteArrayDataInput dis = new ByteArrayDataInput();
            dis.initialize(this.pvsData, null);
            this.readStatementPVS(dis);
        }
        return this.pvs;
    }

    private void readStatementPVS(ByteArrayDataInput in) throws IOException, SQLException, ClassNotFoundException, StandardException {
        int numberOfParameters = this.pvsTypes[0];
        DataTypeDescriptor[] types = new DataTypeDescriptor[numberOfParameters];
        for (int i = 0; i < numberOfParameters; ++i) {
            int index = i * 3 + 1;
            SnappyResultHolder.getNewNullDVD(this.pvsTypes[index], i, types, this.pvsTypes[index + 1], this.pvsTypes[index + 2], true);
        }
        this.pvs = new GenericParameterValueSet(null, numberOfParameters, false);
        this.pvs.initialize(types);
        int paramCount = this.pvs.getParameterCount();
        int numEightColGroups = BitSetSet.udiv8(paramCount);
        int numPartialCols = BitSetSet.umod8(paramCount);
        DVDIOUtil.readParameterValueSet(this.pvs, in, numEightColGroups, numPartialCols);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.sql = DataSerializer.readString((DataInput)in);
        this.schema = DataSerializer.readString((DataInput)in);
        this.leadNodeFlags = DataSerializer.readByte((DataInput)in);
        if (this.isPreparedStatement() && !this.isPreparedPhase()) {
            this.pvsTypes = DataSerializer.readIntArray((DataInput)in);
            this.pvsData = DataSerializer.readByteArray((DataInput)in);
        }
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString((String)this.sql, (DataOutput)out);
        DataSerializer.writeString((String)this.schema, (DataOutput)out);
        DataSerializer.writeByte((Byte)this.leadNodeFlags, (DataOutput)out);
        if (this.isPreparedStatement() && !this.isPreparedPhase()) {
            int paramCount = this.pvs != null ? this.pvs.getParameterCount() : 0;
            int numEightColGroups = BitSetSet.udiv8(paramCount);
            int numPartialCols = BitSetSet.umod8(paramCount);
            try {
                if (this.pvsTypes == null) {
                    this.pvsTypes = new int[paramCount * 3 + 1];
                    this.pvsTypes[0] = paramCount;
                    for (int i = 0; i < paramCount; ++i) {
                        DataValueDescriptor dvd = this.pvs.getParameter(i);
                        this.pvsTypes[i * 3 + 1] = dvd.getTypeFormatId();
                        if (dvd instanceof SQLDecimal) {
                            this.pvsTypes[i * 3 + 2] = ((SQLDecimal)dvd).getDecimalValuePrecision();
                            this.pvsTypes[i * 3 + 3] = ((SQLDecimal)dvd).getDecimalValueScale();
                            continue;
                        }
                        this.pvsTypes[i * 3 + 2] = -1;
                        this.pvsTypes[i * 3 + 3] = -1;
                    }
                }
                DataSerializer.writeIntArray((int[])this.pvsTypes, (DataOutput)out);
                if (paramCount > 0) {
                    HeapDataOutputStream hdos = new HeapDataOutputStream();
                    DVDIOUtil.writeParameterValueSet(this.pvs, numEightColGroups, numPartialCols, (DataOutput)hdos);
                    InternalDataSerializer.writeArrayLength((int)hdos.size(), (DataOutput)out);
                    hdos.sendTo(out);
                } else {
                    InternalDataSerializer.writeArrayLength((int)-1, (DataOutput)out);
                }
            }
            catch (StandardException ex) {
                throw GemFireXDRuntimeException.newRuntimeException("unexpected exception in writing parameters", ex);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(":");
        this.appendFields(sb);
        return sb.toString();
    }

    public void appendFields(StringBuilder sb) {
        sb.append("sql: " + this.sql);
        sb.append(" ;schema: " + this.schema);
        sb.append(" ;isUpdateOrDelete=").append(this.isUpdateOrDeleteOrPut());
        sb.append(" ;isPreparedStatement=").append(this.isPreparedStatement());
        sb.append(" ;isPreparedPhase=").append(this.isPreparedPhase());
        sb.append(" ;pvs=").append(this.pvs);
        sb.append(" ;pvsData=").append(Arrays.toString(this.pvsData));
    }

    @Override
    public void reset() {
        this.pvsData = null;
        this.pvsTypes = null;
    }

    public byte getGfxdID() {
        return 117;
    }

    @Override
    public String getExceptionString() {
        return this.sql;
    }

    @Override
    public String getSql() {
        return this.sql;
    }
}

