/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.ReplyProcessor21;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollectorHelper;
import com.pivotal.gemfirexd.internal.engine.distributed.RecoveryModeResultHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.message.PersistentStateInRecoveryMode;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class RecoveryModeResultCollector
extends ArrayList<Object>
implements GfxdResultCollector<Object> {
    private HashMap<DistributedMember, ArrayList<Object>> memberNPartsMap;
    protected final GfxdResultCollectorHelper helper = new GfxdResultCollectorHelper();
    protected boolean throwException = false;

    public RecoveryModeResultCollector() {
        this.memberNPartsMap = new HashMap();
    }

    @Override
    public final Set<DistributedMember> getResultMembers() {
        return this.helper.getResultMembers();
    }

    @Override
    public final boolean setupContainersToClose(Collection<GemFireContainer> containers, GemFireTransaction tran) {
        return false;
    }

    @Override
    public GfxdResultCollectorHelper getStreamingHelper() {
        return null;
    }

    public ArrayList<Object> getResult() throws FunctionException {
        return this;
    }

    public ArrayList<Object> getResult(long timeout, TimeUnit unit) throws FunctionException {
        if (GemFireXDUtils.TraceRecoveryMode && this.throwException) {
            throw new AssertionError((Object)"unexpected Throwable ");
        }
        return this;
    }

    @Override
    public void setNumRecipients(int n) {
    }

    @Override
    public final void setResultMembers(Set<DistributedMember> members) {
        this.helper.setResultMembers(members);
    }

    @Override
    public GfxdResultCollector<Object> cloneCollector() {
        return new RecoveryModeResultCollector();
    }

    public void setProcessor(ReplyProcessor21 processor) {
    }

    public ReplyProcessor21 getProcessor() {
        return null;
    }

    public void setException(Throwable exception) {
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)(this.toString() + "#processException: from member [" + Misc.getGemFireCache().getMyId() + "] got exception"), (Throwable)exception);
        }
    }

    public void endResults() {
        assert (!this.memberNPartsMap.entrySet().isEmpty());
        for (Map.Entry<DistributedMember, ArrayList<Object>> entry : this.memberNPartsMap.entrySet()) {
            RecoveryModeResultHolder.PersistentStateInRMMetadata metadata = null;
            ArrayList<Object> allCatalogObjects = new ArrayList<Object>();
            ArrayList<String> otherExtractedDDLText = new ArrayList<String>();
            ArrayList<PersistentStateInRecoveryMode.RecoveryModePersistentView> allRegionViews = new ArrayList<PersistentStateInRecoveryMode.RecoveryModePersistentView>();
            block13: for (Object obj : entry.getValue()) {
                switch (obj.getClass().getSimpleName()) {
                    case "PersistentStateInRMMetadata": {
                        metadata = (RecoveryModeResultHolder.PersistentStateInRMMetadata)obj;
                        continue block13;
                    }
                    case "PersistentStateInRMCatalogObjectsList": {
                        allCatalogObjects.addAll(((RecoveryModeResultHolder.PersistentStateInRMCatalogObjectsList)obj).getCatalogObjects());
                        continue block13;
                    }
                    case "PersistentStateInRMOtherDDLsList": {
                        otherExtractedDDLText.addAll(((RecoveryModeResultHolder.PersistentStateInRMOtherDDLsList)obj).getOtherExtractedDDLText());
                        continue block13;
                    }
                    case "PersistentStateInRMAllRegionViews": {
                        allRegionViews.addAll(((RecoveryModeResultHolder.PersistentStateInRMAllRegionViews)obj).getAllRegionView());
                        continue block13;
                    }
                }
                SanityManager.DEBUG_PRINT((String)"TraceRecoveryMode", (String)("Found illegal object " + obj));
            }
            if (metadata == null) {
                throw new AssertionError((Object)"RecoveryModeResultCollector could not properly gather bits of PersistentStateInRecoveryMode");
            }
            InternalDistributedMember member = metadata.getMember();
            for (PersistentStateInRecoveryMode.RecoveryModePersistentView view : allRegionViews) {
                view.setMember(member);
            }
            HashMap<String, Integer> prToNumBuckets = metadata.getPrToNumBuckets();
            HashSet<String> replicatedRegions = metadata.getReplicatedRegions();
            boolean isServer = metadata.isServer();
            PersistentStateInRecoveryMode persistentStateInRecoveryMode = new PersistentStateInRecoveryMode(member, allRegionViews, allCatalogObjects, otherExtractedDDLText, prToNumBuckets, replicatedRegions, isServer);
            this.add(persistentStateInRecoveryMode);
        }
    }

    public void clearResults() {
    }

    public void addResult(DistributedMember memberID, Object resultOfSingleExecution) {
        if (GemFireXDUtils.TraceRecoveryMode && resultOfSingleExecution instanceof Throwable) {
            this.throwException = true;
            SanityManager.DEBUG_PRINT((String)"TraceRecoveryMode", (String)("RecoveryModeResultCollector received unexpected throwable in addResult from member " + memberID), (Throwable)((Throwable)resultOfSingleExecution));
        }
        assert (resultOfSingleExecution != null);
        ArrayList<Object> list = this.memberNPartsMap.get(memberID);
        if (list != null) {
            list.add(resultOfSingleExecution);
        } else {
            list = new ArrayList();
            list.add(resultOfSingleExecution);
            this.memberNPartsMap.put(memberID, list);
        }
    }
}

