/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdResultCollector;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.locks.GfxdLockSet;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;

public final class GfxdResultCollectorHelper
extends ReentrantLock {
    private static final long serialVersionUID = 5295482892857557452L;
    private Set<DistributedMember> members;
    private Collection<GemFireContainer> containersToClose;
    private GemFireTransaction tran;
    private int numRefs;

    public final void setResultMembers(Set<DistributedMember> members) {
        this.members = members;
    }

    public final Set<DistributedMember> getResultMembers() {
        return this.members;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addResultMember(DistributedMember member) {
        Set<DistributedMember> members;
        if (member != null && (members = this.members) != null) {
            Set<DistributedMember> set = members;
            synchronized (set) {
                members.add(member);
            }
        }
    }

    public final boolean setupContainersToClose(GfxdResultCollector<?> rc, Collection<GemFireContainer> containers, GemFireTransaction tran) throws StandardException {
        if (containers != null && tran != null && containers.size() > 0) {
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("GfxdResultCollectorHelper#setupContainersToClose: for ResultCollector " + rc + " setting containers: " + containers));
            }
            this.lock();
            for (GemFireContainer container : containers) {
                container.open(tran, 8);
            }
            this.containersToClose = containers;
            this.tran = tran;
            this.numRefs = 0;
            this.unlock();
            tran.getLockSpace().rcSet(rc);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeContainers(GfxdResultCollector<?> rc, boolean rcEnd) {
        this.lock();
        try {
            Collection<GemFireContainer> closeContainers = this.containersToClose;
            if (closeContainers != null) {
                if (this.removeReference()) {
                    if (GemFireXDUtils.TraceRSIter) {
                        SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("GfxdResultCollectorHelper#closeContainers: clearing ResultCollector " + rc + " and closing containers: " + closeContainers));
                    }
                    this.closeContainers(closeContainers, rc, this.tran);
                } else if (rcEnd) {
                    GfxdLockSet lockSet;
                    GemFireTransaction tran;
                    if (GemFireXDUtils.TraceRSIter) {
                        SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("GfxdResultCollectorHelper#closeContainers: force end ResultCollector " + rc));
                    }
                    if ((tran = this.tran) != null && (lockSet = tran.getLockSpace()) != null) {
                        lockSet.rcEnd(rc);
                    }
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    public final void clear(GfxdResultCollector<?> rc) {
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("GfxdResultCollectorHelper#clear: end ResultCollector " + rc));
        }
        this.lock();
        try {
            assert (this.numRefs >= 0) : "clear: unexpected numRefs=" + this.numRefs;
            if (this.numRefs > 0) {
                Collection<GemFireContainer> closeContainers = this.containersToClose;
                if (closeContainers != null) {
                    this.closeContainers(closeContainers, rc, this.tran);
                }
                this.numRefs = 0;
            }
        }
        finally {
            this.unlock();
        }
    }

    private void closeContainers(Collection<GemFireContainer> closeContainers, GfxdResultCollector<?> rc, GemFireTransaction tran) {
        assert (this.isHeldByCurrentThread()) : "closeContainers: lock not held";
        GemFireContainer container2 = null;
        try {
            for (GemFireContainer container2 : closeContainers) {
                container2.closeForEndTransaction(tran, false);
            }
            this.containersToClose = null;
            this.tran = null;
        }
        catch (RuntimeException ex) {
            LogWriter logger = Misc.getCacheLogWriter();
            logger.error("GfxdResultCollectorHelper#closeContainers: for ResultCollector " + rc + " unexpected exception in closing container " + container2, (Throwable)ex);
            throw ex;
        }
        finally {
            GfxdLockSet lockSet;
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("GfxdResultCollectorHelper#closeContainers: end ResultCollector " + rc));
            }
            if (tran != null && (lockSet = tran.getLockSpace()) != null) {
                lockSet.rcEnd(rc);
            }
        }
    }

    public final void addReference() {
        this.lock();
        ++this.numRefs;
        this.unlock();
    }

    private final boolean removeReference() {
        assert (this.isHeldByCurrentThread()) : "removeReference: lock not held";
        if (this.numRefs == 0) {
            return true;
        }
        --this.numRefs;
        return false;
    }
}

