/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.internal.InternalDataSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public final class GfxdResponseCode
implements Serializable {
    private static final long serialVersionUID = -3947107718381507844L;
    private static final int C_TIMEOUT = 0;
    private static final int C_EXCEPTION = 1;
    private static final int C_WAITING_START = 2;
    private static final int MIN_CACHED_ORD = -128;
    private static final int MAX_CACHED_ORD = 127;
    private static final GfxdResponseCode[] codeCache = new GfxdResponseCode[256];
    public static final GfxdResponseCode TIMEOUT;
    public static final GfxdResponseCode EXCEPTION;
    private final int ordinal;

    private GfxdResponseCode(int ordinal) {
        this.ordinal = ordinal;
    }

    public boolean isTimeout() {
        return this.ordinal == 0;
    }

    public boolean isException() {
        return this.ordinal == 1;
    }

    public static GfxdResponseCode WAITING(int sequenceId) {
        assert (sequenceId >= 0);
        int ordinal = sequenceId + 2;
        if (ordinal <= 127) {
            return codeCache[ordinal - -128];
        }
        return new GfxdResponseCode(ordinal);
    }

    public boolean isWaiting() {
        return this.ordinal >= 2;
    }

    public int waitingSequenceId() {
        return this.ordinal - 2;
    }

    public static GfxdResponseCode GRANT(int sequenceId) {
        assert (sequenceId > 0);
        int ordinal = -sequenceId;
        if (ordinal >= -128) {
            return codeCache[ordinal - -128];
        }
        return new GfxdResponseCode(ordinal);
    }

    public boolean isGrant() {
        return this.ordinal < 0;
    }

    public int grantedSequenceId() {
        return -this.ordinal;
    }

    public void toData(DataOutput out) throws IOException {
        InternalDataSerializer.writeUnsignedVL((long)this.ordinal, (DataOutput)out);
    }

    public static GfxdResponseCode fromData(DataInput in) throws IOException {
        int ordinal = (int)InternalDataSerializer.readUnsignedVL((DataInput)in);
        if (ordinal >= -128 && ordinal <= 127) {
            return codeCache[ordinal - -128];
        }
        return new GfxdResponseCode(ordinal);
    }

    public boolean equals(Object other) {
        if (other instanceof GfxdResponseCode) {
            return ((GfxdResponseCode)other).ordinal == this.ordinal;
        }
        return false;
    }

    public boolean equals(GfxdResponseCode other) {
        return other.ordinal == this.ordinal;
    }

    public int hashCode() {
        return this.ordinal;
    }

    public String toString() {
        switch (this.ordinal) {
            case 0: {
                return "TIMEOUT";
            }
            case 1: {
                return "EXCEPTION";
            }
        }
        if (this.isWaiting()) {
            return "WAITING[" + this.waitingSequenceId() + ']';
        }
        return "GRANT[" + this.grantedSequenceId() + ']';
    }

    static {
        for (int code = -128; code <= 127; ++code) {
            GfxdResponseCode.codeCache[code - -128] = new GfxdResponseCode(code);
        }
        TIMEOUT = codeCache[128];
        EXCEPTION = codeCache[129];
    }
}

