/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.distributed;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.pivotal.gemfirexd.internal.engine.distributed.ActiveColumnBits;
import com.pivotal.gemfirexd.internal.engine.distributed.ByteArrayDataOutput;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DVDIOUtil {
    public static void readDVDArray(DataValueDescriptor[] dvds, DataInput dis, int numEightColGrps, int numPartialCols) throws IOException, ClassNotFoundException {
        int groupNum;
        for (groupNum = 0; groupNum < numEightColGrps - 1; ++groupNum) {
            DVDIOUtil.readAGroup(groupNum, 8, dvds, dis);
        }
        DVDIOUtil.readAGroup(groupNum, numPartialCols, dvds, dis);
    }

    public static void writeDVDArray(DataValueDescriptor[] dvdArr, int numEightColGroups, int numPartialCols, DataOutput dos) throws IOException, StandardException {
        int groupNum;
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            StringBuilder sb = new StringBuilder("DVDIOUtil::writeDVDArray: writing dvd array DVD array { ");
            if (dvdArr.length > 0) {
                for (int index = 0; index < dvdArr.length; ++index) {
                    DataValueDescriptor dvd;
                    if (index > 0) {
                        sb.append(", ");
                    }
                    if ((dvd = dvdArr[index]) != null) {
                        if (RowFormatter.isLob(dvd.getTypeFormatId())) {
                            sb.append('(').append(dvd.getTypeName()).append(";length=").append(dvd.getLength()).append(";hashCode=0x").append(Integer.toHexString(dvd.hashCode())).append(')');
                            continue;
                        }
                        sb.append(dvd.toString());
                        continue;
                    }
                    sb.append("(NULL)");
                }
            }
            sb.append(" }");
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)sb.toString());
        }
        for (groupNum = 0; groupNum < numEightColGroups - 1; ++groupNum) {
            DVDIOUtil.writeAGroup(groupNum, 8, dvdArr, dos);
        }
        DVDIOUtil.writeAGroup(groupNum, numPartialCols, dvdArr, dos);
    }

    public static void writeParameterValueSet(ParameterValueSet pvs, int numEightColGroups, int numPartialCols, DataOutput dos) throws IOException, StandardException {
        int groupNum;
        if (GemFireXDUtils.TraceQuery | GemFireXDUtils.TraceNCJ) {
            StringBuilder paramStr = new StringBuilder("DVDIOUtil#writeParameterValueSet: writing parameter array with values [");
            for (int index = 0; index < pvs.getParameterCount(); ++index) {
                DataValueDescriptor dvd = pvs.getParameter(index);
                if (index > 0) {
                    paramStr.append(", ");
                }
                if (dvd != null) {
                    if (RowFormatter.isLob(dvd.getTypeFormatId())) {
                        paramStr.append('(').append(dvd.getTypeName()).append(";length=").append(dvd.getLength()).append(";hashCode=0x").append(Integer.toHexString(dvd.hashCode())).append(')');
                        continue;
                    }
                    paramStr.append(dvd.toString());
                    continue;
                }
                paramStr.append("(NULL)");
            }
            paramStr.append(']');
            SanityManager.DEBUG_PRINT((String)"QueryDistribution", (String)paramStr.toString());
        }
        for (groupNum = 0; groupNum < numEightColGroups; ++groupNum) {
            DVDIOUtil.writeAGroup(groupNum, 8, pvs, dos);
        }
        if (numPartialCols > 0) {
            DVDIOUtil.writeAGroup(groupNum, numPartialCols, pvs, dos);
        }
    }

    public static void readParameterValueSet(ParameterValueSet pvs, ByteArrayDataInput dis, int numEightColGrps, int numPartialCols) throws IOException, ClassNotFoundException, StandardException {
        int groupNum;
        for (groupNum = 0; groupNum < numEightColGrps; ++groupNum) {
            DVDIOUtil.readAGroup(groupNum, 8, pvs, dis);
        }
        if (numPartialCols > 0) {
            DVDIOUtil.readAGroup(groupNum, numPartialCols, pvs, dis);
        }
    }

    private static void writeAGroup(int groupNum, int numColsInGrp, DataValueDescriptor[] dvdArr, DataOutput dos) throws IOException {
        int dvdIndex;
        int index;
        byte activeByteForGroup = 0;
        for (index = 0; index < numColsInGrp; ++index) {
            dvdIndex = (groupNum << 3) + index;
            if (dvdArr[dvdIndex].isNull()) continue;
            activeByteForGroup = ActiveColumnBits.setFlagForNormalizedColumnPosition(index, activeByteForGroup);
        }
        DataSerializer.writePrimitiveByte((byte)activeByteForGroup, (DataOutput)dos);
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("DVDIOUtil::writeAGroup: activeByteForGroup=" + activeByteForGroup));
        }
        for (index = 0; index < numColsInGrp; ++index) {
            dvdIndex = (groupNum << 3) + index;
            if (ActiveColumnBits.isNormalizedColumnOn(index, activeByteForGroup)) {
                if (GemFireXDUtils.TraceRSIter) {
                    SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("DVDIOUtil::writeAGroup: writing DVD of type " + dvdArr[dvdIndex].getTypeName() + ", class: " + dvdArr[dvdIndex].getClass().getName()));
                }
                dvdArr[dvdIndex].toDataForOptimizedResultHolder(dos);
                continue;
            }
            if (!GemFireXDUtils.TraceRSIter) continue;
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("DVDIOUtil::writeAGroup: skipping null DVD of type " + dvdArr[dvdIndex].getTypeName() + ", class: " + dvdArr[dvdIndex].getClass().getName()));
        }
    }

    private static void writeAGroup(int groupNum, int numColsInGrp, ParameterValueSet pvs, DataOutput dos) throws IOException, StandardException {
        int dvdIndex;
        int index;
        byte activeByteForGroup = 0;
        for (index = 0; index < numColsInGrp; ++index) {
            dvdIndex = (groupNum << 3) + index;
            if (pvs.getParameter(dvdIndex).isNull()) continue;
            activeByteForGroup = ActiveColumnBits.setFlagForNormalizedColumnPosition(index, activeByteForGroup);
        }
        DataSerializer.writePrimitiveByte((byte)activeByteForGroup, (DataOutput)dos);
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("DVDIOUtil::writeAGroup: activeByteForGroup=" + activeByteForGroup));
        }
        for (index = 0; index < numColsInGrp; ++index) {
            dvdIndex = (groupNum << 3) + index;
            if (ActiveColumnBits.isNormalizedColumnOn(index, activeByteForGroup)) {
                if (GemFireXDUtils.TraceRSIter) {
                    SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("DVDIOUtil::writeAGroup: writing DVD of type " + pvs.getParameter(dvdIndex).getTypeName() + ", class: " + pvs.getParameter(dvdIndex).getClass().getName()));
                }
                pvs.getParameter(dvdIndex).toDataForOptimizedResultHolder(dos);
                continue;
            }
            if (!GemFireXDUtils.TraceRSIter) continue;
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("DVDIOUtil::writeAGroup: skipping null DVD of type " + pvs.getParameter(dvdIndex).getTypeName() + ", class: " + pvs.getParameter(dvdIndex).getClass().getName()));
        }
    }

    private static void readAGroup(int groupNum, int numColsInGrp, DataValueDescriptor[] dvds, DataInput dis) throws IOException, ClassNotFoundException {
        byte activeByteForGroup = DataSerializer.readPrimitiveByte((DataInput)dis);
        if (GemFireXDUtils.TraceRSIter) {
            SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("DVDIOUtil::readAGroup: activeByteForGroup=" + activeByteForGroup));
        }
        for (int index = 0; index < numColsInGrp; ++index) {
            int dvdIndex = (groupNum << 3) + index;
            if (ActiveColumnBits.isNormalizedColumnOn(index, activeByteForGroup)) {
                if (GemFireXDUtils.TraceRSIter) {
                    SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("DVDIOUtil::readAGroup: reading DVD of type " + dvds[dvdIndex].getTypeName() + ", class: " + dvds[dvdIndex].getClass().getName()));
                }
                dvds[dvdIndex].fromDataForOptimizedResultHolder(dis);
                continue;
            }
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("DVDIOUtil::readAGroup: skipping null DVD of type " + dvds[dvdIndex].getTypeName() + ", class: " + dvds[dvdIndex].getClass().getName()));
            }
            dvds[dvdIndex].setToNull();
        }
    }

    private static void readAGroup(int groupNum, int numColsInGrp, ParameterValueSet pvs, ByteArrayDataInput dis) throws IOException, ClassNotFoundException, StandardException {
        byte activeByteForGroup = DataSerializer.readPrimitiveByte((DataInput)dis);
        for (int index = 0; index < numColsInGrp; ++index) {
            int pvsIndex = (groupNum << 3) + index;
            DataValueDescriptor dvd = pvs.getParameterForSet(pvsIndex);
            if (ActiveColumnBits.isNormalizedColumnOn(index, activeByteForGroup)) {
                if (GemFireXDUtils.TraceRSIter) {
                    SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("DVDIOUtil::readAGroup: reading DVD of type " + dvd.getTypeName() + ", class: " + dvd.getClass().getName()));
                }
                dvd.fromDataForOptimizedResultHolder((DataInput)dis);
                continue;
            }
            if (GemFireXDUtils.TraceRSIter) {
                SanityManager.DEBUG_PRINT((String)"TraceRSIteration", (String)("DVDIOUtil::readAGroup: skipping null DVD of type " + dvd.getTypeName() + ", class: " + dvd.getClass().getName()));
            }
            dvd.setToNull();
        }
    }

    static {
        ByteArrayDataOutput.init();
    }
}

