/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.diag;

import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplate;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplateNoAllNodesRoute;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdMessage;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class DiskStoreIDs
extends GfxdVTITemplate
implements GfxdVTITemplateNoAllNodesRoute {
    private Iterator<DiskStoreInformation> diskStores;
    private DiskStoreInformation currentDiskStore;
    public static final String MEMBERID = "MEMBERID";
    public static final String NAME = "NAME";
    public static final String ID = "ID";
    public static final String DIRS = "DIRS";
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("MEMBERID", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("NAME", 12, false, 128), EmbedResultSetMetaData.getResultColumnDescriptor("ID", 1, false, 36), EmbedResultSetMetaData.getResultColumnDescriptor("DIRS", 12, false, 32672)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    @Override
    public boolean next() throws SQLException {
        GemFireCacheImpl cache;
        if (this.diskStores == null && (cache = GemFireCacheImpl.getInstance()) != null && !cache.isClosed()) {
            ArrayList allDiskStores = new ArrayList();
            for (ArrayList diskStores : (ArrayList)FunctionService.onMembers(GfxdMessage.getAllDSMembers()).execute("DiskStoreIDs").getResult()) {
                allDiskStores.addAll(diskStores);
            }
            this.diskStores = allDiskStores.iterator();
        }
        if (this.diskStores != null && this.diskStores.hasNext()) {
            this.currentDiskStore = this.diskStores.next();
            this.wasNull = false;
            return true;
        }
        this.currentDiskStore = null;
        return false;
    }

    @Override
    protected Object getObjectForColumn(int columnNumber) throws SQLException {
        ResultColumnDescriptor desc = columnInfo[columnNumber - 1];
        String columnName = desc.getName();
        String res = MEMBERID.equals(columnName) ? this.currentDiskStore.memberId : (NAME.equals(columnName) ? this.currentDiskStore.name : (ID.equals(columnName) ? this.currentDiskStore.id : (DIRS.equals(columnName) ? this.currentDiskStore.dirs : null)));
        return res;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return metadata;
    }

    public static final class DiskStoreIDFunction
    implements Function {
        private static final long serialVersionUID = -3904345941647806334L;
        public static final String ID = "DiskStoreIDs";

        public boolean hasResult() {
            return true;
        }

        public void execute(FunctionContext context) {
            GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
            if (cache != null && !cache.isClosed()) {
                Collection diskStores = cache.listDiskStoresIncludingRegionOwned();
                ArrayList<DiskStoreInformation> diskStoreInfos = new ArrayList<DiskStoreInformation>(diskStores.size());
                for (DiskStoreImpl ds : diskStores) {
                    StringBuilder dirs = new StringBuilder();
                    for (File dir : ds.getDiskDirs()) {
                        String dirPath;
                        if (dirs.length() > 0) {
                            dirs.append(',');
                        }
                        try {
                            dirPath = dir.getCanonicalPath();
                        }
                        catch (IOException ioe) {
                            dirPath = dir.getAbsolutePath();
                        }
                        dirs.append(dirPath);
                    }
                    diskStoreInfos.add(new DiskStoreInformation(cache.getMyId().getId(), ds.getName(), ds.getDiskStoreUUID().toString(), dirs.toString()));
                }
                context.getResultSender().lastResult(diskStoreInfos);
            } else {
                context.getResultSender().lastResult(new ArrayList(0));
            }
        }

        public String getId() {
            return ID;
        }

        public boolean optimizeForWrite() {
            return false;
        }

        public boolean isHA() {
            return false;
        }
    }

    static final class DiskStoreInformation
    implements Serializable {
        private static final long serialVersionUID = 2867776725673751094L;
        final String memberId;
        final String name;
        final String id;
        final String dirs;

        DiskStoreInformation(String memberId, String name, String id, String dirs) {
            this.memberId = memberId;
            this.name = name;
            this.id = id;
            this.dirs = dirs;
        }
    }
}

