/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.operations;

import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueueFactory;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.callbacks.AsyncEventListener;
import com.pivotal.gemfirexd.callbacks.DBSynchronizer;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.operations.AsyncQueueDropOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.GfxdGatewayEventListener;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.WanProcedures;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import java.io.IOException;

public class AsyncQueueCreateOperation
extends MemOperation {
    public final String id;
    public final boolean manualStart;
    public final boolean enableBatchConflation;
    public final int batchSize;
    public final int batchTimeInterval;
    public final boolean enablePersistence;
    public final boolean diskSync;
    public final String diskStoreName;
    public final int maximumQueueMemory;
    public final int alertThreshold;
    public final String className;
    public final String initParams;
    public final boolean isParallel;
    private final boolean enableBULKDMLStr;

    public AsyncQueueCreateOperation(String id, boolean manualStart, boolean enableBatchConflation, int batchSize, int batchTimeInterval, boolean enablePersistence, boolean diskSync, String diskStoreName, int maximumQueueMemory, int alertThreshold, boolean isParallel, String className, String initParams) {
        super(null);
        this.id = id;
        this.manualStart = manualStart;
        this.enableBatchConflation = enableBatchConflation;
        this.batchSize = batchSize;
        this.batchTimeInterval = batchTimeInterval;
        this.enablePersistence = enablePersistence;
        this.diskSync = diskSync;
        this.diskStoreName = diskStoreName;
        this.maximumQueueMemory = maximumQueueMemory;
        this.alertThreshold = alertThreshold;
        this.className = className;
        this.initParams = initParams;
        this.isParallel = isParallel;
        this.enableBULKDMLStr = true;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        try {
            GemFireCacheImpl cache = Misc.getGemFireCache();
            AsyncEventQueueFactory factory = cache.createAsyncEventQueueFactory();
            factory.setManualStart(this.manualStart);
            factory.setBatchConflationEnabled(this.enableBatchConflation);
            factory.setBatchSize(this.batchSize);
            factory.setBatchTimeInterval(this.batchTimeInterval);
            factory.setPersistent(this.enablePersistence);
            factory.setDiskSynchronous(this.diskSync);
            factory.setParallel(this.isParallel);
            if (this.diskStoreName != null) {
                if (GemFireCacheImpl.getInstance().findDiskStore(this.diskStoreName) == null) {
                    throw StandardException.newException("X0Z07.S", this.diskStoreName);
                }
                factory.setDiskStoreName(this.diskStoreName);
            } else {
                factory.setDiskStoreName("GFXD-DEFAULT-DISKSTORE");
            }
            factory.setMaximumQueueMemory(this.maximumQueueMemory);
            factory.setAlertThreshold(this.alertThreshold);
            Class c = ClassPathLoader.getLatest().forName(this.className);
            AsyncEventListener asyncListener = (AsyncEventListener)c.newInstance();
            if (!this.manualStart) {
                asyncListener.init(this.initParams);
            }
            GfxdGatewayEventListener evl = new GfxdGatewayEventListener(asyncListener, this.initParams);
            if (asyncListener instanceof DBSynchronizer) {
                factory.addGatewayEventFilter(WanProcedures.getSerialDBSynchronizerFilter(this.enableBULKDMLStr));
            } else {
                factory.addGatewayEventFilter(WanProcedures.getAsyncEventFilter());
            }
            factory.create(this.id, (com.gemstone.gemfire.cache.asyncqueue.AsyncEventListener)evl);
            if (!this.manualStart) {
                asyncListener.start();
            }
        }
        catch (Exception ex) {
            throw StandardException.newException("X0Z22.S", ex, (Object)this.id, (Object)ex.toString());
        }
    }

    @Override
    public MemOperation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        return new AsyncQueueDropOperation(this.id);
    }
}

