/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.index;

import com.gemstone.gemfire.internal.concurrent.ConcurrentSkipListMap;
import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndex;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndexController;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndexCostController;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndexScanController;
import com.pivotal.gemfirexd.internal.engine.access.index.SortedMap2IndexController;
import com.pivotal.gemfirexd.internal.engine.access.index.SortedMap2IndexCostController;
import com.pivotal.gemfirexd.internal.engine.access.index.SortedMap2IndexScanController;
import com.pivotal.gemfirexd.internal.engine.access.index.key.IndexKeyComparator;
import com.pivotal.gemfirexd.internal.engine.access.index.key.OffHeapIndexKeyComparator;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.ExtraIndexInfo;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeIndexKey;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class SortedMap2Index
extends MemIndex {
    private boolean caseSensitive = true;

    @Override
    public boolean fetchMaxOnBTree(TransactionManager tran, Transaction xact, long conglomId, int open_mode, int lock_level, LockingPolicy locking_policy, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] fetchRow) throws StandardException {
        ConcurrentSkipListMap<Object, Object> skipList = this.getGemFireContainer().getSkipListMap();
        int len = this.ascDescInfo.length - 1;
        Object key = this.ascDescInfo[0] ? skipList.lastValidKey() : skipList.firstValidKey();
        if (key == null) {
            return false;
        }
        if (key instanceof CompactCompositeIndexKey) {
            CompactCompositeIndexKey indexKey = (CompactCompositeIndexKey)key;
            if (scanColumnList == null) {
                for (int i = 0; i < len; ++i) {
                    fetchRow[i] = indexKey.getKeyColumn(i);
                }
            } else {
                int beyondBit = scanColumnList.anySetBit();
                int i = 0;
                while (beyondBit != -1) {
                    fetchRow[i] = indexKey.getKeyColumn(beyondBit);
                    ++i;
                    beyondBit = scanColumnList.anySetBit(beyondBit);
                }
            }
        } else if (len == 1) {
            fetchRow[0] = (DataValueDescriptor)key;
        } else {
            DataValueDescriptor[] indexKey = (DataValueDescriptor[])key;
            if (scanColumnList == null) {
                for (int i = 0; i < len; ++i) {
                    fetchRow[i] = indexKey[i];
                }
            } else {
                int beyondBit = scanColumnList.anySetBit();
                int i = 0;
                while (beyondBit != -1) {
                    fetchRow[i] = indexKey[beyondBit];
                    ++i;
                    beyondBit = scanColumnList.anySetBit(beyondBit);
                }
            }
        }
        return true;
    }

    @Override
    protected void allocateMemory(Properties properties, int tmpFlag) throws StandardException {
        ExtraIndexInfo extraInfo = new ExtraIndexInfo();
        properties.put("extraIndexInfo", extraInfo);
        String caseSensitiveStr = properties.getProperty("caseSensitive");
        this.caseSensitive = caseSensitiveStr == null || !"false".equalsIgnoreCase(caseSensitiveStr);
        IndexKeyComparator comparator = this.baseContainer.isOffHeap() ? new OffHeapIndexKeyComparator(this.keyColumns, this.ascDescInfo, this.caseSensitive) : new IndexKeyComparator(this.keyColumns, this.ascDescInfo, this.caseSensitive);
        properties.put("indexComparator", comparator);
        properties.put("baseConglomerateId", this.baseContainer.getId());
    }

    @Override
    protected MemIndexController newMemIndexController() {
        SortedMap2IndexController ret = new SortedMap2IndexController();
        return ret;
    }

    @Override
    protected MemIndexCostController newMemIndexCostController() {
        SortedMap2IndexCostController ret = new SortedMap2IndexCostController();
        return ret;
    }

    @Override
    protected MemIndexScanController newMemIndexScanController() {
        SortedMap2IndexScanController ret = new SortedMap2IndexScanController();
        return ret;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public String getIndexTypeName() {
        return "SortedMap2Index";
    }

    @Override
    public boolean caseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public int getHeight() throws StandardException {
        return this.getGemFireContainer().getSkipListMap().height();
    }

    @Override
    public void dumpIndex(String marker) {
        if (marker == null) {
            marker = "Skiplist iteration";
        }
        SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)("##### For SortedMap2Index " + this.container + ' ' + marker + " ----- begin #####"));
        ConcurrentSkipListMap<Object, Object> skipList = this.container.getSkipListMap();
        Set s = skipList.entrySet();
        String lineSep = SanityManager.lineSeparator;
        StringBuilder sb = new StringBuilder().append(lineSep);
        for (Map.Entry entry : s) {
            sb.append("\tkey=");
            ArrayUtils.objectString(entry.getKey(), (StringBuilder)sb);
            sb.append(", value=");
            ArrayUtils.objectStringNonRecursive(entry.getValue(), (StringBuilder)sb);
            sb.append(lineSep);
            if (sb.length() <= 0x400000) continue;
            SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)sb.toString());
            sb.setLength(0);
        }
        SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)sb.toString());
        SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)("##### For SortedMap2Index " + this.container + ' ' + marker + " ----- end #####"));
    }
}

