/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.index;

import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndexCostController;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.store.access.StoreCostResult;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;

public class Hash1IndexCostController
extends MemIndexCostController {
    private long row_size;
    private long numBaseRows;
    private static final double HASH_JOIN_COST_FACTOR = 100.0;

    @Override
    protected void postInit() {
        GemFireContainer baseContainer = this.open_conglom.getBaseContainer();
        this.row_size = baseContainer.getRowSize();
        this.numBaseRows = baseContainer.getNumRows();
        if (this.row_size < 1L) {
            this.row_size = 1L;
        }
        if (this.numBaseRows < 1L) {
            this.numBaseRows = 1L;
        }
    }

    @Override
    public long getEstimatedRowCount() throws StandardException {
        return this.numBaseRows;
    }

    @Override
    public double getFetchFromFullKeyCost(FormatableBitSet validColumns, int access_type, CostEstimate costEstimate) throws StandardException {
        int numIndexedColumns;
        int[] pkCols;
        double cardinality = 1.0;
        GemFireContainer baseContainer = this.open_conglom.getBaseContainer();
        if (baseContainer.getExtraTableInfo() != null && (pkCols = baseContainer.getExtraTableInfo().getPrimaryKeyColumns()) != null && (numIndexedColumns = pkCols.length) > 1) {
            cardinality /= 1.0 + (double)numIndexedColumns / 100.0;
        }
        double cost = cardinality * (double)this.row_size * 0.004;
        if (access_type != 1) {
            cost += 0.12;
        } else if ((cost += (double)this.numBaseRows * 0.14 * 100.0) <= 0.0) {
            cost = Double.MAX_VALUE;
        }
        if (costEstimate != null) {
            costEstimate.setCost(cost, 1.0, 1.0);
        }
        return cost;
    }

    @Override
    public void getScanCost(int scan_type, long row_count, int group_size, boolean forUpdate, FormatableBitSet scanColumnList, DataValueDescriptor[] template, DataValueDescriptor[] startKeyValue, int startSearchOperator, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, boolean reopen_scan, int access_type, StoreCostResult cost_result) throws StandardException {
        GemFireXDQueryObserver sqo = GemFireXDQueryObserverHolder.getInstance();
        if (access_type == 1 && scan_type != 1) {
            long estimated_row_count = 1L;
            double cost = (double)(1L * this.row_size) * 0.004;
            cost += 0.12;
            if (sqo != null) {
                cost = sqo.overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(this.open_conglom, cost);
            }
            cost_result.setEstimatedCost(cost);
            cost_result.setEstimatedRowCount(1L);
        } else {
            long rowCount = row_count < 1L ? this.numBaseRows : row_count;
            double cost = (double)(rowCount * this.row_size + 1L) * 0.004;
            cost += (double)rowCount * 0.12;
            if ((cost *= 100.0) <= 0.0) {
                cost = Double.MAX_VALUE;
            }
            if (sqo != null) {
                cost = sqo.overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(this.open_conglom, cost);
            }
            cost_result.setEstimatedCost(cost);
            cost_result.setEstimatedRowCount(row_count);
        }
    }
}

