/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.hadoop.mapreduce;

import com.gemstone.gemfire.cache.hdfs.internal.hoplog.mapreduce.HDFSSplitIterator;
import com.pivotal.gemfirexd.hadoop.mapreduce.Key;
import com.pivotal.gemfirexd.hadoop.mapreduce.Row;
import com.pivotal.gemfirexd.hadoop.mapreduce.RowInputFormat;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.store.entry.HDFSEventRowLocationRegionEntry;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TableScanResultSet;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowRecordReader
extends RecordReader<Key, Row> {
    private static final String PROTOCOL = "jdbc:gemfirexd:";
    private static final String DRIVER_FOR_STAND_ALONE_GEMFIREXD = "io.snappydata.jdbc.EmbeddedDriver";
    protected HDFSSplitIterator splitIterator;
    protected EmbedStatement es;
    protected EmbedResultSet rs;
    boolean isClosed;
    protected final Logger logger = LoggerFactory.getLogger(RowRecordReader.class);

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
        Configuration conf = context.getConfiguration();
        CombineFileSplit cSplit = (CombineFileSplit)split;
        Path[] path = cSplit.getPaths();
        long[] start = cSplit.getStartOffsets();
        long[] len = cSplit.getLengths();
        FileSystem fs = cSplit.getPath(0).getFileSystem(conf);
        long startTS = conf.getLong("gfxd.input.starttimemillis", 0L);
        long endTS = conf.getLong("gfxd.input.endtimemillis", 0L);
        this.splitIterator = HDFSSplitIterator.newInstance((FileSystem)fs, (Path[])path, (long[])start, (long[])len, (long)startTS, (long)endTS);
        this.instantiateGfxdLoner(conf);
    }

    protected void instantiateGfxdLoner(Configuration conf) throws IOException {
        String home = conf.get("gfxd.input.homedir", "gemfire");
        Properties props = new Properties();
        for (Map.Entry entry : conf) {
            String key = (String)entry.getKey();
            if (!key.startsWith("gfxd.input.property.") || (key = key.substring("gfxd.input.property.".length())).length() <= 0) continue;
            System.setProperty(key, (String)entry.getValue());
        }
        System.setProperty("gemfire.enable.slf4j.log.bridge", "true");
        System.setProperty("gemfire.disableManagement", "true");
        System.setProperty("gemfire.PERFORM_SECURE_HDFS_CHECK", "false");
        props.put("mcast-port", "0");
        props.put("locators", "");
        props.put("persist-dd", "false");
        props.put("hadoop.gemfirexd.loner.mode", "true");
        props.put("table-default-partitioned", "true");
        props.put("hadoop.gemfirexd.loner.homedirs", home);
        for (Map.Entry entry : conf) {
            props.put("hadoop.gemfirexd.loner.props." + (String)entry.getKey(), entry.getValue());
        }
        try {
            Class.forName(DRIVER_FOR_STAND_ALONE_GEMFIREXD).newInstance();
        }
        catch (InstantiationException e) {
            this.logger.error("Failed to instantiate stand alone reader", (Throwable)e);
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            this.logger.error("Failed to instantiate stand alone reader", (Throwable)e);
            throw new IOException(e);
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Gemfirexd classes are missing from the classpath", (Throwable)e);
            throw new IOException(e);
        }
        EmbedConnection conn = null;
        try {
            conn = (EmbedConnection)DriverManager.getConnection(PROTOCOL, props);
            LanguageConnectionContext context = conn.getLanguageConnectionContext();
            context.setHDFSSplit(this.splitIterator);
            String name = conf.get("gfxd.input.tablename");
            this.es = (EmbedStatement)conn.createStatement();
            name = RowInputFormat.getFullyQualifiedTableName(name);
            this.rs = (EmbedResultSet)this.es.executeQuery("select * from " + name);
            conn.getTR().setupContextStack();
            this.rs.pushStatementContext(context, true);
        }
        catch (SQLException e) {
            this.logger.error("Error in connecting to stand alone reader", (Throwable)e);
            throw new IOException(e);
        }
    }

    public final boolean nextKeyValue() throws IOException, InterruptedException {
        return this.nextRow();
    }

    protected final boolean nextRow() throws IOException {
        try {
            return this.rs.lightWeightNext();
        }
        catch (SQLException e) {
            return false;
        }
    }

    public final Key getCurrentKey() throws IOException, InterruptedException {
        Key key = new Key();
        key.setKey(this.getRowKeyBytes());
        return key;
    }

    protected final byte[] getRowKeyBytes() throws IOException {
        TableScanResultSet source = (TableScanResultSet)this.rs.getSourceResultSet();
        HDFSEventRowLocationRegionEntry rowLocation = null;
        try {
            rowLocation = (HDFSEventRowLocationRegionEntry)source.getRowLocation();
            return rowLocation.getRawKeyBytes();
        }
        catch (StandardException e) {
            this.logger.error("Error while trying to read row key", (Throwable)e);
            throw new IOException("Error trying to get row key", e);
        }
    }

    public final Row getCurrentValue() throws IOException, InterruptedException {
        return new Row(this.rs);
    }

    public float getProgress() throws IOException, InterruptedException {
        return this.getResultSetProgress();
    }

    protected float getResultSetProgress() {
        return 0.0f;
    }

    public void close() throws IOException {
        if (!this.isClosed) {
            GfxdConnectionWrapper.restoreContextStack(this.es, this.rs);
            try {
                this.rs.close();
            }
            catch (SQLException e) {
                this.logger.warn("Error while trying to free reader resources", (Throwable)e);
            }
            this.isClosed = true;
        }
    }
}

